/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTypeConverters;
import androidx.work.impl.utils.NetworkRequestCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlinx.coroutines.flow.Flow;

public final class WorkSpecDao_Impl
implements WorkSpecDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WorkSpec> __insertionAdapterOfWorkSpec;
    private final EntityDeletionOrUpdateAdapter<WorkSpec> __updateAdapterOfWorkSpec;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfSetState;
    private final SharedSQLiteStatement __preparedStmtOfSetCancelledState;
    private final SharedSQLiteStatement __preparedStmtOfIncrementPeriodCount;
    private final SharedSQLiteStatement __preparedStmtOfSetOutput;
    private final SharedSQLiteStatement __preparedStmtOfSetLastEnqueueTime;
    private final SharedSQLiteStatement __preparedStmtOfIncrementWorkSpecRunAttemptCount;
    private final SharedSQLiteStatement __preparedStmtOfResetWorkSpecRunAttemptCount;
    private final SharedSQLiteStatement __preparedStmtOfSetNextScheduleTimeOverride;
    private final SharedSQLiteStatement __preparedStmtOfResetWorkSpecNextScheduleTimeOverride;
    private final SharedSQLiteStatement __preparedStmtOfMarkWorkSpecScheduled;
    private final SharedSQLiteStatement __preparedStmtOfResetScheduledState;
    private final SharedSQLiteStatement __preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast;
    private final SharedSQLiteStatement __preparedStmtOfIncrementGeneration;
    private final SharedSQLiteStatement __preparedStmtOfSetStopReason;

    public WorkSpecDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfWorkSpec = new EntityInsertionAdapter<WorkSpec>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `WorkSpec` (`id`,`state`,`worker_class_name`,`input_merger_class_name`,`input`,`output`,`initial_delay`,`interval_duration`,`flex_duration`,`run_attempt_count`,`backoff_policy`,`backoff_delay_duration`,`last_enqueue_time`,`minimum_retention_duration`,`schedule_requested_at`,`run_in_foreground`,`out_of_quota_policy`,`period_count`,`generation`,`next_schedule_time_override`,`next_schedule_time_override_generation`,`stop_reason`,`trace_tag`,`required_network_type`,`required_network_request`,`requires_charging`,`requires_device_idle`,`requires_battery_not_low`,`requires_storage_not_low`,`trigger_content_update_delay`,`trigger_max_content_delay`,`content_uri_triggers`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull WorkSpec entity) {
                statement.bindString(1, entity.id);
                int _tmp = WorkTypeConverters.stateToInt(entity.state);
                statement.bindLong(2, (long)_tmp);
                statement.bindString(3, entity.workerClassName);
                statement.bindString(4, entity.inputMergerClassName);
                byte[] _tmp_1 = Data.toByteArrayInternalV1(entity.input);
                statement.bindBlob(5, _tmp_1);
                byte[] _tmp_2 = Data.toByteArrayInternalV1(entity.output);
                statement.bindBlob(6, _tmp_2);
                statement.bindLong(7, entity.initialDelay);
                statement.bindLong(8, entity.intervalDuration);
                statement.bindLong(9, entity.flexDuration);
                statement.bindLong(10, (long)entity.runAttemptCount);
                int _tmp_3 = WorkTypeConverters.backoffPolicyToInt(entity.backoffPolicy);
                statement.bindLong(11, (long)_tmp_3);
                statement.bindLong(12, entity.backoffDelayDuration);
                statement.bindLong(13, entity.lastEnqueueTime);
                statement.bindLong(14, entity.minimumRetentionDuration);
                statement.bindLong(15, entity.scheduleRequestedAt);
                int _tmp_4 = entity.expedited ? 1 : 0;
                statement.bindLong(16, (long)_tmp_4);
                int _tmp_5 = WorkTypeConverters.outOfQuotaPolicyToInt(entity.outOfQuotaPolicy);
                statement.bindLong(17, (long)_tmp_5);
                statement.bindLong(18, (long)entity.getPeriodCount());
                statement.bindLong(19, (long)entity.getGeneration());
                statement.bindLong(20, entity.getNextScheduleTimeOverride());
                statement.bindLong(21, (long)entity.getNextScheduleTimeOverrideGeneration());
                statement.bindLong(22, (long)entity.getStopReason());
                if (entity.getTraceTag() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getTraceTag());
                }
                Constraints _tmpConstraints = entity.constraints;
                int _tmp_6 = WorkTypeConverters.networkTypeToInt(_tmpConstraints.getRequiredNetworkType());
                statement.bindLong(24, (long)_tmp_6);
                byte[] _tmp_7 = WorkTypeConverters.fromNetworkRequest$work_runtime_release(_tmpConstraints.getRequiredNetworkRequestCompat$work_runtime_release());
                statement.bindBlob(25, _tmp_7);
                int _tmp_8 = _tmpConstraints.requiresCharging() ? 1 : 0;
                statement.bindLong(26, (long)_tmp_8);
                int _tmp_9 = _tmpConstraints.requiresDeviceIdle() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_9);
                int _tmp_10 = _tmpConstraints.requiresBatteryNotLow() ? 1 : 0;
                statement.bindLong(28, (long)_tmp_10);
                int _tmp_11 = _tmpConstraints.requiresStorageNotLow() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_11);
                statement.bindLong(30, _tmpConstraints.getContentTriggerUpdateDelayMillis());
                statement.bindLong(31, _tmpConstraints.getContentTriggerMaxDelayMillis());
                byte[] _tmp_12 = WorkTypeConverters.setOfTriggersToByteArray(_tmpConstraints.getContentUriTriggers());
                statement.bindBlob(32, _tmp_12);
            }
        };
        this.__updateAdapterOfWorkSpec = new EntityDeletionOrUpdateAdapter<WorkSpec>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `WorkSpec` SET `id` = ?,`state` = ?,`worker_class_name` = ?,`input_merger_class_name` = ?,`input` = ?,`output` = ?,`initial_delay` = ?,`interval_duration` = ?,`flex_duration` = ?,`run_attempt_count` = ?,`backoff_policy` = ?,`backoff_delay_duration` = ?,`last_enqueue_time` = ?,`minimum_retention_duration` = ?,`schedule_requested_at` = ?,`run_in_foreground` = ?,`out_of_quota_policy` = ?,`period_count` = ?,`generation` = ?,`next_schedule_time_override` = ?,`next_schedule_time_override_generation` = ?,`stop_reason` = ?,`trace_tag` = ?,`required_network_type` = ?,`required_network_request` = ?,`requires_charging` = ?,`requires_device_idle` = ?,`requires_battery_not_low` = ?,`requires_storage_not_low` = ?,`trigger_content_update_delay` = ?,`trigger_max_content_delay` = ?,`content_uri_triggers` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull WorkSpec entity) {
                statement.bindString(1, entity.id);
                int _tmp = WorkTypeConverters.stateToInt(entity.state);
                statement.bindLong(2, (long)_tmp);
                statement.bindString(3, entity.workerClassName);
                statement.bindString(4, entity.inputMergerClassName);
                byte[] _tmp_1 = Data.toByteArrayInternalV1(entity.input);
                statement.bindBlob(5, _tmp_1);
                byte[] _tmp_2 = Data.toByteArrayInternalV1(entity.output);
                statement.bindBlob(6, _tmp_2);
                statement.bindLong(7, entity.initialDelay);
                statement.bindLong(8, entity.intervalDuration);
                statement.bindLong(9, entity.flexDuration);
                statement.bindLong(10, (long)entity.runAttemptCount);
                int _tmp_3 = WorkTypeConverters.backoffPolicyToInt(entity.backoffPolicy);
                statement.bindLong(11, (long)_tmp_3);
                statement.bindLong(12, entity.backoffDelayDuration);
                statement.bindLong(13, entity.lastEnqueueTime);
                statement.bindLong(14, entity.minimumRetentionDuration);
                statement.bindLong(15, entity.scheduleRequestedAt);
                int _tmp_4 = entity.expedited ? 1 : 0;
                statement.bindLong(16, (long)_tmp_4);
                int _tmp_5 = WorkTypeConverters.outOfQuotaPolicyToInt(entity.outOfQuotaPolicy);
                statement.bindLong(17, (long)_tmp_5);
                statement.bindLong(18, (long)entity.getPeriodCount());
                statement.bindLong(19, (long)entity.getGeneration());
                statement.bindLong(20, entity.getNextScheduleTimeOverride());
                statement.bindLong(21, (long)entity.getNextScheduleTimeOverrideGeneration());
                statement.bindLong(22, (long)entity.getStopReason());
                if (entity.getTraceTag() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getTraceTag());
                }
                Constraints _tmpConstraints = entity.constraints;
                int _tmp_6 = WorkTypeConverters.networkTypeToInt(_tmpConstraints.getRequiredNetworkType());
                statement.bindLong(24, (long)_tmp_6);
                byte[] _tmp_7 = WorkTypeConverters.fromNetworkRequest$work_runtime_release(_tmpConstraints.getRequiredNetworkRequestCompat$work_runtime_release());
                statement.bindBlob(25, _tmp_7);
                int _tmp_8 = _tmpConstraints.requiresCharging() ? 1 : 0;
                statement.bindLong(26, (long)_tmp_8);
                int _tmp_9 = _tmpConstraints.requiresDeviceIdle() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_9);
                int _tmp_10 = _tmpConstraints.requiresBatteryNotLow() ? 1 : 0;
                statement.bindLong(28, (long)_tmp_10);
                int _tmp_11 = _tmpConstraints.requiresStorageNotLow() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_11);
                statement.bindLong(30, _tmpConstraints.getContentTriggerUpdateDelayMillis());
                statement.bindLong(31, _tmpConstraints.getContentTriggerMaxDelayMillis());
                byte[] _tmp_12 = WorkTypeConverters.setOfTriggersToByteArray(_tmpConstraints.getContentUriTriggers());
                statement.bindBlob(32, _tmp_12);
                statement.bindString(33, entity.id);
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM workspec WHERE id=?";
                return "DELETE FROM workspec WHERE id=?";
            }
        };
        this.__preparedStmtOfSetState = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET state=? WHERE id=?";
                return "UPDATE workspec SET state=? WHERE id=?";
            }
        };
        this.__preparedStmtOfSetCancelledState = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET stop_reason = CASE WHEN state=1 THEN 1 ELSE -256 END, state=5 WHERE id=?";
                return "UPDATE workspec SET stop_reason = CASE WHEN state=1 THEN 1 ELSE -256 END, state=5 WHERE id=?";
            }
        };
        this.__preparedStmtOfIncrementPeriodCount = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET period_count=period_count+1 WHERE id=?";
                return "UPDATE workspec SET period_count=period_count+1 WHERE id=?";
            }
        };
        this.__preparedStmtOfSetOutput = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET output=? WHERE id=?";
                return "UPDATE workspec SET output=? WHERE id=?";
            }
        };
        this.__preparedStmtOfSetLastEnqueueTime = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET last_enqueue_time=? WHERE id=?";
                return "UPDATE workspec SET last_enqueue_time=? WHERE id=?";
            }
        };
        this.__preparedStmtOfIncrementWorkSpecRunAttemptCount = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=?";
                return "UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=?";
            }
        };
        this.__preparedStmtOfResetWorkSpecRunAttemptCount = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET run_attempt_count=0 WHERE id=?";
                return "UPDATE workspec SET run_attempt_count=0 WHERE id=?";
            }
        };
        this.__preparedStmtOfSetNextScheduleTimeOverride = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET next_schedule_time_override=? WHERE id=?";
                return "UPDATE workspec SET next_schedule_time_override=? WHERE id=?";
            }
        };
        this.__preparedStmtOfResetWorkSpecNextScheduleTimeOverride = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET next_schedule_time_override=9223372036854775807 WHERE (id=? AND next_schedule_time_override_generation=?)";
                return "UPDATE workspec SET next_schedule_time_override=9223372036854775807 WHERE (id=? AND next_schedule_time_override_generation=?)";
            }
        };
        this.__preparedStmtOfMarkWorkSpecScheduled = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET schedule_requested_at=? WHERE id=?";
                return "UPDATE workspec SET schedule_requested_at=? WHERE id=?";
            }
        };
        this.__preparedStmtOfResetScheduledState = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)";
                return "UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)";
            }
        };
        this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
                return "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
            }
        };
        this.__preparedStmtOfIncrementGeneration = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET generation=generation+1 WHERE id=?";
                return "UPDATE workspec SET generation=generation+1 WHERE id=?";
            }
        };
        this.__preparedStmtOfSetStopReason = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE workspec SET stop_reason=? WHERE id=?";
                return "UPDATE workspec SET stop_reason=? WHERE id=?";
            }
        };
    }

    @Override
    public void insertWorkSpec(WorkSpec workSpec) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfWorkSpec.insert((Object)workSpec);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateWorkSpec(WorkSpec workSpec) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfWorkSpec.handle((Object)workSpec);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setState(WorkInfo.State state, String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetState.acquire();
        int _argIndex = 1;
        int _tmp = WorkTypeConverters.stateToInt(state);
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfSetState.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setCancelledState(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetCancelledState.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfSetCancelledState.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPeriodCount(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementPeriodCount.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfIncrementPeriodCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutput(String id, Data output) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetOutput.acquire();
        int _argIndex = 1;
        byte[] _tmp = Data.toByteArrayInternalV1(output);
        _stmt.bindBlob(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfSetOutput.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastEnqueueTime(String id, long enqueueTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetLastEnqueueTime.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, enqueueTime);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfSetLastEnqueueTime.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementWorkSpecRunAttemptCount(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementWorkSpecRunAttemptCount.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfIncrementWorkSpecRunAttemptCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetWorkSpecRunAttemptCount(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetWorkSpecRunAttemptCount.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfResetWorkSpecRunAttemptCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNextScheduleTimeOverride(String id, long nextScheduleTimeOverrideMillis) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetNextScheduleTimeOverride.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, nextScheduleTimeOverrideMillis);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfSetNextScheduleTimeOverride.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetWorkSpecNextScheduleTimeOverride(String id, int overrideGeneration) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetWorkSpecNextScheduleTimeOverride.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)overrideGeneration);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfResetWorkSpecNextScheduleTimeOverride.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int markWorkSpecScheduled(String id, long startTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkWorkSpecScheduled.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, startTime);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfMarkWorkSpecScheduled.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetScheduledState() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetScheduledState.acquire();
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfResetScheduledState.release(_stmt);
        }
    }

    @Override
    public void pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementGeneration(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementGeneration.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfIncrementGeneration.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStopReason(String id, int stopReason) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetStopReason.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)stopReason);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfSetStopReason.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpec getWorkSpec(String id) {
        String _sql = "SELECT * FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            WorkSpec _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                _result = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
            } else {
                _result = null;
            }
            WorkSpec workSpec = _result;
            return workSpec;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.IdAndState> getWorkSpecIdAndStatesForName(String name) {
        String _sql = "SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            boolean _cursorIndexOfId = false;
            boolean _cursorIndexOfState = true;
            ArrayList<WorkSpec.IdAndState> _result = new ArrayList<WorkSpec.IdAndState>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(0);
                int _tmp = _cursor.getInt(1);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                WorkSpec.IdAndState _item = new WorkSpec.IdAndState(_tmpId, _tmpState);
                _result.add(_item);
            }
            ArrayList<WorkSpec.IdAndState> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllWorkSpecIds() {
        String _sql = "SELECT id FROM workspec";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<String>> getAllWorkSpecIdsLiveData() {
        String _sql = "SELECT id FROM workspec";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"workspec"}, true, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<String> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<String> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                    try {
                        ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _item = _cursor.getString(0);
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkInfo.State getState(String id) {
        String _sql = "SELECT state FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT state FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Integer _tmp;
            WorkInfo.State _result = _cursor.moveToFirst() ? ((_tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0))) == null ? null : WorkTypeConverters.intToState(_tmp)) : null;
            WorkInfo.State state = _result;
            return state;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpec.WorkInfoPojo getWorkStatusPojoForId(String id) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            WorkSpec.WorkInfoPojo workInfoPojo;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                WorkSpec.WorkInfoPojo _result;
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfState = true;
                int _cursorIndexOfOutput = 2;
                int _cursorIndexOfRunAttemptCount = 3;
                int _cursorIndexOfGeneration = 4;
                int _cursorIndexOfRequiredNetworkType = 5;
                int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                int _cursorIndexOfRequiresCharging = 7;
                int _cursorIndexOfRequiresDeviceIdle = 8;
                int _cursorIndexOfRequiresBatteryNotLow = 9;
                int _cursorIndexOfRequiresStorageNotLow = 10;
                int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                int _cursorIndexOfContentUriTriggers = 13;
                int _cursorIndexOfInitialDelay = 14;
                int _cursorIndexOfIntervalDuration = 15;
                int _cursorIndexOfFlexDuration = 16;
                int _cursorIndexOfBackoffPolicy = 17;
                int _cursorIndexOfBackoffDelayDuration = 18;
                int _cursorIndexOfLastEnqueueTime = 19;
                int _cursorIndexOfPeriodCount = 20;
                int _cursorIndexOfNextScheduleTimeOverride = 21;
                int _cursorIndexOfStopReason = 22;
                HashMap<String, ArrayList<String>> _collectionTags = new HashMap<String, ArrayList<String>>();
                HashMap<String, ArrayList<Data>> _collectionProgress = new HashMap<String, ArrayList<Data>>();
                while (_cursor.moveToNext()) {
                    String _tmpKey_1;
                    String _tmpKey = _cursor.getString(0);
                    if (!_collectionTags.containsKey(_tmpKey)) {
                        _collectionTags.put(_tmpKey, new ArrayList());
                    }
                    if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                    _collectionProgress.put(_tmpKey_1, new ArrayList());
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                if (_cursor.moveToFirst()) {
                    String _tmpId = _cursor.getString(0);
                    int _tmp = _cursor.getInt(1);
                    WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(2);
                    Data _tmpOutput = Data.fromByteArray(_tmp_1);
                    int _tmpRunAttemptCount = _cursor.getInt(3);
                    int _tmpGeneration = _cursor.getInt(4);
                    long _tmpInitialDelay = _cursor.getLong(14);
                    long _tmpIntervalDuration = _cursor.getLong(15);
                    long _tmpFlexDuration = _cursor.getLong(16);
                    int _tmp_2 = _cursor.getInt(17);
                    BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                    long _tmpBackoffDelayDuration = _cursor.getLong(18);
                    long _tmpLastEnqueueTime = _cursor.getLong(19);
                    int _tmpPeriodCount = _cursor.getInt(20);
                    long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                    int _tmpStopReason = _cursor.getInt(22);
                    int _tmp_3 = _cursor.getInt(5);
                    NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                    byte[] _tmp_4 = _cursor.getBlob(6);
                    NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                    int _tmp_5 = _cursor.getInt(7);
                    boolean _tmpRequiresCharging = _tmp_5 != 0;
                    int _tmp_6 = _cursor.getInt(8);
                    boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                    int _tmp_7 = _cursor.getInt(9);
                    boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                    int _tmp_8 = _cursor.getInt(10);
                    boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                    long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                    long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                    byte[] _tmp_9 = _cursor.getBlob(13);
                    Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                    Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                    String _tmpKey_2 = _cursor.getString(0);
                    ArrayList<String> _tmpTagsCollection = _collectionTags.get(_tmpKey_2);
                    String _tmpKey_3 = _cursor.getString(0);
                    ArrayList<Data> _tmpProgressCollection = _collectionProgress.get(_tmpKey_3);
                    _result = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                workInfoPojo = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return workInfoPojo;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            _statement.bindString(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfState = true;
                int _cursorIndexOfOutput = 2;
                int _cursorIndexOfRunAttemptCount = 3;
                int _cursorIndexOfGeneration = 4;
                int _cursorIndexOfRequiredNetworkType = 5;
                int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                int _cursorIndexOfRequiresCharging = 7;
                int _cursorIndexOfRequiresDeviceIdle = 8;
                int _cursorIndexOfRequiresBatteryNotLow = 9;
                int _cursorIndexOfRequiresStorageNotLow = 10;
                int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                int _cursorIndexOfContentUriTriggers = 13;
                int _cursorIndexOfInitialDelay = 14;
                int _cursorIndexOfIntervalDuration = 15;
                int _cursorIndexOfFlexDuration = 16;
                int _cursorIndexOfBackoffPolicy = 17;
                int _cursorIndexOfBackoffDelayDuration = 18;
                int _cursorIndexOfLastEnqueueTime = 19;
                int _cursorIndexOfPeriodCount = 20;
                int _cursorIndexOfNextScheduleTimeOverride = 21;
                int _cursorIndexOfStopReason = 22;
                HashMap<String, ArrayList<String>> _collectionTags = new HashMap<String, ArrayList<String>>();
                HashMap<String, ArrayList<Data>> _collectionProgress = new HashMap<String, ArrayList<Data>>();
                while (_cursor.moveToNext()) {
                    String _tmpKey_1;
                    String _tmpKey = _cursor.getString(0);
                    if (!_collectionTags.containsKey(_tmpKey)) {
                        _collectionTags.put(_tmpKey, new ArrayList());
                    }
                    if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                    _collectionProgress.put(_tmpKey_1, new ArrayList());
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpId = _cursor.getString(0);
                    int _tmp = _cursor.getInt(1);
                    WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(2);
                    Data _tmpOutput = Data.fromByteArray(_tmp_1);
                    int _tmpRunAttemptCount = _cursor.getInt(3);
                    int _tmpGeneration = _cursor.getInt(4);
                    long _tmpInitialDelay = _cursor.getLong(14);
                    long _tmpIntervalDuration = _cursor.getLong(15);
                    long _tmpFlexDuration = _cursor.getLong(16);
                    int _tmp_2 = _cursor.getInt(17);
                    BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                    long _tmpBackoffDelayDuration = _cursor.getLong(18);
                    long _tmpLastEnqueueTime = _cursor.getLong(19);
                    int _tmpPeriodCount = _cursor.getInt(20);
                    long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                    int _tmpStopReason = _cursor.getInt(22);
                    int _tmp_3 = _cursor.getInt(5);
                    NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                    byte[] _tmp_4 = _cursor.getBlob(6);
                    NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                    int _tmp_5 = _cursor.getInt(7);
                    boolean _tmpRequiresCharging = _tmp_5 != 0;
                    int _tmp_6 = _cursor.getInt(8);
                    boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                    int _tmp_7 = _cursor.getInt(9);
                    boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                    int _tmp_8 = _cursor.getInt(10);
                    boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                    long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                    long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                    byte[] _tmp_9 = _cursor.getBlob(13);
                    Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                    Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                    String _tmpKey_2 = _cursor.getString(0);
                    ArrayList<String> _tmpTagsCollection = _collectionTags.get(_tmpKey_2);
                    String _tmpKey_3 = _cursor.getString(0);
                    ArrayList<Data> _tmpProgressCollection = _collectionProgress.get(_tmpKey_3);
                    WorkSpec.WorkInfoPojo _item_1 = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            _statement.bindString(_argIndex, _item);
            ++_argIndex;
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "WorkProgress", "workspec"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item_1 = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item_1);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowDataForIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            _statement.bindString(_argIndex, _item);
            ++_argIndex;
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"WorkTag", "WorkProgress", "workspec"}, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item_1 = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item_1);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForTag(String tag) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, tag);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfState = true;
                int _cursorIndexOfOutput = 2;
                int _cursorIndexOfRunAttemptCount = 3;
                int _cursorIndexOfGeneration = 4;
                int _cursorIndexOfRequiredNetworkType = 5;
                int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                int _cursorIndexOfRequiresCharging = 7;
                int _cursorIndexOfRequiresDeviceIdle = 8;
                int _cursorIndexOfRequiresBatteryNotLow = 9;
                int _cursorIndexOfRequiresStorageNotLow = 10;
                int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                int _cursorIndexOfContentUriTriggers = 13;
                int _cursorIndexOfInitialDelay = 14;
                int _cursorIndexOfIntervalDuration = 15;
                int _cursorIndexOfFlexDuration = 16;
                int _cursorIndexOfBackoffPolicy = 17;
                int _cursorIndexOfBackoffDelayDuration = 18;
                int _cursorIndexOfLastEnqueueTime = 19;
                int _cursorIndexOfPeriodCount = 20;
                int _cursorIndexOfNextScheduleTimeOverride = 21;
                int _cursorIndexOfStopReason = 22;
                HashMap<String, ArrayList<String>> _collectionTags = new HashMap<String, ArrayList<String>>();
                HashMap<String, ArrayList<Data>> _collectionProgress = new HashMap<String, ArrayList<Data>>();
                while (_cursor.moveToNext()) {
                    String _tmpKey_1;
                    String _tmpKey = _cursor.getString(0);
                    if (!_collectionTags.containsKey(_tmpKey)) {
                        _collectionTags.put(_tmpKey, new ArrayList());
                    }
                    if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                    _collectionProgress.put(_tmpKey_1, new ArrayList());
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpId = _cursor.getString(0);
                    int _tmp = _cursor.getInt(1);
                    WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(2);
                    Data _tmpOutput = Data.fromByteArray(_tmp_1);
                    int _tmpRunAttemptCount = _cursor.getInt(3);
                    int _tmpGeneration = _cursor.getInt(4);
                    long _tmpInitialDelay = _cursor.getLong(14);
                    long _tmpIntervalDuration = _cursor.getLong(15);
                    long _tmpFlexDuration = _cursor.getLong(16);
                    int _tmp_2 = _cursor.getInt(17);
                    BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                    long _tmpBackoffDelayDuration = _cursor.getLong(18);
                    long _tmpLastEnqueueTime = _cursor.getLong(19);
                    int _tmpPeriodCount = _cursor.getInt(20);
                    long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                    int _tmpStopReason = _cursor.getInt(22);
                    int _tmp_3 = _cursor.getInt(5);
                    NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                    byte[] _tmp_4 = _cursor.getBlob(6);
                    NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                    int _tmp_5 = _cursor.getInt(7);
                    boolean _tmpRequiresCharging = _tmp_5 != 0;
                    int _tmp_6 = _cursor.getInt(8);
                    boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                    int _tmp_7 = _cursor.getInt(9);
                    boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                    int _tmp_8 = _cursor.getInt(10);
                    boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                    long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                    long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                    byte[] _tmp_9 = _cursor.getBlob(13);
                    Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                    Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                    String _tmpKey_2 = _cursor.getString(0);
                    ArrayList<String> _tmpTagsCollection = _collectionTags.get(_tmpKey_2);
                    String _tmpKey_3 = _cursor.getString(0);
                    ArrayList<Data> _tmpProgressCollection = _collectionProgress.get(_tmpKey_3);
                    WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowForTag(String tag) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, tag);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"WorkTag", "WorkProgress", "workspec", "worktag"}, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForTag(String tag) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN\n            (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, tag);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "WorkProgress", "workspec", "worktag"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForName(String name) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfState = true;
                int _cursorIndexOfOutput = 2;
                int _cursorIndexOfRunAttemptCount = 3;
                int _cursorIndexOfGeneration = 4;
                int _cursorIndexOfRequiredNetworkType = 5;
                int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                int _cursorIndexOfRequiresCharging = 7;
                int _cursorIndexOfRequiresDeviceIdle = 8;
                int _cursorIndexOfRequiresBatteryNotLow = 9;
                int _cursorIndexOfRequiresStorageNotLow = 10;
                int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                int _cursorIndexOfContentUriTriggers = 13;
                int _cursorIndexOfInitialDelay = 14;
                int _cursorIndexOfIntervalDuration = 15;
                int _cursorIndexOfFlexDuration = 16;
                int _cursorIndexOfBackoffPolicy = 17;
                int _cursorIndexOfBackoffDelayDuration = 18;
                int _cursorIndexOfLastEnqueueTime = 19;
                int _cursorIndexOfPeriodCount = 20;
                int _cursorIndexOfNextScheduleTimeOverride = 21;
                int _cursorIndexOfStopReason = 22;
                HashMap<String, ArrayList<String>> _collectionTags = new HashMap<String, ArrayList<String>>();
                HashMap<String, ArrayList<Data>> _collectionProgress = new HashMap<String, ArrayList<Data>>();
                while (_cursor.moveToNext()) {
                    String _tmpKey_1;
                    String _tmpKey = _cursor.getString(0);
                    if (!_collectionTags.containsKey(_tmpKey)) {
                        _collectionTags.put(_tmpKey, new ArrayList());
                    }
                    if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                    _collectionProgress.put(_tmpKey_1, new ArrayList());
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpId = _cursor.getString(0);
                    int _tmp = _cursor.getInt(1);
                    WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(2);
                    Data _tmpOutput = Data.fromByteArray(_tmp_1);
                    int _tmpRunAttemptCount = _cursor.getInt(3);
                    int _tmpGeneration = _cursor.getInt(4);
                    long _tmpInitialDelay = _cursor.getLong(14);
                    long _tmpIntervalDuration = _cursor.getLong(15);
                    long _tmpFlexDuration = _cursor.getLong(16);
                    int _tmp_2 = _cursor.getInt(17);
                    BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                    long _tmpBackoffDelayDuration = _cursor.getLong(18);
                    long _tmpLastEnqueueTime = _cursor.getLong(19);
                    int _tmpPeriodCount = _cursor.getInt(20);
                    long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                    int _tmpStopReason = _cursor.getInt(22);
                    int _tmp_3 = _cursor.getInt(5);
                    NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                    byte[] _tmp_4 = _cursor.getBlob(6);
                    NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                    int _tmp_5 = _cursor.getInt(7);
                    boolean _tmpRequiresCharging = _tmp_5 != 0;
                    int _tmp_6 = _cursor.getInt(8);
                    boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                    int _tmp_7 = _cursor.getInt(9);
                    boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                    int _tmp_8 = _cursor.getInt(10);
                    boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                    long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                    long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                    byte[] _tmp_9 = _cursor.getBlob(13);
                    Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                    Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                    String _tmpKey_2 = _cursor.getString(0);
                    ArrayList<String> _tmpTagsCollection = _collectionTags.get(_tmpKey_2);
                    String _tmpKey_3 = _cursor.getString(0);
                    ArrayList<Data> _tmpProgressCollection = _collectionProgress.get(_tmpKey_3);
                    WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForName(String name) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "WorkProgress", "workspec", "workname"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoFlowForName(String name) {
        String _sql = "SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count, generation, required_network_type, required_network_request, requires_charging, requires_device_idle, requires_battery_not_low, requires_storage_not_low, trigger_content_update_delay, trigger_max_content_delay, content_uri_triggers, initial_delay, interval_duration, flex_duration, backoff_policy, backoff_delay_duration, last_enqueue_time, period_count, next_schedule_time_override, stop_reason FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"WorkTag", "WorkProgress", "workspec", "workname"}, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        boolean _cursorIndexOfId = false;
                        boolean _cursorIndexOfState = true;
                        int _cursorIndexOfOutput = 2;
                        int _cursorIndexOfRunAttemptCount = 3;
                        int _cursorIndexOfGeneration = 4;
                        int _cursorIndexOfRequiredNetworkType = 5;
                        int _cursorIndexOfRequiredNetworkRequestCompat = 6;
                        int _cursorIndexOfRequiresCharging = 7;
                        int _cursorIndexOfRequiresDeviceIdle = 8;
                        int _cursorIndexOfRequiresBatteryNotLow = 9;
                        int _cursorIndexOfRequiresStorageNotLow = 10;
                        int _cursorIndexOfContentTriggerUpdateDelayMillis = 11;
                        int _cursorIndexOfContentTriggerMaxDelayMillis = 12;
                        int _cursorIndexOfContentUriTriggers = 13;
                        int _cursorIndexOfInitialDelay = 14;
                        int _cursorIndexOfIntervalDuration = 15;
                        int _cursorIndexOfFlexDuration = 16;
                        int _cursorIndexOfBackoffPolicy = 17;
                        int _cursorIndexOfBackoffDelayDuration = 18;
                        int _cursorIndexOfLastEnqueueTime = 19;
                        int _cursorIndexOfPeriodCount = 20;
                        int _cursorIndexOfNextScheduleTimeOverride = 21;
                        int _cursorIndexOfStopReason = 22;
                        HashMap _collectionTags = new HashMap();
                        HashMap _collectionProgress = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            String _tmpKey = _cursor.getString(0);
                            if (!_collectionTags.containsKey(_tmpKey)) {
                                _collectionTags.put(_tmpKey, new ArrayList());
                            }
                            if (_collectionProgress.containsKey(_tmpKey_1 = _cursor.getString(0))) continue;
                            _collectionProgress.put(_tmpKey_1, new ArrayList());
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString(_collectionTags);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkProgressAsandroidxWorkData(_collectionProgress);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _tmpId = _cursor.getString(0);
                            int _tmp = _cursor.getInt(1);
                            WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(2);
                            Data _tmpOutput = Data.fromByteArray(_tmp_1);
                            int _tmpRunAttemptCount = _cursor.getInt(3);
                            int _tmpGeneration = _cursor.getInt(4);
                            long _tmpInitialDelay = _cursor.getLong(14);
                            long _tmpIntervalDuration = _cursor.getLong(15);
                            long _tmpFlexDuration = _cursor.getLong(16);
                            int _tmp_2 = _cursor.getInt(17);
                            BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_2);
                            long _tmpBackoffDelayDuration = _cursor.getLong(18);
                            long _tmpLastEnqueueTime = _cursor.getLong(19);
                            int _tmpPeriodCount = _cursor.getInt(20);
                            long _tmpNextScheduleTimeOverride = _cursor.getLong(21);
                            int _tmpStopReason = _cursor.getInt(22);
                            int _tmp_3 = _cursor.getInt(5);
                            NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_3);
                            byte[] _tmp_4 = _cursor.getBlob(6);
                            NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_4);
                            int _tmp_5 = _cursor.getInt(7);
                            boolean _tmpRequiresCharging = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(8);
                            boolean _tmpRequiresDeviceIdle = _tmp_6 != 0;
                            int _tmp_7 = _cursor.getInt(9);
                            boolean _tmpRequiresBatteryNotLow = _tmp_7 != 0;
                            int _tmp_8 = _cursor.getInt(10);
                            boolean _tmpRequiresStorageNotLow = _tmp_8 != 0;
                            long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(11);
                            long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(12);
                            byte[] _tmp_9 = _cursor.getBlob(13);
                            Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_9);
                            Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                            String _tmpKey_2 = _cursor.getString(0);
                            ArrayList _tmpTagsCollection = (ArrayList)_collectionTags.get(_tmpKey_2);
                            String _tmpKey_3 = _cursor.getString(0);
                            ArrayList _tmpProgressCollection = (ArrayList)_collectionProgress.get(_tmpKey_3);
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo(_tmpId, _tmpState, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpStopReason, _tmpTagsCollection, _tmpProgressCollection);
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Data> getInputsFromPrerequisites(String id) {
        String _sql = "SELECT output FROM workspec WHERE id IN\n             (SELECT prerequisite_id FROM dependency WHERE work_spec_id=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT output FROM workspec WHERE id IN\n             (SELECT prerequisite_id FROM dependency WHERE work_spec_id=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Data> _result = new ArrayList<Data>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                byte[] _tmp = _cursor.getBlob(0);
                Data _item = Data.fromByteArray(_tmp);
                _result.add(_item);
            }
            ArrayList<Data> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUnfinishedWorkWithTag(String tag) {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, tag);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUnfinishedWorkWithName(String name) {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllUnfinishedWork() {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<Boolean> hasUnfinishedWorkFlow() {
        String _sql = "SELECT COUNT(*) > 0 FROM workspec WHERE state NOT IN (2, 3, 5) LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) > 0 FROM workspec WHERE state NOT IN (2, 3, 5) LIMIT 1", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"workspec"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<Long> getScheduleRequestedAtLiveData(String id) {
        String _sql = "SELECT schedule_requested_at FROM workspec WHERE id=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT schedule_requested_at FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"workspec"}, false, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Long call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Long _result = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0))) : null;
                    Long l = _result;
                    return l;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getEligibleWorkForScheduling(int schedulerLimit) {
        String _sql = "SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 ORDER BY last_enqueue_time LIMIT (SELECT MAX(?-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND LENGTH(content_uri_triggers)=0 AND state NOT IN (2, 3, 5))";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 ORDER BY last_enqueue_time LIMIT (SELECT MAX(?-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND LENGTH(content_uri_triggers)=0 AND state NOT IN (2, 3, 5))", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)schedulerLimit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getEligibleWorkForSchedulingWithContentUris() {
        String _sql = "SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 AND LENGTH(content_uri_triggers)<>0 ORDER BY last_enqueue_time";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 AND LENGTH(content_uri_triggers)<>0 ORDER BY last_enqueue_time", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getAllEligibleWorkSpecsForScheduling(int maxLimit) {
        String _sql = "SELECT * FROM workspec WHERE state=0 ORDER BY last_enqueue_time LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 ORDER BY last_enqueue_time LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)maxLimit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getScheduledWork() {
        String _sql = "SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getRunningWork() {
        String _sql = "SELECT * FROM workspec WHERE state=1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getRecentlyCompletedWork(long startingAt) {
        String _sql = "SELECT * FROM workspec WHERE last_enqueue_time >= ? AND state IN (2, 3, 5) ORDER BY last_enqueue_time DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE last_enqueue_time >= ? AND state IN (2, 3, 5) ORDER BY last_enqueue_time DESC", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, startingAt);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfLastEnqueueTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_enqueue_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfExpedited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_in_foreground");
            int _cursorIndexOfOutOfQuotaPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"out_of_quota_policy");
            int _cursorIndexOfPeriodCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_count");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfNextScheduleTimeOverride = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override");
            int _cursorIndexOfNextScheduleTimeOverrideGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next_schedule_time_override_generation");
            int _cursorIndexOfStopReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stop_reason");
            int _cursorIndexOfTraceTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trace_tag");
            int _cursorIndexOfRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfRequiredNetworkRequestCompat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_request");
            int _cursorIndexOfRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfContentTriggerUpdateDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfContentTriggerMaxDelayMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                WorkInfo.State _tmpState = WorkTypeConverters.intToState(_tmp);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                String _tmpInputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfInput);
                Data _tmpInput = Data.fromByteArray(_tmp_1);
                byte[] _tmp_2 = _cursor.getBlob(_cursorIndexOfOutput);
                Data _tmpOutput = Data.fromByteArray(_tmp_2);
                long _tmpInitialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                long _tmpIntervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                long _tmpFlexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                int _tmpRunAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                BackoffPolicy _tmpBackoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_3);
                long _tmpBackoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                long _tmpLastEnqueueTime = _cursor.getLong(_cursorIndexOfLastEnqueueTime);
                long _tmpMinimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                long _tmpScheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfExpedited);
                boolean _tmpExpedited = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfOutOfQuotaPolicy);
                OutOfQuotaPolicy _tmpOutOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy(_tmp_5);
                int _tmpPeriodCount = _cursor.getInt(_cursorIndexOfPeriodCount);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                long _tmpNextScheduleTimeOverride = _cursor.getLong(_cursorIndexOfNextScheduleTimeOverride);
                int _tmpNextScheduleTimeOverrideGeneration = _cursor.getInt(_cursorIndexOfNextScheduleTimeOverrideGeneration);
                int _tmpStopReason = _cursor.getInt(_cursorIndexOfStopReason);
                String _tmpTraceTag = _cursor.isNull(_cursorIndexOfTraceTag) ? null : _cursor.getString(_cursorIndexOfTraceTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfRequiredNetworkType);
                NetworkType _tmpRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp_6);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfRequiredNetworkRequestCompat);
                NetworkRequestCompat _tmpRequiredNetworkRequestCompat = WorkTypeConverters.toNetworkRequest$work_runtime_release(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfRequiresCharging);
                boolean _tmpRequiresCharging = _tmp_8 != 0;
                int _tmp_9 = _cursor.getInt(_cursorIndexOfRequiresDeviceIdle);
                boolean _tmpRequiresDeviceIdle = _tmp_9 != 0;
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequiresBatteryNotLow);
                boolean _tmpRequiresBatteryNotLow = _tmp_10 != 0;
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequiresStorageNotLow);
                boolean _tmpRequiresStorageNotLow = _tmp_11 != 0;
                long _tmpContentTriggerUpdateDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerUpdateDelayMillis);
                long _tmpContentTriggerMaxDelayMillis = _cursor.getLong(_cursorIndexOfContentTriggerMaxDelayMillis);
                byte[] _tmp_12 = _cursor.getBlob(_cursorIndexOfContentUriTriggers);
                Set<Constraints.ContentUriTrigger> _tmpContentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers(_tmp_12);
                Constraints _tmpConstraints = new Constraints(_tmpRequiredNetworkRequestCompat, _tmpRequiredNetworkType, _tmpRequiresCharging, _tmpRequiresDeviceIdle, _tmpRequiresBatteryNotLow, _tmpRequiresStorageNotLow, _tmpContentTriggerUpdateDelayMillis, _tmpContentTriggerMaxDelayMillis, _tmpContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpState, _tmpWorkerClassName, _tmpInputMergerClassName, _tmpInput, _tmpOutput, _tmpInitialDelay, _tmpIntervalDuration, _tmpFlexDuration, _tmpConstraints, _tmpRunAttemptCount, _tmpBackoffPolicy, _tmpBackoffDelayDuration, _tmpLastEnqueueTime, _tmpMinimumRetentionDuration, _tmpScheduleRequestedAt, _tmpExpedited, _tmpOutOfQuotaPolicy, _tmpPeriodCount, _tmpGeneration, _tmpNextScheduleTimeOverride, _tmpNextScheduleTimeOverrideGeneration, _tmpStopReason, _tmpTraceTag);
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countNonFinishedContentUriTriggerWorkers() {
        String _sql = "Select COUNT(*) FROM workspec WHERE LENGTH(content_uri_triggers)<>0 AND state NOT IN (2, 3, 5)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select COUNT(*) FROM workspec WHERE LENGTH(content_uri_triggers)<>0 AND state NOT IN (2, 3, 5)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipWorkTagAsjavaLangString(@NonNull HashMap<String, ArrayList<String>> _map) {
        Set<String> __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            RelationUtil.recursiveFetchHashMap(_map, (boolean)true, map2 -> {
                this.__fetchRelationshipWorkTagAsjavaLangString((HashMap<String, ArrayList<String>>)map2);
                return Unit.INSTANCE;
            });
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `tag`,`work_spec_id` FROM `WorkTag` WHERE `work_spec_id` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            _stmt.bindString(_argIndex, _item);
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"work_spec_id");
            if (_itemKeyIndex == -1) {
                return;
            }
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList<String> _tmpRelation = _map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                String _item_1 = _cursor.getString(0);
                _tmpRelation.add(_item_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipWorkProgressAsandroidxWorkData(@NonNull HashMap<String, ArrayList<Data>> _map) {
        Set<String> __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            RelationUtil.recursiveFetchHashMap(_map, (boolean)true, map2 -> {
                this.__fetchRelationshipWorkProgressAsandroidxWorkData((HashMap<String, ArrayList<Data>>)map2);
                return Unit.INSTANCE;
            });
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `progress`,`work_spec_id` FROM `WorkProgress` WHERE `work_spec_id` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            _stmt.bindString(_argIndex, _item);
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"work_spec_id");
            if (_itemKeyIndex == -1) {
                return;
            }
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList<Data> _tmpRelation = _map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                byte[] _tmp = _cursor.getBlob(0);
                Data _item_1 = Data.fromByteArray(_tmp);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

