/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SystemIdInfoDao_Impl
implements SystemIdInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SystemIdInfo> __insertionAdapterOfSystemIdInfo;
    private final SharedSQLiteStatement __preparedStmtOfRemoveSystemIdInfo;
    private final SharedSQLiteStatement __preparedStmtOfRemoveSystemIdInfo_1;

    public SystemIdInfoDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSystemIdInfo = new EntityInsertionAdapter<SystemIdInfo>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `SystemIdInfo` (`work_spec_id`,`generation`,`system_id`) VALUES (?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull SystemIdInfo entity) {
                statement.bindString(1, entity.workSpecId);
                statement.bindLong(2, (long)entity.getGeneration());
                statement.bindLong(3, (long)entity.systemId);
            }
        };
        this.__preparedStmtOfRemoveSystemIdInfo = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM SystemIdInfo where work_spec_id=? AND generation=?";
                return "DELETE FROM SystemIdInfo where work_spec_id=? AND generation=?";
            }
        };
        this.__preparedStmtOfRemoveSystemIdInfo_1 = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM SystemIdInfo where work_spec_id=?";
                return "DELETE FROM SystemIdInfo where work_spec_id=?";
            }
        };
    }

    @Override
    public void insertSystemIdInfo(SystemIdInfo systemIdInfo) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSystemIdInfo.insert((Object)systemIdInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSystemIdInfo(String workSpecId, int generation) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveSystemIdInfo.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, workSpecId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)generation);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfRemoveSystemIdInfo.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSystemIdInfo(String workSpecId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveSystemIdInfo_1.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, workSpecId);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfRemoveSystemIdInfo_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemIdInfo getSystemIdInfo(String workSpecId, int generation) {
        String _sql = "SELECT * FROM SystemIdInfo WHERE work_spec_id=? AND generation=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SystemIdInfo WHERE work_spec_id=? AND generation=?", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, workSpecId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)generation);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            SystemIdInfo _result;
            int _cursorIndexOfWorkSpecId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"work_spec_id");
            int _cursorIndexOfGeneration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"generation");
            int _cursorIndexOfSystemId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"system_id");
            if (_cursor.moveToFirst()) {
                String _tmpWorkSpecId = _cursor.getString(_cursorIndexOfWorkSpecId);
                int _tmpGeneration = _cursor.getInt(_cursorIndexOfGeneration);
                int _tmpSystemId = _cursor.getInt(_cursorIndexOfSystemId);
                _result = new SystemIdInfo(_tmpWorkSpecId, _tmpGeneration, _tmpSystemId);
            } else {
                _result = null;
            }
            SystemIdInfo systemIdInfo = _result;
            return systemIdInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkSpecIds() {
        String _sql = "SELECT DISTINCT work_spec_id FROM SystemIdInfo";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT work_spec_id FROM SystemIdInfo", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

