/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils.taskexecutor;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.impl.utils.SerialExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkManagerTaskExecutor
implements TaskExecutor {
    private final Executor mBackgroundExecutor;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final Executor mMainThreadExecutor = new Executor(){

        @Override
        public void execute(@NonNull Runnable command) {
            WorkManagerTaskExecutor.this.postToMainThread(command);
        }
    };

    public WorkManagerTaskExecutor(@NonNull Executor backgroundExecutor) {
        this.mBackgroundExecutor = new SerialExecutor(backgroundExecutor);
    }

    @Override
    public void postToMainThread(Runnable r) {
        this.mMainThreadHandler.post(r);
    }

    @Override
    public Executor getMainThreadExecutor() {
        return this.mMainThreadExecutor;
    }

    @Override
    public void executeOnBackgroundThread(Runnable r) {
        this.mBackgroundExecutor.execute(r);
    }

    @Override
    public Executor getBackgroundExecutor() {
        return this.mBackgroundExecutor;
    }
}

