/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.controllers.BatteryChargingController;
import androidx.work.impl.constraints.controllers.BatteryNotLowController;
import androidx.work.impl.constraints.controllers.ConstraintController;
import androidx.work.impl.constraints.controllers.NetworkConnectedController;
import androidx.work.impl.constraints.controllers.NetworkMeteredController;
import androidx.work.impl.constraints.controllers.NetworkNotRoamingController;
import androidx.work.impl.constraints.controllers.NetworkUnmeteredController;
import androidx.work.impl.constraints.controllers.StorageNotLowController;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.List;

public class WorkConstraintsTracker
implements ConstraintController.OnConstraintUpdatedCallback {
    private static final String TAG = Logger.tagWithPrefix("WorkConstraintsTracker");
    @Nullable
    private final WorkConstraintsCallback mCallback;
    private final ConstraintController[] mConstraintControllers;
    private final Object mLock;

    public WorkConstraintsTracker(Context context, @Nullable WorkConstraintsCallback callback) {
        Context appContext = context.getApplicationContext();
        this.mCallback = callback;
        this.mConstraintControllers = new ConstraintController[]{new BatteryChargingController(appContext), new BatteryNotLowController(appContext), new StorageNotLowController(appContext), new NetworkConnectedController(appContext), new NetworkUnmeteredController(appContext), new NetworkNotRoamingController(appContext), new NetworkMeteredController(appContext)};
        this.mLock = new Object();
    }

    @VisibleForTesting
    WorkConstraintsTracker(@Nullable WorkConstraintsCallback callback, ConstraintController[] controllers) {
        this.mCallback = callback;
        this.mConstraintControllers = controllers;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(@NonNull List<WorkSpec> workSpecs) {
        Object object = this.mLock;
        synchronized (object) {
            for (ConstraintController controller : this.mConstraintControllers) {
                controller.setCallback(null);
            }
            for (ConstraintController controller : this.mConstraintControllers) {
                controller.replace(workSpecs);
            }
            for (ConstraintController controller : this.mConstraintControllers) {
                controller.setCallback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            for (ConstraintController controller : this.mConstraintControllers) {
                controller.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllConstraintsMet(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            for (ConstraintController constraintController : this.mConstraintControllers) {
                if (!constraintController.isWorkSpecConstrained(workSpecId)) continue;
                Logger.get().debug(TAG, String.format("Work %s constrained by %s", workSpecId, constraintController.getClass().getSimpleName()), new Throwable[0]);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConstraintMet(@NonNull List<String> workSpecIds) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<String> unconstrainedWorkSpecIds = new ArrayList<String>();
            for (String workSpecId : workSpecIds) {
                if (!this.areAllConstraintsMet(workSpecId)) continue;
                Logger.get().debug(TAG, String.format("Constraints met for %s", workSpecId), new Throwable[0]);
                unconstrainedWorkSpecIds.add(workSpecId);
            }
            if (this.mCallback != null) {
                this.mCallback.onAllConstraintsMet(unconstrainedWorkSpecIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConstraintNotMet(@NonNull List<String> workSpecIds) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback != null) {
                this.mCallback.onAllConstraintsNotMet(workSpecIds);
            }
        }
    }
}

