/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DownloadBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\"\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J \u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J&\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180%2\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate;", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "retryOnNetworkGain", "", "globalAutoRetryMaxAttempts", "", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/FetchListener;ZI)V", "interrupted", "getInterrupted", "()Z", "setInterrupted", "(Z)V", "getNewDownloadInfoInstance", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "onComplete", "", "download", "Lcom/tonyodev/fetch2/Download;", "onDownloadBlockUpdated", "downloadBlock", "Lcom/tonyodev/fetch2core/DownloadBlock;", "totalBlocks", "onError", "error", "Lcom/tonyodev/fetch2/Error;", "throwable", "", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onStarted", "downloadBlocks", "", "saveDownloadProgress", "fetch2_release"})
public final class FileDownloaderDelegate
implements FileDownloader.Delegate {
    private volatile boolean interrupted;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final FetchListener fetchListener;
    private final boolean retryOnNetworkGain;
    private final int globalAutoRetryMaxAttempts;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public void onStarted(@NotNull Download download, @NotNull List<? extends DownloadBlock> downloadBlocks, int totalBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull(downloadBlocks, (String)"downloadBlocks");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo2 = (DownloadInfo)download;
            downloadInfo2.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.update(downloadInfo2);
            this.fetchListener.onStarted(download, downloadBlocks, totalBlocks);
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            this.fetchListener.onProgress(download, etaInMilliSeconds, downloadedBytesPerSecond);
        }
    }

    @Override
    public void onDownloadBlockUpdated(@NotNull Download download, @NotNull DownloadBlock downloadBlock2, int totalBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)downloadBlock2, (String)"downloadBlock");
        if (!this.getInterrupted()) {
            this.fetchListener.onDownloadBlockUpdated(download, downloadBlock2, totalBlocks);
        }
    }

    @Override
    public void onError(@NotNull Download download, @NotNull Error error, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)((Object)error), (String)"error");
        if (!this.getInterrupted()) {
            int maxAutoRetryAttempts = this.globalAutoRetryMaxAttempts != -1 ? this.globalAutoRetryMaxAttempts : download.getAutoRetryMaxAttempts();
            DownloadInfo downloadInfo2 = (DownloadInfo)download;
            if (this.retryOnNetworkGain && downloadInfo2.getError() == Error.NO_NETWORK_CONNECTION) {
                downloadInfo2.setStatus(Status.QUEUED);
                downloadInfo2.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo2);
                this.fetchListener.onQueued(download, true);
            } else if (((DownloadInfo)download).getAutoRetryAttempts() < maxAutoRetryAttempts) {
                DownloadInfo downloadInfo3 = (DownloadInfo)download;
                downloadInfo3.setAutoRetryAttempts(downloadInfo3.getAutoRetryAttempts() + 1);
                downloadInfo2.setStatus(Status.QUEUED);
                downloadInfo2.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo2);
                this.fetchListener.onQueued(download, true);
            } else {
                downloadInfo2.setStatus(Status.FAILED);
                this.downloadInfoUpdater.update(downloadInfo2);
                this.fetchListener.onError(download, error, throwable);
            }
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo2 = (DownloadInfo)download;
            downloadInfo2.setStatus(Status.COMPLETED);
            this.downloadInfoUpdater.update(downloadInfo2);
            this.fetchListener.onCompleted(download);
        }
    }

    @Override
    public void saveDownloadProgress(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo2 = (DownloadInfo)download;
            downloadInfo2.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo2);
        }
    }

    @Override
    @NotNull
    public DownloadInfo getNewDownloadInfoInstance() {
        return this.downloadInfoUpdater.getNewDownloadInfoInstance();
    }

    public FileDownloaderDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull FetchListener fetchListener, boolean retryOnNetworkGain, int globalAutoRetryMaxAttempts) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)fetchListener, (String)"fetchListener");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.fetchListener = fetchListener;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.globalAutoRetryMaxAttempts = globalAutoRetryMaxAttempts;
    }
}

