/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.storage.file;

import android.net.Uri;
import androidx.test.annotation.ExperimentalTestApi;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalTestApi
public final class HostedFile {
    public static Uri buildUri(FileHost host, String fileName) {
        return new Uri.Builder().scheme("content").authority(host.getAuthority()).path(fileName).build();
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private HostedFile() {
    }

    public static enum FileHost {
        TEST_FILE("androidx.test.services.storage.runfiles", false),
        EXPORT_PROPERTIES("androidx.test.services.storage.properties", true),
        OUTPUT("androidx.test.services.storage.outputfiles", true),
        INTERNAL_USE_ONLY("androidx.test.services.storage._internal_use_files", true);

        private final String authority;
        private final boolean writeable;

        public String getAuthority() {
            return this.authority;
        }

        private FileHost(String authority, boolean writeable) {
            this.authority = (String)HostedFile.checkNotNull(authority);
            this.writeable = writeable;
        }

        public boolean isWritable() {
            return this.writeable;
        }
    }

    public static enum FileType {
        FILE("f"),
        DIRECTORY("d");

        private String type;

        public static FileType fromTypeCode(String type) {
            for (FileType fileType : FileType.values()) {
                if (!fileType.getTypeCode().equals(type)) continue;
                return fileType;
            }
            String string = type;
            throw new IllegalArgumentException("unknown type: " + string);
        }

        public String getTypeCode() {
            return this.type;
        }

        private FileType(String type) {
            this.type = (String)HostedFile.checkNotNull(type);
        }
    }

    public static enum HostedFileColumn {
        NAME("name", String.class, 3, 0),
        TYPE("type", String.class, 3, 1),
        SIZE("size", Long.class, 1, 2),
        DATA("_data", Byte[].class, 4, 3),
        DISPLAY_NAME("_display_name", String.class, 3, 4),
        SIZE_2("_size", Long.class, 2, 5);

        private final String columnName;
        private final Class<?> columnType;
        private final int androidType;
        private final int position;

        public int getAndroidType() {
            return this.androidType;
        }

        public int getPosition() {
            return this.position;
        }

        public Class<?> getColumnType() {
            return this.columnType;
        }

        public String getColumnName() {
            return this.columnName;
        }

        private HostedFileColumn(String columnName, Class<?> columnType, int androidType, int position) {
            this.columnName = (String)HostedFile.checkNotNull(columnName);
            this.columnType = (Class)HostedFile.checkNotNull(columnType);
            this.androidType = androidType;
            this.position = position;
        }

        public static String[] getColumnNames() {
            HostedFileColumn[] columns = HostedFileColumn.values();
            String[] names = new String[columns.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = columns[i].getColumnName();
            }
            return names;
        }
    }
}

