/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.storage;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.services.storage.ExperimentalTestStorage;
import androidx.test.services.storage.TestStorageException;
import androidx.test.services.storage.file.HostedFile;
import androidx.test.services.storage.file.PropertyFile;
import androidx.test.services.storage.internal.TestStorageUtil;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@ExperimentalTestStorage
public final class TestStorage {
    private static final String TAG = TestStorage.class.getSimpleName();
    private static final String PROPERTIES_FILE_NAME = "properties.dat";
    private final ContentResolver contentResolver;

    public TestStorage() {
        this(InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver());
    }

    public TestStorage(@Nonnull ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
    }

    public static Uri getInputFileUri(@Nonnull String pathname) {
        Checks.checkNotNull((Object)pathname);
        return HostedFile.buildUri(HostedFile.FileHost.TEST_FILE, pathname);
    }

    public static Uri getOutputFileUri(@Nonnull String pathname) {
        Checks.checkNotNull((Object)pathname);
        return HostedFile.buildUri(HostedFile.FileHost.OUTPUT, pathname);
    }

    public InputStream openInputFile(@Nonnull String pathname) throws FileNotFoundException {
        Uri dataUri = TestStorage.getInputFileUri(pathname);
        return TestStorageUtil.getInputStream(dataUri, this.contentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInputArg(@Nonnull String argName) {
        Checks.checkNotNull((Object)argName);
        Uri testArgUri = PropertyFile.buildUri(PropertyFile.Authority.TEST_ARGS, argName);
        try (Cursor cursor = null;){
            cursor = TestStorage.doQuery(this.contentResolver, testArgUri);
            if (cursor.getCount() == 0) {
                throw new TestStorageException(String.format("Query for URI '%s' did not return any results. Make sure the argName is actually being passed in as a test argument.", testArgUri));
            }
            if (cursor.getCount() > 1) {
                throw new TestStorageException(String.format("Query for URI '%s' returned more than one result. Weird.", testArgUri));
            }
            cursor.moveToFirst();
            String string = cursor.getString(PropertyFile.Column.VALUE.getPosition());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInputArgs() {
        Uri testArgUri = PropertyFile.buildUri(PropertyFile.Authority.TEST_ARGS);
        try (Cursor cursor = null;){
            cursor = TestStorage.doQuery(this.contentResolver, testArgUri);
            Map<String, String> map = TestStorage.getProperties(cursor);
            return map;
        }
    }

    public OutputStream openOutputFile(@Nonnull String pathname) throws FileNotFoundException {
        Checks.checkNotNull((Object)pathname);
        Uri outputUri = TestStorage.getOutputFileUri(pathname);
        return TestStorageUtil.getOutputStream(outputUri, this.contentResolver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOutputProperties(Map<String, Serializable> properties) {
        if (properties == null) return;
        if (properties.isEmpty()) {
            return;
        }
        Map<String, Serializable> allProperties = this.getOutputProperties();
        allProperties.putAll(properties);
        Uri propertyFileUri = TestStorage.getPropertyFileUri();
        ObjectOutputStream objectOutputStream = null;
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(TestStorageUtil.getOutputStream(propertyFileUri, this.contentResolver));
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(allProperties);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new TestStorageException("Unable to create file", ex);
                catch (IOException e) {
                    throw new TestStorageException("I/O error occurred during reading test properties.", e);
                }
            }
            catch (Throwable throwable) {
                TestStorage.silentlyClose(objectOutputStream);
                throw throwable;
            }
        }
        TestStorage.silentlyClose(objectOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, Serializable> getOutputProperties() {
        block8: {
            Map map;
            Map recordedProperties;
            InputStream rawStream;
            ObjectInputStream in;
            Uri propertyFileUri;
            block7: {
                propertyFileUri = TestStorage.getPropertyFileUri();
                in = null;
                rawStream = null;
                rawStream = TestStorageUtil.getInputStream(propertyFileUri, this.contentResolver);
                in = new ObjectInputStream(rawStream);
                recordedProperties = (Map)in.readObject();
                if (recordedProperties != null) break block7;
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                TestStorage.silentlyClose(in);
                TestStorage.silentlyClose(rawStream);
                return hashMap;
            }
            try {
                map = recordedProperties;
            }
            catch (FileNotFoundException fnfe) {
                Log.i((String)TAG, (String)String.format("%s: does not exist, we must be the first call.", propertyFileUri));
                TestStorage.silentlyClose(in);
                TestStorage.silentlyClose(rawStream);
                break block8;
            }
            catch (IOException | ClassNotFoundException e) {
                Log.w((String)TAG, (String)"Failed to read recorded stats!", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        TestStorage.silentlyClose(in);
                        TestStorage.silentlyClose(rawStream);
                        throw throwable;
                    }
                }
                TestStorage.silentlyClose(in);
                TestStorage.silentlyClose(rawStream);
            }
            TestStorage.silentlyClose(in);
            TestStorage.silentlyClose(rawStream);
            return map;
        }
        return new HashMap<String, Serializable>();
    }

    private static Uri getPropertyFileUri() {
        return HostedFile.buildUri(HostedFile.FileHost.EXPORT_PROPERTIES, PROPERTIES_FILE_NAME);
    }

    private static Cursor doQuery(ContentResolver resolver, Uri uri) {
        Checks.checkNotNull((Object)resolver);
        Checks.checkNotNull((Object)uri);
        Cursor cursor = resolver.query(uri, null, null, null, null);
        if (cursor == null) {
            throw new TestStorageException(String.format("Failed to resolve query for URI: %s", uri));
        }
        return cursor;
    }

    private static Map<String, String> getProperties(Cursor cursor) {
        Checks.checkNotNull((Object)cursor);
        HashMap<String, String> properties = new HashMap<String, String>();
        while (cursor.moveToNext()) {
            properties.put(cursor.getString(PropertyFile.Column.NAME.getPosition()), cursor.getString(PropertyFile.Column.VALUE.getPosition()));
        }
        return properties;
    }

    private static void silentlyClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void silentlyClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

