/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.test.services.events.platform.TestCaseErrorEvent;
import androidx.test.services.events.platform.TestCaseFinishedEvent;
import androidx.test.services.events.platform.TestCaseStartedEvent;
import androidx.test.services.events.platform.TestPlatformEvent;
import androidx.test.services.events.platform.TestRunErrorEvent;
import androidx.test.services.events.platform.TestRunFinishedEvent;
import androidx.test.services.events.platform.TestRunStartedEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TestPlatformEventFactory
implements Parcelable.Creator<TestPlatformEvent> {
    public TestPlatformEvent createFromParcel(Parcel source) {
        TestPlatformEvent.EventType instanceType = TestPlatformEvent.EventType.valueOf(source.readString());
        switch (instanceType) {
            case TEST_RUN_STARTED: {
                return new TestRunStartedEvent(source);
            }
            case TEST_RUN_ERROR: {
                return new TestRunErrorEvent(source);
            }
            case TEST_CASE_STARTED: {
                return new TestCaseStartedEvent(source);
            }
            case TEST_CASE_ERROR: {
                return new TestCaseErrorEvent(source);
            }
            case TEST_CASE_FINISHED: {
                return new TestCaseFinishedEvent(source);
            }
            case TEST_RUN_FINISHED: {
                return new TestRunFinishedEvent(source);
            }
        }
        throw new IllegalArgumentException("Unhandled event type: " + (Object)((Object)instanceType));
    }

    public TestPlatformEvent[] newArray(int size) {
        return new TestPlatformEvent[size];
    }
}

