/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.app.Instrumentation;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.test.internal.runner.InstrumentationConnection;
import androidx.test.internal.util.Checks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class ActivityFinisherRunListener
extends RunListener {
    private final Instrumentation instrumentation;
    private final NotifyingRunnable activityFinisher;
    private final Runnable waitForActivitiesToStopRunnable;
    private final Handler handler;

    public ActivityFinisherRunListener(Instrumentation instrumentation, Runnable finisher, Runnable waitForActivitiesToStopRunnable) {
        this.instrumentation = (Instrumentation)Checks.checkNotNull((Object)instrumentation);
        this.activityFinisher = new NotifyingRunnable((Runnable)Checks.checkNotNull((Object)finisher));
        this.waitForActivitiesToStopRunnable = (Runnable)Checks.checkNotNull((Object)waitForActivitiesToStopRunnable);
        this.handler = new Handler(Looper.getMainLooper());
    }

    public void testStarted(Description description) throws Exception {
        this.runActivityFinisher();
        this.waitForActivitiesToStopRunnable.run();
    }

    private void runActivityFinisher() throws InterruptedException {
        this.handler.post((Runnable)this.activityFinisher);
        if (!this.activityFinisher.await(2L, TimeUnit.SECONDS)) {
            Log.w((String)"AFRunListener", (String)"activity finisher did not run within 2 seconds. Is main thread blocked?");
            this.handler.removeCallbacks((Runnable)this.activityFinisher);
        }
    }

    public void testFinished(Description description) throws Exception {
        InstrumentationConnection.getInstance().requestRemoteInstancesActivityCleanup();
        this.runActivityFinisher();
        this.waitForActivitiesToStopRunnable.run();
    }

    private static class NotifyingRunnable
    implements Runnable {
        private final Runnable wrappedRunnable;
        private final CountDownLatch latch = new CountDownLatch(1);

        NotifyingRunnable(Runnable wrappedRunnable) {
            this.wrappedRunnable = wrappedRunnable;
        }

        @Override
        public void run() {
            this.wrappedRunnable.run();
            this.latch.countDown();
        }

        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.latch.await(time, unit);
        }
    }
}

