/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.util.Log;
import androidx.test.internal.runner.junit3.AndroidTestSuite;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.util.AndroidRunnerParams;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;

public class AndroidSuiteBuilder
extends SuiteMethodBuilder {
    private static final String LOG_TAG = "AndroidSuiteBuilder";
    private final boolean ignoreSuiteMethods;
    private final long perTestTimeout;

    @Deprecated
    public AndroidSuiteBuilder(AndroidRunnerParams runnerParams) {
        this(runnerParams.isIgnoreSuiteMethods(), runnerParams.getPerTestTimeout());
    }

    public AndroidSuiteBuilder(boolean ignoreSuiteMethods, long perTestTimeout) {
        this.ignoreSuiteMethods = ignoreSuiteMethods;
        this.perTestTimeout = perTestTimeout;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        if (this.ignoreSuiteMethods) {
            return null;
        }
        try {
            if (this.hasSuiteMethod(testClass)) {
                Test t = SuiteMethod.testFromSuiteMethod(testClass);
                if (!(t instanceof TestSuite)) {
                    throw new IllegalArgumentException(testClass.getName() + "#suite() did not return a TestSuite");
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite((TestSuite)t, this.perTestTimeout));
            }
        }
        catch (Throwable e) {
            Log.e((String)LOG_TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }
}

