/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.internal.events.client.JUnitValidator;
import androidx.test.internal.events.client.TestDiscoveryEventService;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ErrorInfo;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.discovery.TestDiscoveryErrorEvent;
import androidx.test.services.events.discovery.TestDiscoveryFinishedEvent;
import androidx.test.services.events.discovery.TestDiscoveryStartedEvent;
import androidx.test.services.events.discovery.TestFoundEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class TestDiscoveryListener
extends RunListener {
    private static final String TAG = "TestDiscoveryListener";
    private final TestDiscoveryEventService testDiscoveryEventService;
    private final AtomicBoolean discoveryStarted = new AtomicBoolean(false);

    public TestDiscoveryListener(@NonNull TestDiscoveryEventService testDiscoveryEventService) {
        this.testDiscoveryEventService = (TestDiscoveryEventService)Checks.checkNotNull((Object)testDiscoveryEventService, (Object)"testDiscoveryEventService can't be null");
    }

    public void testRunStarted(Description description) {
        try {
            this.reportTestRunStarted();
        }
        catch (TestEventClientException e) {
            Log.e((String)TAG, (String)"Failed to send discovery started", (Throwable)e);
        }
    }

    private void reportTestRunStarted() throws TestEventClientException {
        if (!this.discoveryStarted.getAndSet(true)) {
            this.testDiscoveryEventService.send(new TestDiscoveryStartedEvent());
        }
    }

    public void testRunFinished(Result result) {
        try {
            this.testDiscoveryEventService.send(new TestDiscoveryFinishedEvent());
        }
        catch (TestEventClientException e) {
            Log.e((String)TAG, (String)"Failed to send discovery started", (Throwable)e);
        }
    }

    public void testFinished(Description description) {
        if (!JUnitValidator.validateDescription(description)) {
            Log.d((String)TAG, (String)("JUnit reported " + description.getClassName() + "#" + description.getMethodName() + "; discarding as bogus."));
            return;
        }
        try {
            this.testDiscoveryEventService.send(new TestFoundEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Failed to get test description", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        try {
            this.reportDiscoveryError(failure);
        }
        catch (TestEventClientException e) {
            Log.e((String)TAG, (String)"Failed to send discovery failure", (Throwable)e);
        }
    }

    private void reportDiscoveryError(Failure failure) throws TestEventClientException {
        this.testDiscoveryEventService.send(new TestDiscoveryErrorEvent(ErrorInfo.createFromFailure(failure), TimeStamp.now()));
    }

    public boolean reportProcessCrash(Throwable t) {
        try {
            this.reportTestRunStarted();
            this.reportDiscoveryError(new Failure(Description.EMPTY, t));
            this.testDiscoveryEventService.send(new TestDiscoveryFinishedEvent());
            return true;
        }
        catch (TestEventClientException e) {
            Log.e((String)TAG, (String)"Failed to report process crash error", (Throwable)e);
            return false;
        }
    }
}

