/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnnotationValue
implements Parcelable {
    @NonNull
    public final String fieldName;
    @NonNull
    public final List<String> fieldValues;
    @NonNull
    public final String valueType;
    public static final Parcelable.Creator<AnnotationValue> CREATOR = new Parcelable.Creator<AnnotationValue>(){

        public AnnotationValue createFromParcel(Parcel source) {
            return new AnnotationValue(source);
        }

        public AnnotationValue[] newArray(int size) {
            return new AnnotationValue[size];
        }
    };

    public AnnotationValue(@NonNull String fieldName, @NonNull List<String> fieldValues, @NonNull String valueType) {
        Checks.checkNotNull((Object)fieldName, (Object)"fieldName cannot be null");
        Checks.checkNotNull(fieldValues, (Object)"fieldValues cannot be null");
        Checks.checkNotNull((Object)valueType, (Object)"valueType cannot be null");
        this.fieldName = fieldName;
        this.fieldValues = fieldValues;
        this.valueType = valueType;
    }

    private AnnotationValue(Parcel source) {
        this.fieldName = source.readString();
        this.fieldValues = new ArrayList<String>();
        source.readStringList(this.fieldValues);
        this.valueType = source.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.fieldName);
        parcel.writeStringList(this.fieldValues);
        parcel.writeString(this.valueType);
    }
}

