/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.ExperimentalTestApi;

@VisibleForTesting
@ExperimentalTestApi
public abstract class ShellCommand {
    private static final String SAFE_PUNCTUATION = "@%-_+:,./";

    static String shellEscape(String word) {
        int len = word.length();
        if (len == 0) {
            return "''";
        }
        for (int ii = 0; ii < len; ++ii) {
            char c = word.charAt(ii);
            if (Character.isLetterOrDigit(c) || SAFE_PUNCTUATION.indexOf(c) != -1) continue;
            String string = word.replace("'", "'\\''");
            return "'" + string + "'";
        }
        return word;
    }

    protected abstract void execute() throws Exception;
}

