/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.os.Looper;
import android.util.Log;
import androidx.test.internal.runner.junit3.AndroidTestResult;
import androidx.test.internal.runner.junit3.DelegatingFilterableTestSuite;
import androidx.test.internal.runner.junit3.NonLeakyTestSuite;
import androidx.test.internal.util.AndroidRunnerParams;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.Ignore;

@Ignore
class AndroidTestSuite
extends DelegatingFilterableTestSuite {
    private static final String TAG = "AndroidTestSuite";
    private final AndroidRunnerParams androidRunnerParams;

    private String getStackTraces() {
        StringBuilder sb = new StringBuilder();
        Thread t = Thread.currentThread();
        sb.append(t.toString()).append('\n');
        for (StackTraceElement ste : t.getStackTrace()) {
            sb.append("\tat ").append(ste.toString()).append('\n');
        }
        sb.append('\n');
        t = Looper.getMainLooper().getThread();
        sb.append(t.toString()).append('\n');
        for (StackTraceElement ste : t.getStackTrace()) {
            sb.append("\tat ").append(ste.toString()).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public AndroidTestSuite(Class<?> testClass, AndroidRunnerParams runnerParams) {
        this(new NonLeakyTestSuite(testClass), runnerParams);
    }

    public AndroidTestSuite(TestSuite s, AndroidRunnerParams runnerParams) {
        super(s);
        this.androidRunnerParams = runnerParams;
    }

    @Override
    public void run(TestResult result) {
        AndroidTestResult androidTestResult = new AndroidTestResult(this.androidRunnerParams.getBundle(), this.androidRunnerParams.getInstrumentation(), result);
        long timeout = this.androidRunnerParams.getPerTestTimeout();
        if (timeout > 0L) {
            this.runTestsWithTimeout(timeout, androidTestResult);
        } else {
            super.run(androidTestResult);
        }
    }

    private void runTestWithTimeout(final Test test, final AndroidTestResult androidTestResult, long timeout) {
        block5: {
            ExecutorService threadExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(this){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName(AndroidTestSuite.TAG);
                    return t;
                }
            });
            Runnable execRunnable = new Runnable(){

                @Override
                public void run() {
                    test.run((TestResult)androidTestResult);
                }
            };
            androidTestResult.setCurrentTimeout(timeout);
            Future<?> result = threadExecutor.submit(execRunnable);
            threadExecutor.shutdown();
            try {
                boolean isTerminated = threadExecutor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                if (isTerminated) break block5;
                threadExecutor.shutdownNow();
                isTerminated = threadExecutor.awaitTermination(1L, TimeUnit.MINUTES);
                if (isTerminated) break block5;
                Log.e((String)TAG, (String)"Failed to to stop test execution thread, the correctness of the test runner is at risk. Abort all execution!");
                try {
                    result.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    Log.e((String)TAG, (String)"Exception from the execution thread", (Throwable)e.getCause());
                }
                catch (TimeoutException e) {
                    Log.e((String)TAG, (String)"Exception from the execution thread", (Throwable)e);
                }
                this.terminateAllRunnerExecution(new IllegalStateException(String.format("Test timed out after %d milliseconds but execution thread failed to terminate\nDumping instr and main threads:\n%s", timeout, this.getStackTraces())));
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"The correctness of the test runner is at risk. Abort all execution!");
                this.terminateAllRunnerExecution(new IllegalStateException(String.format("Test execution thread got interrupted:\n%s\nDumping instr and main threads:\n%s", e, this.getStackTraces())));
            }
        }
    }

    private void runTestsWithTimeout(long timeout, AndroidTestResult result) {
        int suiteSize = this.testCount();
        for (int i = 0; i < suiteSize; ++i) {
            Test test = this.testAt(i);
            this.runTestWithTimeout(test, result, timeout);
        }
    }

    private void terminateAllRunnerExecution(final RuntimeException exception) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        Thread t = new Thread(r, "Terminator");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

