/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.util.Log;
import androidx.test.internal.runner.EmptyTestRunner;
import androidx.test.internal.runner.TestLoader;
import java.lang.reflect.Modifier;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class ScanningTestLoader
extends TestLoader {
    private static final String LOG_TAG = "ScanningTestLoader";
    private final ClassLoader classLoader;
    private final RunnerBuilder runnerBuilder;

    @Override
    protected Runner doCreateRunner(String className) {
        try {
            Class<?> loadedClass = Class.forName(className, false, this.classLoader);
            if (Modifier.isAbstract(loadedClass.getModifiers())) {
                ScanningTestLoader.logDebug("Skipping abstract class %s: not a test", loadedClass.getName());
                return null;
            }
            Runner runner = this.runnerBuilder.runnerForClass(loadedClass);
            if (runner instanceof EmptyTestRunner) {
                ScanningTestLoader.logDebug("Skipping class %s: class with no test methods", loadedClass.getName());
                return null;
            }
            return runner;
        }
        catch (Throwable e) {
            Log.w((String)LOG_TAG, (String)String.format("Could not load class: %s", className), (Throwable)e);
            return null;
        }
    }

    ScanningTestLoader(ClassLoader classLoader, RunnerBuilder runnerBuilder) {
        this.classLoader = classLoader;
        this.runnerBuilder = runnerBuilder;
    }

    private static void logDebug(String msg, Object ... objects) {
        if (Log.isLoggable((String)LOG_TAG, (int)3)) {
            Log.d((String)LOG_TAG, (String)String.format(msg, objects));
        }
    }
}

