/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4.statement;

import androidx.test.internal.runner.junit4.statement.UiThreadStatement;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class RunBefores
extends UiThreadStatement {
    private final Statement mNext;
    private final Object mTarget;
    private final List<FrameworkMethod> mBefores;

    public RunBefores(FrameworkMethod method, Statement next, List<FrameworkMethod> befores, Object target) {
        super(next, RunBefores.shouldRunOnUiThread(method));
        this.mNext = next;
        this.mBefores = befores;
        this.mTarget = target;
    }

    @Override
    public void evaluate() throws Throwable {
        final AtomicReference exceptionRef = new AtomicReference();
        for (final FrameworkMethod before : this.mBefores) {
            if (RunBefores.shouldRunOnUiThread(before)) {
                RunBefores.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            before.invokeExplosively(RunBefores.this.mTarget, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            exceptionRef.set(throwable);
                        }
                    }
                });
                Throwable throwable = (Throwable)exceptionRef.get();
                if (throwable == null) continue;
                throw throwable;
            }
            before.invokeExplosively(this.mTarget, new Object[0]);
        }
        this.mNext.evaluate();
    }
}

