/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.content.PermissionGranter;
import androidx.test.internal.util.Checks;
import androidx.test.runner.permission.PermissionRequester;
import androidx.test.runner.permission.UiAutomationPermissionGranter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class GrantPermissionRule
implements TestRule {
    private PermissionGranter permissionGranter;

    private GrantPermissionRule() {
        Object granter = (PermissionGranter)ServiceLoaderWrapper.loadSingleServiceOrNull(PermissionGranter.class);
        if (granter == null) {
            granter = Build.VERSION.SDK_INT >= 28 ? new UiAutomationPermissionGranter() : new PermissionRequester();
        }
        this.setPermissionGranter((PermissionGranter)granter);
    }

    @VisibleForTesting
    GrantPermissionRule(@NonNull PermissionGranter permissionGranter) {
        this.setPermissionGranter(permissionGranter);
    }

    public static GrantPermissionRule grant(String ... permissions) {
        GrantPermissionRule grantPermissionRule = new GrantPermissionRule();
        grantPermissionRule.grantPermissions(permissions);
        return grantPermissionRule;
    }

    private void grantPermissions(String ... permissions) {
        Set<String> permissionSet = this.satisfyPermissionDependencies(permissions);
        this.permissionGranter.addPermissions(permissionSet.toArray(new String[permissionSet.size()]));
    }

    private Set<String> satisfyPermissionDependencies(String ... permissions) {
        LinkedHashSet<String> permissionList = new LinkedHashSet<String>(Arrays.asList(permissions));
        if (permissionList.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
            permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        return permissionList;
    }

    public final Statement apply(Statement base, Description description) {
        return new RequestPermissionStatement(base);
    }

    private void setPermissionGranter(PermissionGranter permissionGranter) {
        this.permissionGranter = (PermissionGranter)Checks.checkNotNull((Object)permissionGranter, (Object)"permissionRequester cannot be null!");
    }

    private class RequestPermissionStatement
    extends Statement {
        private final Statement base;

        public RequestPermissionStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            GrantPermissionRule.this.permissionGranter.requestPermissions();
            this.base.evaluate();
        }
    }
}

