/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.io;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.annotation.RestrictTo;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroidx/test/platform/io/TestDirCalculator;", "", "()V", "inputDir", "Ljava/io/File;", "getInputDir", "()Ljava/io/File;", "inputDir$delegate", "Lkotlin/Lazy;", "outputDir", "getOutputDir", "outputDir$delegate", "calculateDefaultRootDir", "calculateInputDir", "calculateOutputDir", "runner_monitor_java_androidx_test-monitor_kt"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TestDirCalculator {
    @NotNull
    private final Lazy outputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ TestDirCalculator this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final File invoke() {
            return TestDirCalculator.access$calculateOutputDir(this.this$0);
        }
    }));
    @NotNull
    private final Lazy inputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ TestDirCalculator this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final File invoke() {
            return TestDirCalculator.access$calculateInputDir(this.this$0);
        }
    }));

    @NotNull
    public final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getInputDir() {
        Lazy lazy = this.inputDir$delegate;
        return (File)lazy.getValue();
    }

    private final File calculateOutputDir() {
        String additionalOutputTestDir = InstrumentationRegistry.getArguments().getString("additionalTestOutputDir");
        if (additionalOutputTestDir != null) {
            return new File(additionalOutputTestDir);
        }
        File rootdir = new File(this.calculateDefaultRootDir(), "additionalTestOutputDir");
        return rootdir;
    }

    private final File calculateInputDir() {
        String testInputDir = InstrumentationRegistry.getArguments().getString("testInputDir");
        if (testInputDir != null) {
            return new File(testInputDir);
        }
        return new File(this.calculateDefaultRootDir(), "testInputDir");
    }

    private final File calculateDefaultRootDir() {
        Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        if (Build.VERSION.SDK_INT >= 29) {
            File[] fileArray = context.getExternalMediaDirs();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"context.externalMediaDirs");
            for (File mediaDir : fileArray) {
                if (!Intrinsics.areEqual((Object)Environment.getExternalStorageState((File)mediaDir), (Object)"mounted")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)mediaDir, (String)"mediaDir");
                return mediaDir;
            }
        }
        if (context.getExternalCacheDir() != null) {
            File file = context.getExternalCacheDir();
            Intrinsics.checkNotNull((Object)file);
            return file;
        }
        File file = context.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.cacheDir");
        return file;
    }

    public static final /* synthetic */ File access$calculateOutputDir(TestDirCalculator $this) {
        return $this.calculateOutputDir();
    }

    public static final /* synthetic */ File access$calculateInputDir(TestDirCalculator $this) {
        return $this.calculateInputDir();
    }
}

