/*
 * Decompiled with CFR 0.152.
 */
package androidx.startup.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Element;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Landroidx/startup/lint/EnsureInitializerMetadataDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "components", "", "Lorg/jetbrains/uast/UClass;", "Lcom/android/tools/lint/detector/api/Location;", "reachable", "", "", "getReachable", "()Ljava/util/Set;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableSuperClasses", "", "getApplicableElements", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "startup-runtime-lint"})
public final class EnsureInitializerMetadataDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UClass, Location> components;
    @NotNull
    private final Set<String> reachable;
    @NotNull
    private static final String DESCRIPTION = "Every Initializer needs to be accompanied by a corresponding <meta-data> entry in the AndroidManifest.xml file.";
    @NotNull
    private static final Issue ISSUE;

    public EnsureInitializerMetadataDetector() {
        boolean bl = false;
        this.components = new LinkedHashMap();
        bl = false;
        this.reachable = new LinkedHashSet();
    }

    @NotNull
    public final Set<String> getReachable() {
        return this.reachable;
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"androidx.startup.Initializer");
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"meta-data");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        UMethod element$iv;
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            String name = declaration.getQualifiedName();
            if (Intrinsics.areEqual((Object)name, (Object)"androidx.startup.Initializer")) {
                return;
            }
            if (!declaration.isInterface()) {
                Location location = context.getLocation((PsiElement)declaration.getJavaPsi());
                Map<UClass, Location> map = this.components;
                boolean bl = false;
                map.put(declaration, location);
            }
            UMethod[] $this$first$iv = declaration.getMethods();
            boolean $i$f$first = false;
            UMethod[] uMethodArray = $this$first$iv;
            int n = uMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UMethod it = element$iv = uMethodArray[i];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"dependencies") && it.getParameterList().isEmpty())) {
                    continue;
                }
                break block4;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        UMethod method = element$iv;
        AbstractUastVisitor visitor2 = new AbstractUastVisitor(this){
            final /* synthetic */ EnsureInitializerMetadataDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                String qualifiedName;
                Object object;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object2 = node.getType();
                Object object3 = object = object2 instanceof PsiClassReferenceType ? (PsiClassReferenceType)object2 : null;
                String string = object == null ? null : (qualifiedName = (object2 = object.resolve()) == null ? null : object2.getQualifiedName());
                if (qualifiedName != null) {
                    object = this.this$0;
                    object2 = ((EnsureInitializerMetadataDetector)((Object)object)).getReachable();
                    boolean bl = false;
                    object2.add(qualifiedName);
                }
                return true;
            }
        };
        method.accept((UastVisitor)visitor2);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        String value = element.getAttributeNS("http://schemas.android.com/apk/res/android", "value");
        if (Intrinsics.areEqual((Object)value, (Object)"androidx.startup") || Intrinsics.areEqual((Object)value, (Object)"@string/androidx_startup")) {
            EnsureInitializerMetadataDetector ensureInitializerMetadataDetector = this;
            Collection collection = ensureInitializerMetadataDetector.reachable;
            boolean bl = false;
            collection.add(name);
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.components;
        boolean bl = false;
        Iterator<Map.Entry<UClass, Location>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            UClass declaration = (UClass)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Location location = (Location)object3.getValue();
            if (CollectionsKt.contains((Iterable)this.reachable, (Object)declaration.getQualifiedName())) continue;
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)DESCRIPTION, null, (int)8, null);
        }
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(EnsureInitializerMetadataDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"EnsureInitializerMetadata", (String)DESCRIPTION, (String)"\n                When a library defines a Initializer, it needs to be accompanied by a \\\n                corresponding <meta-data> entry in the AndroidManifest.xml file.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/startup/lint/EnsureInitializerMetadataDetector$Companion;", "", "()V", "DESCRIPTION", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "startup-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

