/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import androidx.annotation.RestrictTo;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.driver.bundled.BundledSQLiteStatementKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteStatement;", "Landroidx/sqlite/SQLiteStatement;", "connectionPointer", "", "statementPointer", "(JJ)V", "isClosed", "", "isClosed$annotations", "()V", "bindBlob", "", "index", "", "value", "", "bindDouble", "", "bindLong", "bindNull", "bindText", "", "clearBindings", "close", "getBlob", "getColumnCount", "getColumnName", "getColumnType", "getDouble", "getLong", "getText", "isNull", "reset", "step", "throwIfClosed", "Companion", "sqlite-bundled"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BundledSQLiteStatement
implements SQLiteStatement {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long connectionPointer;
    private final long statementPointer;
    private volatile boolean isClosed;
    private static final int COLUMN_TYPE_INTEGER = 1;
    private static final int COLUMN_TYPE_FLOAT = 2;
    private static final int COLUMN_TYPE_TEXT = 3;
    private static final int COLUMN_TYPE_BLOB = 4;
    private static final int COLUMN_TYPE_NULL = 5;

    public BundledSQLiteStatement(long connectionPointer, long statementPointer) {
        this.connectionPointer = connectionPointer;
        this.statementPointer = statementPointer;
    }

    private static /* synthetic */ void isClosed$annotations() {
    }

    public void bindBlob(int index, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeBindBlob(this.statementPointer, index, value);
    }

    public void bindDouble(int index, double value) {
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeBindDouble(this.statementPointer, index, value);
    }

    public void bindLong(int index, long value) {
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeBindLong(this.statementPointer, index, value);
    }

    public void bindText(int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeBindText(this.statementPointer, index, value);
    }

    public void bindNull(int index) {
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeBindNull(this.statementPointer, index);
    }

    @NotNull
    public byte[] getBlob(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetBlob(this.statementPointer, index);
    }

    public double getDouble(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetDouble(this.statementPointer, index);
    }

    public long getLong(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetLong(this.statementPointer, index);
    }

    @NotNull
    public String getText(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetText(this.statementPointer, index);
    }

    public boolean isNull(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetColumnType(this.statementPointer, index) == 5;
    }

    public int getColumnCount() {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetColumnCount(this.statementPointer);
    }

    @NotNull
    public String getColumnName(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetColumnName(this.statementPointer, index);
    }

    public int getColumnType(int index) {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeGetColumnType(this.statementPointer, index);
    }

    public boolean step() {
        this.throwIfClosed();
        return BundledSQLiteStatementKt.access$nativeStep(this.statementPointer);
    }

    public void reset() {
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeReset(this.statementPointer);
    }

    public void clearBindings() {
        this.throwIfClosed();
        BundledSQLiteStatementKt.access$nativeClearBindings(this.statementPointer);
    }

    public void close() {
        if (!this.isClosed) {
            BundledSQLiteStatementKt.access$nativeClose(this.statementPointer);
        }
        this.isClosed = true;
    }

    private final void throwIfClosed() {
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"statement is closed");
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteStatement$Companion;", "", "()V", "COLUMN_TYPE_BLOB", "", "COLUMN_TYPE_FLOAT", "COLUMN_TYPE_INTEGER", "COLUMN_TYPE_NULL", "COLUMN_TYPE_TEXT", "sqlite-bundled"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

