/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.crypto;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.integration.android.AndroidKeysetManager;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.streamingaead.StreamingAeadKeyTemplates;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;

public final class EncryptedFile {
    private static final String KEYSET_PREF_NAME = "__androidx_security_crypto_encrypted_file_pref__";
    private static final String KEYSET_ALIAS = "__androidx_security_crypto_encrypted_file_keyset__";
    final File mFile;
    final Context mContext;
    final String mMasterKeyAlias;
    final StreamingAead mStreamingAead;

    EncryptedFile(@NonNull File file, @NonNull String masterKeyAlias, @NonNull StreamingAead streamingAead, @NonNull Context context) {
        this.mFile = file;
        this.mContext = context;
        this.mMasterKeyAlias = masterKeyAlias;
        this.mStreamingAead = streamingAead;
    }

    @NonNull
    public FileOutputStream openFileOutput() throws GeneralSecurityException, IOException {
        if (this.mFile.exists()) {
            throw new IOException("output file already exists, please use a new file: " + this.mFile.getName());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.mFile);
        OutputStream encryptingStream = this.mStreamingAead.newEncryptingStream((OutputStream)fileOutputStream, this.mFile.getName().getBytes(StandardCharsets.UTF_8));
        return new EncryptedFileOutputStream(fileOutputStream.getFD(), encryptingStream);
    }

    @NonNull
    public FileInputStream openFileInput() throws GeneralSecurityException, IOException {
        if (!this.mFile.exists()) {
            throw new IOException("file doesn't exist: " + this.mFile.getName());
        }
        FileInputStream fileInputStream = new FileInputStream(this.mFile);
        InputStream decryptingStream = this.mStreamingAead.newDecryptingStream((InputStream)fileInputStream, this.mFile.getName().getBytes(StandardCharsets.UTF_8));
        return new EncryptedFileInputStream(fileInputStream.getFD(), decryptingStream);
    }

    private static final class EncryptedFileInputStream
    extends FileInputStream {
        private final InputStream mEncryptedInputStream;

        EncryptedFileInputStream(FileDescriptor descriptor, InputStream encryptedInputStream) {
            super(descriptor);
            this.mEncryptedInputStream = encryptedInputStream;
        }

        @Override
        public int read() throws IOException {
            return this.mEncryptedInputStream.read();
        }

        @Override
        public int read(@NonNull byte[] b) throws IOException {
            return this.mEncryptedInputStream.read(b);
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            return this.mEncryptedInputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.mEncryptedInputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.mEncryptedInputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.mEncryptedInputStream.close();
        }

        @Override
        public FileChannel getChannel() {
            throw new UnsupportedOperationException("For encrypted files, please open the relevant FileInput/FileOutputStream.");
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.mEncryptedInputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.mEncryptedInputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.mEncryptedInputStream.markSupported();
        }
    }

    private static final class EncryptedFileOutputStream
    extends FileOutputStream {
        private final OutputStream mEncryptedOutputStream;

        EncryptedFileOutputStream(FileDescriptor descriptor, OutputStream encryptedOutputStream) {
            super(descriptor);
            this.mEncryptedOutputStream = encryptedOutputStream;
        }

        @Override
        public void write(@NonNull byte[] b) throws IOException {
            this.mEncryptedOutputStream.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.mEncryptedOutputStream.write(b);
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            this.mEncryptedOutputStream.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.mEncryptedOutputStream.close();
        }

        @Override
        @NonNull
        public FileChannel getChannel() {
            throw new UnsupportedOperationException("For encrypted files, please open the relevant FileInput/FileOutputStream.");
        }

        @Override
        public void flush() throws IOException {
            this.mEncryptedOutputStream.flush();
        }
    }

    public static final class Builder {
        File mFile;
        final FileEncryptionScheme mFileEncryptionScheme;
        final Context mContext;
        final String mMasterKeyAlias;
        String mKeysetPrefName = "__androidx_security_crypto_encrypted_file_pref__";
        String mKeysetAlias = "__androidx_security_crypto_encrypted_file_keyset__";

        public Builder(@NonNull File file, @NonNull Context context, @NonNull String masterKeyAlias, @NonNull FileEncryptionScheme fileEncryptionScheme) {
            this.mFile = file;
            this.mFileEncryptionScheme = fileEncryptionScheme;
            this.mContext = context;
            this.mMasterKeyAlias = masterKeyAlias;
        }

        @NonNull
        public Builder setKeysetPrefName(@NonNull String keysetPrefName) {
            this.mKeysetPrefName = keysetPrefName;
            return this;
        }

        @NonNull
        public Builder setKeysetAlias(@NonNull String keysetAlias) {
            this.mKeysetAlias = keysetAlias;
            return this;
        }

        @NonNull
        public EncryptedFile build() throws GeneralSecurityException, IOException {
            TinkConfig.register();
            KeysetHandle streadmingAeadKeysetHandle = new AndroidKeysetManager.Builder().withKeyTemplate(this.mFileEncryptionScheme.getKeyTemplate()).withSharedPref(this.mContext, this.mKeysetAlias, this.mKeysetPrefName).withMasterKeyUri("android-keystore://" + this.mMasterKeyAlias).build().getKeysetHandle();
            StreamingAead streamingAead = (StreamingAead)streadmingAeadKeysetHandle.getPrimitive(StreamingAead.class);
            return new EncryptedFile(this.mFile, this.mKeysetAlias, streamingAead, this.mContext);
        }
    }

    public static enum FileEncryptionScheme {
        AES256_GCM_HKDF_4KB(StreamingAeadKeyTemplates.AES256_GCM_HKDF_4KB);

        private final KeyTemplate mStreamingAeadKeyTemplate;

        private FileEncryptionScheme(KeyTemplate keyTemplate) {
            this.mStreamingAeadKeyTemplate = keyTemplate;
        }

        KeyTemplate getKeyTemplate() {
            return this.mStreamingAeadKeyTemplate;
        }
    }
}

