/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.room.IMultiInstanceInvalidationCallback;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface IMultiInstanceInvalidationService
extends IInterface {
    public static final String DESCRIPTOR = "androidx$room$IMultiInstanceInvalidationService".replace('$', '.');

    public int registerCallback(IMultiInstanceInvalidationCallback var1, String var2) throws RemoteException;

    public void unregisterCallback(IMultiInstanceInvalidationCallback var1, int var2) throws RemoteException;

    public void broadcastInvalidation(int var1, String[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMultiInstanceInvalidationService {
        static final int TRANSACTION_registerCallback = 1;
        static final int TRANSACTION_unregisterCallback = 2;
        static final int TRANSACTION_broadcastInvalidation = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMultiInstanceInvalidationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMultiInstanceInvalidationService) {
                return (IMultiInstanceInvalidationService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IMultiInstanceInvalidationCallback _arg0 = IMultiInstanceInvalidationCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _result = this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    IMultiInstanceInvalidationCallback _arg0 = IMultiInstanceInvalidationCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    this.broadcastInvalidation(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMultiInstanceInvalidationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerCallback(IMultiInstanceInvalidationCallback callback2, String name) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback2);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IMultiInstanceInvalidationCallback callback2, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback2);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void broadcastInvalidation(int clientId, String[] tables) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeStringArray(tables);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMultiInstanceInvalidationService {
        @Override
        public int registerCallback(IMultiInstanceInvalidationCallback callback2, String name) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterCallback(IMultiInstanceInvalidationCallback callback2, int clientId) throws RemoteException {
        }

        @Override
        public void broadcastInvalidation(int clientId, String[] tables) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

