/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.room.ColumnInfo;
import androidx.room.Index;
import androidx.room.util.TableInfoKt;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/room/util/TableInfo;", "", "name", "", "columns", "", "Landroidx/room/util/TableInfo$Column;", "foreignKeys", "", "Landroidx/room/util/TableInfo$ForeignKey;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;)V", "indices", "Landroidx/room/util/TableInfo$Index;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;)V", "equals", "", "other", "hashCode", "", "toString", "Column", "Companion", "CreatedFrom", "ForeignKey", "ForeignKeyWithSequence", "Index", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class TableInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final String name;
    @JvmField
    @NotNull
    public final Map<String, Column> columns;
    @JvmField
    @NotNull
    public final Set<ForeignKey> foreignKeys;
    @JvmField
    @Nullable
    public final Set<Index> indices;
    public static final int CREATED_FROM_UNKNOWN = 0;
    public static final int CREATED_FROM_ENTITY = 1;
    public static final int CREATED_FROM_DATABASE = 2;

    public TableInfo(@NotNull String name, @NotNull Map<String, Column> columns, @NotNull Set<ForeignKey> foreignKeys, @Nullable Set<Index> indices) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(foreignKeys, (String)"foreignKeys");
        this.name = name;
        this.columns = columns;
        this.foreignKeys = foreignKeys;
        this.indices = indices;
    }

    public /* synthetic */ TableInfo(String string, Map map, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set2 = null;
        }
        this(string, map, set, set2);
    }

    public TableInfo(@NotNull String name, @NotNull Map<String, Column> columns, @NotNull Set<ForeignKey> foreignKeys) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(foreignKeys, (String)"foreignKeys");
        this(name, columns, foreignKeys, SetsKt.emptySet());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((TableInfo)other).name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columns, ((TableInfo)other).columns)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.foreignKeys, ((TableInfo)other).foreignKeys)) {
            return false;
        }
        return this.indices == null || ((TableInfo)other).indices == null ? true : Intrinsics.areEqual(this.indices, ((TableInfo)other).indices);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + ((Object)this.columns).hashCode();
        result = 31 * result + ((Object)this.foreignKeys).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "TableInfo{name='" + this.name + "', columns=" + this.columns + ", foreignKeys=" + this.foreignKeys + ", indices=" + this.indices + '}';
    }

    @JvmStatic
    @NotNull
    public static final TableInfo read(@NotNull SupportSQLiteDatabase database, @NotNull String tableName) {
        return Companion.read(database, tableName);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/room/util/TableInfo$CreatedFrom;", "", "room-runtime_release"})
    public static @interface CreatedFrom {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/room/util/TableInfo$Companion;", "", "()V", "CREATED_FROM_DATABASE", "", "CREATED_FROM_ENTITY", "CREATED_FROM_UNKNOWN", "read", "Landroidx/room/util/TableInfo;", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "tableName", "", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TableInfo read(@NotNull SupportSQLiteDatabase database, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            return TableInfoKt.readTableInfo(database, tableName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0003J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0016\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/room/util/TableInfo$Column;", "", "name", "", "type", "notNull", "", "primaryKeyPosition", "", "(Ljava/lang/String;Ljava/lang/String;ZI)V", "defaultValue", "createdFrom", "(Ljava/lang/String;Ljava/lang/String;ZILjava/lang/String;I)V", "affinity", "getAffinity$annotations", "()V", "isPrimaryKey", "()Z", "equals", "other", "findAffinity", "hashCode", "toString", "Companion", "room-runtime_release"})
    public static final class Column {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final String type;
        @JvmField
        public final boolean notNull;
        @JvmField
        public final int primaryKeyPosition;
        @JvmField
        @Nullable
        public final String defaultValue;
        @JvmField
        public final int createdFrom;
        @JvmField
        public final int affinity;

        public Column(@NotNull String name, @NotNull String type, boolean notNull, int primaryKeyPosition, @Nullable String defaultValue, int createdFrom) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.primaryKeyPosition = primaryKeyPosition;
            this.defaultValue = defaultValue;
            this.createdFrom = createdFrom;
            this.affinity = this.findAffinity(this.type);
        }

        @ColumnInfo.SQLiteTypeAffinity
        public static /* synthetic */ void getAffinity$annotations() {
        }

        @Deprecated(message="Use {@link Column#Column(String, String, boolean, int, String, int)} instead.")
        public Column(@NotNull String name, @NotNull String type, boolean notNull, int primaryKeyPosition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this(name, type, notNull, primaryKeyPosition, null, 0);
        }

        @ColumnInfo.SQLiteTypeAffinity
        private final int findAffinity(String type) {
            if (type == null) {
                return 5;
            }
            String string = type;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            String uppercaseType = string2;
            if (StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"INT", (boolean)false, (int)2, null)) {
                return 3;
            }
            if (StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"CHAR", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"CLOB", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"TEXT", (boolean)false, (int)2, null)) {
                return 2;
            }
            if (StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"BLOB", (boolean)false, (int)2, null)) {
                return 5;
            }
            if (StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"REAL", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"FLOA", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)uppercaseType, (CharSequence)"DOUB", (boolean)false, (int)2, null)) {
                return 4;
            }
            return 1;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Column)) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 20 ? this.primaryKeyPosition != ((Column)other).primaryKeyPosition : this.isPrimaryKey() != ((Column)other).isPrimaryKey()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)((Column)other).name)) {
                return false;
            }
            if (this.notNull != ((Column)other).notNull) {
                return false;
            }
            if (this.createdFrom == 1 && ((Column)other).createdFrom == 2 && this.defaultValue != null && !Companion.defaultValueEquals(this.defaultValue, ((Column)other).defaultValue)) {
                return false;
            }
            if (this.createdFrom == 2 && ((Column)other).createdFrom == 1 && ((Column)other).defaultValue != null && !Companion.defaultValueEquals(((Column)other).defaultValue, this.defaultValue)) {
                return false;
            }
            if (this.createdFrom != 0 && this.createdFrom == ((Column)other).createdFrom) {
                boolean bl = this.defaultValue != null ? !Companion.defaultValueEquals(this.defaultValue, ((Column)other).defaultValue) : ((Column)other).defaultValue != null;
                if (bl) {
                    return false;
                }
            }
            return this.affinity == ((Column)other).affinity;
        }

        public final boolean isPrimaryKey() {
            return this.primaryKeyPosition > 0;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.affinity;
            result = 31 * result + (this.notNull ? 1231 : 1237);
            result = 31 * result + this.primaryKeyPosition;
            return result;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Column{name='").append(this.name).append("', type='").append(this.type).append("', affinity='").append(this.affinity).append("', notNull=").append(this.notNull).append(", primaryKeyPosition=").append(this.primaryKeyPosition).append(", defaultValue='");
            String string = this.defaultValue;
            if (string == null) {
                string = "undefined";
            }
            return stringBuilder.append(string).append("'}").toString();
        }

        @JvmStatic
        @SuppressLint(value={"SyntheticAccessor"})
        @VisibleForTesting
        public static final boolean defaultValueEquals(@NotNull String current, @Nullable String other) {
            return Companion.defaultValueEquals(current, other);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\t"}, d2={"Landroidx/room/util/TableInfo$Column$Companion;", "", "()V", "containsSurroundingParenthesis", "", "current", "", "defaultValueEquals", "other", "room-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @SuppressLint(value={"SyntheticAccessor"})
            @VisibleForTesting
            public final boolean defaultValueEquals(@NotNull String current, @Nullable String other) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (Intrinsics.areEqual((Object)current, (Object)other)) {
                    return true;
                }
                if (this.containsSurroundingParenthesis(current)) {
                    String string = current.substring(1, current.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)other);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean containsSurroundingParenthesis(String current) {
                if (((CharSequence)current).length() == 0) {
                    return false;
                }
                int surroundingParenthesis = 0;
                CharSequence $this$forEachIndexed$iv = current;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                    void c;
                    char item$iv = $this$forEachIndexed$iv.charAt(i);
                    int n = index$iv++;
                    char c2 = item$iv;
                    int i2 = n;
                    boolean bl = false;
                    if (i2 == 0 && c != 40) {
                        return false;
                    }
                    if (c == 40) {
                        ++surroundingParenthesis;
                        continue;
                    }
                    if (c != 41 || (surroundingParenthesis += -1) != 0 || i2 == current.length() - 1) continue;
                    return false;
                }
                return surroundingParenthesis == 0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/room/util/TableInfo$ForeignKey;", "", "referenceTable", "", "onDelete", "onUpdate", "columnNames", "", "referenceColumnNames", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "equals", "", "other", "hashCode", "", "toString", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class ForeignKey {
        @JvmField
        @NotNull
        public final String referenceTable;
        @JvmField
        @NotNull
        public final String onDelete;
        @JvmField
        @NotNull
        public final String onUpdate;
        @JvmField
        @NotNull
        public final List<String> columnNames;
        @JvmField
        @NotNull
        public final List<String> referenceColumnNames;

        public ForeignKey(@NotNull String referenceTable, @NotNull String onDelete, @NotNull String onUpdate, @NotNull List<String> columnNames, @NotNull List<String> referenceColumnNames) {
            Intrinsics.checkNotNullParameter((Object)referenceTable, (String)"referenceTable");
            Intrinsics.checkNotNullParameter((Object)onDelete, (String)"onDelete");
            Intrinsics.checkNotNullParameter((Object)onUpdate, (String)"onUpdate");
            Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
            Intrinsics.checkNotNullParameter(referenceColumnNames, (String)"referenceColumnNames");
            this.referenceTable = referenceTable;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.columnNames = columnNames;
            this.referenceColumnNames = referenceColumnNames;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForeignKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceTable, (Object)((ForeignKey)other).referenceTable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.onDelete, (Object)((ForeignKey)other).onDelete)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.onUpdate, (Object)((ForeignKey)other).onUpdate)) {
                return false;
            }
            return !Intrinsics.areEqual(this.columnNames, ((ForeignKey)other).columnNames) ? false : Intrinsics.areEqual(this.referenceColumnNames, ((ForeignKey)other).referenceColumnNames);
        }

        public int hashCode() {
            int result = this.referenceTable.hashCode();
            result = 31 * result + this.onDelete.hashCode();
            result = 31 * result + this.onUpdate.hashCode();
            result = 31 * result + ((Object)this.columnNames).hashCode();
            result = 31 * result + ((Object)this.referenceColumnNames).hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            return "ForeignKey{referenceTable='" + this.referenceTable + "', onDelete='" + this.onDelete + " +', onUpdate='" + this.onUpdate + "', columnNames=" + this.columnNames + ", referenceColumnNames=" + this.referenceColumnNames + '}';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0011"}, d2={"Landroidx/room/util/TableInfo$ForeignKeyWithSequence;", "", "id", "", "sequence", "from", "", "to", "(IILjava/lang/String;Ljava/lang/String;)V", "getFrom", "()Ljava/lang/String;", "getId", "()I", "getSequence", "getTo", "compareTo", "other", "room-runtime_release"})
    public static final class ForeignKeyWithSequence
    implements Comparable<ForeignKeyWithSequence> {
        private final int id;
        private final int sequence;
        @NotNull
        private final String from;
        @NotNull
        private final String to;

        public ForeignKeyWithSequence(int id, int sequence, @NotNull String from, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.id = id;
            this.sequence = sequence;
            this.from = from;
            this.to = to;
        }

        public final int getId() {
            return this.id;
        }

        public final int getSequence() {
            return this.sequence;
        }

        @NotNull
        public final String getFrom() {
            return this.from;
        }

        @NotNull
        public final String getTo() {
            return this.to;
        }

        @Override
        public int compareTo(@NotNull ForeignKeyWithSequence other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int idCmp = this.id - other.id;
            return idCmp == 0 ? this.sequence - other.sequence : idCmp;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/room/util/TableInfo$Index;", "", "name", "", "unique", "", "columns", "", "(Ljava/lang/String;ZLjava/util/List;)V", "orders", "(Ljava/lang/String;ZLjava/util/List;Ljava/util/List;)V", "equals", "other", "hashCode", "", "toString", "Companion", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Index {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        public final boolean unique;
        @JvmField
        @NotNull
        public final List<String> columns;
        @JvmField
        @NotNull
        public List<String> orders;
        @NotNull
        public static final String DEFAULT_PREFIX = "index_";

        public Index(@NotNull String name, boolean unique, @NotNull List<String> columns, @NotNull List<String> orders) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(orders, (String)"orders");
            this.name = name;
            this.unique = unique;
            this.columns = columns;
            this.orders = orders;
            Index index = this;
            Collection collection2 = this.orders;
            if (collection2.isEmpty()) {
                Index index2 = index;
                boolean bl = false;
                int n = this.columns.size();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl2 = false;
                    arrayList2.add(Index.Order.ASC.name());
                }
                collection = arrayList;
                index = index2;
            } else {
                collection = collection2;
            }
            index.orders = (List)collection;
        }

        @Deprecated(message="Use {@link #Index(String, boolean, List, List)}")
        public Index(@NotNull String name, boolean unique, @NotNull List<String> columns) {
            ArrayList<String> arrayList;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            int n = columns.size();
            List<String> list = columns;
            boolean bl = unique;
            String string = name;
            Index index = this;
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                arrayList = arrayList2;
                boolean bl2 = false;
                arrayList.add(Index.Order.ASC.name());
            }
            arrayList = arrayList2;
            index(string, bl, list, arrayList);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Index)) {
                return false;
            }
            if (this.unique != ((Index)other).unique) {
                return false;
            }
            if (!Intrinsics.areEqual(this.columns, ((Index)other).columns)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.orders, ((Index)other).orders)) {
                return false;
            }
            return StringsKt.startsWith$default((String)this.name, (String)DEFAULT_PREFIX, (boolean)false, (int)2, null) ? StringsKt.startsWith$default((String)((Index)other).name, (String)DEFAULT_PREFIX, (boolean)false, (int)2, null) : Intrinsics.areEqual((Object)this.name, (Object)((Index)other).name);
        }

        public int hashCode() {
            int result = StringsKt.startsWith$default((String)this.name, (String)DEFAULT_PREFIX, (boolean)false, (int)2, null) ? DEFAULT_PREFIX.hashCode() : this.name.hashCode();
            result = 31 * result + (this.unique ? 1 : 0);
            result = 31 * result + ((Object)this.columns).hashCode();
            result = 31 * result + ((Object)this.orders).hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            return "Index{name='" + this.name + "', unique=" + this.unique + ", columns=" + this.columns + ", orders=" + this.orders + "'}";
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/util/TableInfo$Index$Companion;", "", "()V", "DEFAULT_PREFIX", "", "room-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

