/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import androidx.room.InvalidationTracker;
import androidx.room.MultiInstanceInvalidationClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u00109\u001a\u00020:R\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010(R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006;"}, d2={"Landroidx/room/MultiInstanceInvalidationClient;", "", "context", "Landroid/content/Context;", "name", "", "serviceIntent", "Landroid/content/Intent;", "invalidationTracker", "Landroidx/room/InvalidationTracker;", "executor", "Ljava/util/concurrent/Executor;", "(Landroid/content/Context;Ljava/lang/String;Landroid/content/Intent;Landroidx/room/InvalidationTracker;Ljava/util/concurrent/Executor;)V", "appContext", "kotlin.jvm.PlatformType", "callback", "Landroidx/room/IMultiInstanceInvalidationCallback;", "getCallback", "()Landroidx/room/IMultiInstanceInvalidationCallback;", "clientId", "", "getClientId", "()I", "setClientId", "(I)V", "getExecutor", "()Ljava/util/concurrent/Executor;", "getInvalidationTracker", "()Landroidx/room/InvalidationTracker;", "getName", "()Ljava/lang/String;", "observer", "Landroidx/room/InvalidationTracker$Observer;", "getObserver", "()Landroidx/room/InvalidationTracker$Observer;", "setObserver", "(Landroidx/room/InvalidationTracker$Observer;)V", "removeObserverRunnable", "Ljava/lang/Runnable;", "getRemoveObserverRunnable", "()Ljava/lang/Runnable;", "service", "Landroidx/room/IMultiInstanceInvalidationService;", "getService", "()Landroidx/room/IMultiInstanceInvalidationService;", "setService", "(Landroidx/room/IMultiInstanceInvalidationService;)V", "serviceConnection", "Landroid/content/ServiceConnection;", "getServiceConnection", "()Landroid/content/ServiceConnection;", "setUpRunnable", "getSetUpRunnable", "stopped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getStopped", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "stop", "", "room-runtime_release"})
public final class MultiInstanceInvalidationClient {
    @NotNull
    private final String name;
    @NotNull
    private final InvalidationTracker invalidationTracker;
    @NotNull
    private final Executor executor;
    private final Context appContext;
    private int clientId;
    public InvalidationTracker.Observer observer;
    @Nullable
    private IMultiInstanceInvalidationService service;
    @NotNull
    private final IMultiInstanceInvalidationCallback callback;
    @NotNull
    private final AtomicBoolean stopped;
    @NotNull
    private final ServiceConnection serviceConnection;
    @NotNull
    private final Runnable setUpRunnable;
    @NotNull
    private final Runnable removeObserverRunnable;

    public MultiInstanceInvalidationClient(@NotNull Context context, @NotNull String name, @NotNull Intent serviceIntent, @NotNull InvalidationTracker invalidationTracker, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serviceIntent, (String)"serviceIntent");
        Intrinsics.checkNotNullParameter((Object)invalidationTracker, (String)"invalidationTracker");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.name = name;
        this.invalidationTracker = invalidationTracker;
        this.executor = executor;
        this.appContext = context.getApplicationContext();
        this.callback = new IMultiInstanceInvalidationCallback.Stub(this){
            final /* synthetic */ MultiInstanceInvalidationClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInvalidation(@NotNull String[] tables) {
                Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
                this.this$0.getExecutor().execute(() -> callback.1.onInvalidation$lambda-0(this.this$0, tables));
            }

            private static final void onInvalidation$lambda-0(MultiInstanceInvalidationClient this$0, String[] $tables) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$tables, (String)"$tables");
                this$0.getInvalidationTracker().notifyObserversByTableNames(Arrays.copyOf($tables, $tables.length));
            }
        };
        this.stopped = new AtomicBoolean(false);
        this.serviceConnection = new ServiceConnection(this){
            final /* synthetic */ MultiInstanceInvalidationClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                this.this$0.setService(IMultiInstanceInvalidationService.Stub.asInterface(service));
                this.this$0.getExecutor().execute(this.this$0.getSetUpRunnable());
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.this$0.getExecutor().execute(this.this$0.getRemoveObserverRunnable());
                this.this$0.setService(null);
            }
        };
        this.setUpRunnable = () -> MultiInstanceInvalidationClient.setUpRunnable$lambda-1(this);
        this.removeObserverRunnable = () -> MultiInstanceInvalidationClient.removeObserverRunnable$lambda-2(this);
        Set<String> tableNames = this.invalidationTracker.getTableIdLookup$room_runtime_release().keySet();
        Collection $this$toTypedArray$iv = tableNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] stringArray2 = stringArray;
        this.setObserver(new InvalidationTracker.Observer(stringArray2){

            @Override
            public void onInvalidated(@NotNull Set<String> tables) {
                Intrinsics.checkNotNullParameter(tables, (String)"tables");
                if (this.getStopped().get()) {
                    return;
                }
                try {
                    IMultiInstanceInvalidationService iMultiInstanceInvalidationService = this.getService();
                    if (iMultiInstanceInvalidationService != null) {
                        int n = this.getClientId();
                        Collection $this$toTypedArray$iv = tables;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        iMultiInstanceInvalidationService.broadcastInvalidation(n, stringArray);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)"ROOM", (String)"Cannot broadcast invalidation", (Throwable)e);
                }
            }

            @Override
            public boolean isRemote$room_runtime_release() {
                return true;
            }
        });
        this.appContext.bindService(serviceIntent, this.serviceConnection, 1);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final InvalidationTracker getInvalidationTracker() {
        return this.invalidationTracker;
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    public final int getClientId() {
        return this.clientId;
    }

    public final void setClientId(int n) {
        this.clientId = n;
    }

    @NotNull
    public final InvalidationTracker.Observer getObserver() {
        InvalidationTracker.Observer observer2 = this.observer;
        if (observer2 != null) {
            return observer2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"observer");
        return null;
    }

    public final void setObserver(@NotNull InvalidationTracker.Observer observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"<set-?>");
        this.observer = observer2;
    }

    @Nullable
    public final IMultiInstanceInvalidationService getService() {
        return this.service;
    }

    public final void setService(@Nullable IMultiInstanceInvalidationService iMultiInstanceInvalidationService) {
        this.service = iMultiInstanceInvalidationService;
    }

    @NotNull
    public final IMultiInstanceInvalidationCallback getCallback() {
        return this.callback;
    }

    @NotNull
    public final AtomicBoolean getStopped() {
        return this.stopped;
    }

    @NotNull
    public final ServiceConnection getServiceConnection() {
        return this.serviceConnection;
    }

    @NotNull
    public final Runnable getSetUpRunnable() {
        return this.setUpRunnable;
    }

    @NotNull
    public final Runnable getRemoveObserverRunnable() {
        return this.removeObserverRunnable;
    }

    public final void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.invalidationTracker.removeObserver(this.getObserver());
            try {
                IMultiInstanceInvalidationService iMultiInstanceInvalidationService = this.service;
                if (iMultiInstanceInvalidationService != null) {
                    iMultiInstanceInvalidationService.unregisterCallback(this.callback, this.clientId);
                }
            }
            catch (RemoteException e) {
                Log.w((String)"ROOM", (String)"Cannot unregister multi-instance invalidation callback", (Throwable)e);
            }
            this.appContext.unbindService(this.serviceConnection);
        }
    }

    private static final void setUpRunnable$lambda-1(MultiInstanceInvalidationClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            IMultiInstanceInvalidationService iMultiInstanceInvalidationService = this$0.service;
            if (iMultiInstanceInvalidationService != null) {
                IMultiInstanceInvalidationService it = iMultiInstanceInvalidationService;
                boolean bl = false;
                this$0.clientId = it.registerCallback(this$0.callback, this$0.name);
                this$0.invalidationTracker.addObserver(this$0.getObserver());
            }
        }
        catch (RemoteException e) {
            Log.w((String)"ROOM", (String)"Cannot register multi-instance invalidation callback", (Throwable)e);
        }
    }

    private static final void removeObserverRunnable$lambda-2(MultiInstanceInvalidationClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidationTracker.removeObserver(this$0.getObserver());
    }
}

