/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class UUIDUtil {
    private UUIDUtil() {
    }

    @NonNull
    public static UUID convertByteToUUID(@NonNull byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long firstLong = buffer.getLong();
        long secondLong = buffer.getLong();
        return new UUID(firstLong, secondLong);
    }

    @NonNull
    public static byte[] convertUUIDToByte(@NonNull UUID uuid) {
        byte[] bytes = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }
}

