/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.runtime.lint;

import androidx.navigation.lint.common.LintUtilKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/runtime/lint/WrongPopBackStackRouteDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "navigation-runtime-lint"})
@SourceDebugExtension(value={"SMAP\nWrongPopBackStackRouteDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongPopBackStackRouteDetector.kt\nandroidx/navigation/runtime/lint/WrongPopBackStackRouteDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,102:1\n1#2:103\n483#3,11:104\n*S KotlinDebug\n*F\n+ 1 WrongPopBackStackRouteDetector.kt\nandroidx/navigation/runtime/lint/WrongPopBackStackRouteDetector\n*L\n93#1:104,11\n*E\n"})
public final class WrongPopBackStackRouteDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue WrongPopBackStackRouteType;

    @NotNull
    public final List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"popBackStack");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                var6_4 = node.getValueArguments();
                var7_5 = var6_4.iterator();
                while (var7_5.hasNext()) {
                    var8_6 /* !! */  = var7_5.next();
                    it = (UExpression)var8_6 /* !! */ ;
                    $i$a$-find-WrongPopBackStackRouteDetector$visitMethodCall$startNode$1 = false;
                    v0 = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                    if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getName() : null), (Object)"route")) continue;
                    v1 = var8_6 /* !! */ ;
                    break block5;
                }
                v1 = null;
            }
            v2 = v1;
            if (v2 == null) {
                return;
            }
            startNode = v2;
            isClassType = (Boolean)LintUtilKt.isClassReference(startNode, false, false, true).component1();
            if (!isClassType) break block6;
            v3 = context;
            v4 = WrongPopBackStackRouteDetector.WrongPopBackStackRouteType;
            v5 = (UElement)startNode;
            v6 = context.getNameLocation((UElement)startNode);
            v7 = "Use popBackStack with reified class instead.";
            v8 = LintFix.Companion.create().replace();
            v9 = node.getUastParent();
            Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
            v10 = node.getSourcePsi();
            v11 = v8.range(context.getNameLocation(v9)).name("Use popBackStack with reified class instead.").text(v10 != null ? v10.getText() : null);
            var6_4 = node.getSourcePsi();
            if (var6_4 == null || (var7_5 = var6_4.getText()) == null || (var8_6 /* !! */  = StringsKt.replace$default((String)var7_5, (String)"(", (String)"<", (boolean)false, (int)4, null)) == null || (var9_7 = StringsKt.replace$default(var8_6 /* !! */ , (String)"route =", (String)"", (boolean)false, (int)4, null)) == null || (var10_9 = StringsKt.replace$default((String)var9_7, (String)",", (String)">(", (boolean)false, (int)4, null)) == null) ** GOTO lbl-1000
            var12_12 = var10_9;
            var26_13 = v11;
            var25_14 = v7;
            var24_15 = v6;
            var23_16 = v5;
            var22_17 = v4;
            var21_18 = v3;
            $i$f$filterNot = false;
            var14_20 = (CharSequence)$this$filterNot$iv;
            destination$iv$iv = new StringBuilder();
            $i$f$filterNotTo = false;
            for (var17_23 = 0; var17_23 < $this$filterNotTo$iv$iv.length(); ++var17_23) {
                it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(var17_23);
                $i$a$-filterNot-WrongPopBackStackRouteDetector$visitMethodCall$1 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            v12 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"filterNotTo(StringBuilder(), predicate).toString()");
            var27_27 = v12;
            v3 = var21_18;
            v4 = var22_17;
            v5 = var23_16;
            v6 = var24_15;
            v7 = var25_14;
            v11 = var26_13;
            var11_28 = var27_27;
            if (var11_28 != null) {
                v13 = StringsKt.replace$default((String)var11_28, (String)",", (String)", ", (boolean)false, (int)4, null);
            } else lbl-1000:
            // 2 sources

            {
                v13 = null;
            }
            v3.report(v4, v5, v6, v7, v11.with(v13).autoFix().build());
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(WrongPopBackStackRouteDetector.class, Scope.JAVA_FILE_SCOPE);
        WrongPopBackStackRouteType = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongPopBackStackRouteType", (String)"Data class routes should use PopBackStack with reified class.", (String)"If the route is a data class with arguments, attempting to call popBackStack with only the class will causes a serialization error and you may not have the proper argument to call it with an instance. You should instead used the provided popBackStack function that takes the reified class name.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3920, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/runtime/lint/WrongPopBackStackRouteDetector$Companion;", "", "()V", "WrongPopBackStackRouteType", "Lcom/android/tools/lint/detector/api/Issue;", "getWrongPopBackStackRouteType", "()Lcom/android/tools/lint/detector/api/Issue;", "navigation-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getWrongPopBackStackRouteType() {
            return WrongPopBackStackRouteType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

