/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ViewModel {
    @Nullable
    private final ConcurrentHashMap<String, Object> mBagOfTags = new ConcurrentHashMap();
    private volatile boolean mCleared = false;

    protected void onCleared() {
    }

    @MainThread
    final void clear() {
        this.mCleared = true;
        if (this.mBagOfTags != null) {
            for (Object value : this.mBagOfTags.values()) {
                ViewModel.closeWithRuntimeException(value);
            }
        }
        this.onCleared();
    }

    <T> T setTagIfAbsent(String key, T newValue) {
        Object result;
        Object previous = this.mBagOfTags.putIfAbsent(key, newValue);
        Object object = result = previous == null ? newValue : previous;
        if (this.mCleared) {
            ViewModel.closeWithRuntimeException(result);
        }
        return result;
    }

    <T> T getTag(String key) {
        return (T)this.mBagOfTags.get(key);
    }

    private static void closeWithRuntimeException(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

