/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleAttacher;
import androidx.lifecycle.SavedStateHandleController;
import androidx.lifecycle.SavedStateHandlesVM;
import androidx.lifecycle.ThrowingFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0013H\u0007\u001a\u001f\u0010\u0014\u001a\u00020\u0015\"\f\b\u0000\u0010\u0016*\u00020\u0004*\u00020\b*\u0002H\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\t\u001a\u00020\n*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"DEFAULT_ARGS_KEY", "Landroidx/lifecycle/viewmodel/CreationExtras$Key;", "Landroid/os/Bundle;", "SAVED_STATE_REGISTRY_OWNER_KEY", "Landroidx/savedstate/SavedStateRegistryOwner;", "VIEWMODEL_KEY", "", "VIEW_MODEL_STORE_OWNER_KEY", "Landroidx/lifecycle/ViewModelStoreOwner;", "savedStateHandlesVM", "Landroidx/lifecycle/SavedStateHandlesVM;", "getSavedStateHandlesVM", "(Landroidx/lifecycle/ViewModelStoreOwner;)Landroidx/lifecycle/SavedStateHandlesVM;", "createSavedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "savedStateRegistryOwner", "viewModelStoreOwner", "key", "defaultArgs", "Landroidx/lifecycle/viewmodel/CreationExtras;", "enableSavedStateHandles", "", "T", "(Landroidx/savedstate/SavedStateRegistryOwner;)V", "lifecycle-viewmodel-savedstate_release"})
@JvmName(name="SavedStateHandleSupport")
public final class SavedStateHandleSupport {
    @NotNull
    private static final String VIEWMODEL_KEY = "androidx.lifecycle.internal.SavedStateHandlesVM";
    @JvmField
    @NotNull
    public static final CreationExtras.Key<SavedStateRegistryOwner> SAVED_STATE_REGISTRY_OWNER_KEY = (CreationExtras.Key)new CreationExtras.Key<SavedStateRegistryOwner>(){};
    @JvmField
    @NotNull
    public static final CreationExtras.Key<ViewModelStoreOwner> VIEW_MODEL_STORE_OWNER_KEY = (CreationExtras.Key)new CreationExtras.Key<ViewModelStoreOwner>(){};
    @JvmField
    @NotNull
    public static final CreationExtras.Key<Bundle> DEFAULT_ARGS_KEY = (CreationExtras.Key)new CreationExtras.Key<Bundle>(){};

    @MainThread
    public static final <T extends SavedStateRegistryOwner & ViewModelStoreOwner> void enableSavedStateHandles(@NotNull T $this$enableSavedStateHandles) {
        Intrinsics.checkNotNullParameter($this$enableSavedStateHandles, (String)"<this>");
        Lifecycle.State state = $this$enableSavedStateHandles.getLifecycle().getCurrentState();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"lifecycle.currentState");
        Lifecycle.State currentState = state;
        if (!(currentState == Lifecycle.State.INITIALIZED || currentState == Lifecycle.State.CREATED)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        new ViewModelProvider((ViewModelStoreOwner)$this$enableSavedStateHandles, new ViewModelProvider.Factory(){

            @NotNull
            public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                return (T)((Object)new SavedStateHandlesVM());
            }
        }).get(VIEWMODEL_KEY, SavedStateHandlesVM.class);
        $this$enableSavedStateHandles.getSavedStateRegistry().runOnNextRecreation(SavedStateHandleAttacher.class);
    }

    private static final SavedStateHandle createSavedStateHandle(SavedStateRegistryOwner savedStateRegistryOwner, ViewModelStoreOwner viewModelStoreOwner, String key, Bundle defaultArgs) {
        SavedStateHandlesVM vm = SavedStateHandleSupport.getSavedStateHandlesVM(viewModelStoreOwner);
        SavedStateRegistry savedStateRegistry = savedStateRegistryOwner.getSavedStateRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)savedStateRegistry, (String)"savedStateRegistryOwner.savedStateRegistry");
        SavedStateRegistry savedStateRegistry2 = savedStateRegistry;
        SavedStateHandle handle = SavedStateHandle.Companion.createHandle(savedStateRegistry2.consumeRestoredStateForKey(key), defaultArgs);
        SavedStateHandleController controller = new SavedStateHandleController(key, handle);
        controller.attachToLifecycle(savedStateRegistry2, savedStateRegistryOwner.getLifecycle());
        vm.getControllers().add(controller);
        return handle;
    }

    @MainThread
    @NotNull
    public static final SavedStateHandle createSavedStateHandle(@NotNull CreationExtras $this$createSavedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)$this$createSavedStateHandle, (String)"<this>");
        SavedStateRegistryOwner savedStateRegistryOwner = (SavedStateRegistryOwner)$this$createSavedStateHandle.get(SAVED_STATE_REGISTRY_OWNER_KEY);
        if (savedStateRegistryOwner == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `SAVED_STATE_REGISTRY_OWNER_KEY`");
        }
        SavedStateRegistryOwner savedStateRegistryOwner2 = savedStateRegistryOwner;
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$createSavedStateHandle.get(VIEW_MODEL_STORE_OWNER_KEY);
        if (viewModelStoreOwner == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `VIEW_MODEL_STORE_OWNER_KEY`");
        }
        ViewModelStoreOwner viewModelStateRegistryOwner = viewModelStoreOwner;
        Bundle defaultArgs = (Bundle)$this$createSavedStateHandle.get(DEFAULT_ARGS_KEY);
        String string = (String)$this$createSavedStateHandle.get(ViewModelProvider.NewInstanceFactory.VIEW_MODEL_KEY);
        if (string == null) {
            throw new IllegalArgumentException("CreationExtras must have a value by `VIEW_MODEL_KEY`");
        }
        String key = string;
        return SavedStateHandleSupport.createSavedStateHandle(savedStateRegistryOwner2, viewModelStateRegistryOwner, key, defaultArgs);
    }

    @NotNull
    public static final SavedStateHandlesVM getSavedStateHandlesVM(@NotNull ViewModelStoreOwner $this$savedStateHandlesVM) {
        Intrinsics.checkNotNullParameter((Object)$this$savedStateHandlesVM, (String)"<this>");
        return (SavedStateHandlesVM)new ViewModelProvider($this$savedStateHandlesVM, (ViewModelProvider.Factory)ThrowingFactory.INSTANCE).get(VIEWMODEL_KEY, SavedStateHandlesVM.class);
    }
}

