/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LegacySavedStateHandleController;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleController;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class SavedStateViewModelFactory
extends ViewModelProvider.OnRequeryFactory
implements ViewModelProvider.Factory {
    private Application mApplication;
    private final ViewModelProvider.Factory mFactory;
    private Bundle mDefaultArgs;
    private Lifecycle mLifecycle;
    private SavedStateRegistry mSavedStateRegistry;
    private static final Class<?>[] ANDROID_VIEWMODEL_SIGNATURE = new Class[]{Application.class, SavedStateHandle.class};
    private static final Class<?>[] VIEWMODEL_SIGNATURE = new Class[]{SavedStateHandle.class};

    public SavedStateViewModelFactory() {
        this.mFactory = new ViewModelProvider.AndroidViewModelFactory();
    }

    public SavedStateViewModelFactory(@Nullable Application application, @NonNull SavedStateRegistryOwner owner) {
        this(application, owner, null);
    }

    @SuppressLint(value={"LambdaLast"})
    public SavedStateViewModelFactory(@Nullable Application application, @NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
        this.mSavedStateRegistry = owner.getSavedStateRegistry();
        this.mLifecycle = owner.getLifecycle();
        this.mDefaultArgs = defaultArgs;
        this.mApplication = application;
        this.mFactory = application != null ? ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application) : ViewModelProvider.NewInstanceFactory.getInstance();
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass, @NonNull CreationExtras extras) {
        String key = (String)extras.get(ViewModelProvider.NewInstanceFactory.VIEW_MODEL_KEY);
        if (key == null) {
            throw new IllegalStateException("VIEW_MODEL_KEY must always be provided by ViewModelProvider");
        }
        if (this.mLifecycle != null) {
            return this.create(key, modelClass);
        }
        Application application = (Application)extras.get(ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY);
        boolean isAndroidViewModel = AndroidViewModel.class.isAssignableFrom(modelClass);
        Constructor<T> constructor = isAndroidViewModel && application != null ? SavedStateViewModelFactory.findMatchingConstructor(modelClass, ANDROID_VIEWMODEL_SIGNATURE) : SavedStateViewModelFactory.findMatchingConstructor(modelClass, VIEWMODEL_SIGNATURE);
        if (constructor == null) {
            return (T)this.mFactory.create(modelClass, extras);
        }
        T viewmodel = isAndroidViewModel && application != null ? SavedStateViewModelFactory.newInstance(modelClass, constructor, application, SavedStateHandleSupport.createSavedStateHandle(extras)) : SavedStateViewModelFactory.newInstance(modelClass, constructor, SavedStateHandleSupport.createSavedStateHandle(extras));
        return viewmodel;
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass) {
        if (this.mLifecycle == null) {
            throw new UnsupportedOperationException("SavedStateViewModelFactory constructed with empty constructor supports only calls to create(modelClass: Class<T>, extras: CreationExtras).");
        }
        boolean isAndroidViewModel = AndroidViewModel.class.isAssignableFrom(modelClass);
        Constructor<T> constructor = isAndroidViewModel && this.mApplication != null ? SavedStateViewModelFactory.findMatchingConstructor(modelClass, ANDROID_VIEWMODEL_SIGNATURE) : SavedStateViewModelFactory.findMatchingConstructor(modelClass, VIEWMODEL_SIGNATURE);
        if (constructor == null) {
            return (T)this.mFactory.create(modelClass);
        }
        SavedStateHandleController controller = LegacySavedStateHandleController.create(this.mSavedStateRegistry, this.mLifecycle, key, this.mDefaultArgs);
        T viewmodel = isAndroidViewModel && this.mApplication != null ? SavedStateViewModelFactory.newInstance(modelClass, constructor, this.mApplication, controller.getHandle()) : SavedStateViewModelFactory.newInstance(modelClass, constructor, controller.getHandle());
        viewmodel.setTagIfAbsent("androidx.lifecycle.savedstate.vm.tag", (Object)controller);
        return viewmodel;
    }

    private static <T extends ViewModel> T newInstance(@NonNull Class<T> modelClass, Constructor<T> constructor, Object ... params) {
        try {
            return (T)((ViewModel)constructor.newInstance(params));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access " + modelClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("A " + modelClass + " cannot be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An exception happened in constructor of " + modelClass, e.getCause());
        }
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        String canonicalName = modelClass.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        return this.create(canonicalName, modelClass);
    }

    private static <T> Constructor<T> findMatchingConstructor(Class<T> modelClass, Class<?>[] signature) {
        for (Constructor<?> constructor : modelClass.getConstructors()) {
            Object[] parameterTypes = constructor.getParameterTypes();
            if (!Arrays.equals(signature, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onRequery(@NonNull ViewModel viewModel) {
        if (this.mLifecycle != null) {
            LegacySavedStateHandleController.attachHandleIfNeeded(viewModel, this.mSavedStateRegistry, this.mLifecycle);
        }
    }
}

