/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.CheckAccessUiVisitor;
import androidx.lifecycle.lint.LifecycleWhenChecks;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightModifierList;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"APPLICABLE_METHOD_NAMES", "", "", "getAPPLICABLE_METHOD_NAMES", "()Ljava/util/List;", "CONTINUATION_NAMES", "", "DISPATCHER_CLASS_NAME", "LIFECYCLE_CLASS_NAME", "SECONDARY_ERROR_MESSAGE", "checkUiAccess", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "whenMethodName", "errorMessage", "isLifecycleIsAtLeastMethod", "", "Lcom/intellij/psi/PsiMethod;", "isLifecycleWhenExtension", "isSuspend", "isSuspendLambda", "Lorg/jetbrains/uast/ULambdaExpression;", "lifecycle-runtime-ktx-lint"})
public final class LifecycleWhenChecksKt {
    private static final Set<String> CONTINUATION_NAMES = SetsKt.setOf((Object[])new String[]{"kotlin.coroutines.Continuation<? super kotlin.Unit>", "kotlin.coroutines.experimental.Continuation<? super kotlin.Unit>"});
    @NotNull
    public static final String SECONDARY_ERROR_MESSAGE = "Internal View access";
    @NotNull
    private static final List<String> APPLICABLE_METHOD_NAMES = CollectionsKt.listOf((Object[])new String[]{"whenCreated", "whenStarted", "whenResumed"});
    private static final String DISPATCHER_CLASS_NAME = "androidx.lifecycle.PausingDispatcherKt";
    private static final String LIFECYCLE_CLASS_NAME = "androidx.lifecycle.Lifecycle";

    @NotNull
    public static final String errorMessage(@NotNull String whenMethodName) {
        Intrinsics.checkNotNullParameter((Object)whenMethodName, (String)"whenMethodName");
        return "Unsafe View access from finally/catch block inside of `Lifecycle." + whenMethodName + "` scope";
    }

    @NotNull
    public static final List<String> getAPPLICABLE_METHOD_NAMES() {
        return APPLICABLE_METHOD_NAMES;
    }

    private static final boolean isLifecycleWhenExtension(PsiMethod $this$isLifecycleWhenExtension, JavaContext context) {
        return APPLICABLE_METHOD_NAMES.contains($this$isLifecycleWhenExtension.getName()) && context.getEvaluator().isMemberInClass((PsiMember)$this$isLifecycleWhenExtension, DISPATCHER_CLASS_NAME) && context.getEvaluator().isStatic((PsiModifierListOwner)$this$isLifecycleWhenExtension);
    }

    private static final boolean isLifecycleIsAtLeastMethod(PsiMethod $this$isLifecycleIsAtLeastMethod, JavaContext context) {
        return Intrinsics.areEqual((Object)$this$isLifecycleIsAtLeastMethod.getName(), (Object)"isAtLeast") && context.getEvaluator().isMemberInClass((PsiMember)$this$isLifecycleIsAtLeastMethod, LIFECYCLE_CLASS_NAME);
    }

    private static final boolean isSuspendLambda(ULambdaExpression $this$isSuspendLambda) {
        PsiClassType superBound;
        PsiType psiType = $this$isSuspendLambda.getExpressionType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return false;
        }
        PsiClassType expressionClass = psiClassType;
        PsiType[] psiTypeArray = expressionClass.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"expressionClass.parameters");
        PsiType[] params = psiTypeArray;
        if (params.length < 2) {
            return false;
        }
        PsiType psiType2 = params[params.length - 2];
        if (!(psiType2 instanceof PsiWildcardType)) {
            psiType2 = null;
        }
        PsiWildcardType psiWildcardType = (PsiWildcardType)psiType2;
        Object object = psiWildcardType != null ? psiWildcardType.getSuperBound() : null;
        if (!(object instanceof PsiClassType)) {
            object = null;
        }
        return (superBound = (PsiClassType)object) != null ? CONTINUATION_NAMES.contains(superBound.getCanonicalText()) : false;
    }

    private static final boolean isSuspend(PsiMethod $this$isSuspend) {
        KtLightModifierList modifiers;
        KtLightModifierList ktLightModifierList;
        PsiModifierList psiModifierList = $this$isSuspend.getModifierList();
        if (!(psiModifierList instanceof KtLightModifierList)) {
            psiModifierList = null;
        }
        return (ktLightModifierList = (modifiers = (KtLightModifierList)psiModifierList)) != null && (ktLightModifierList = ktLightModifierList.getKotlinOrigin()) != null ? ktLightModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
    }

    public static final void checkUiAccess(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull String whenMethodName) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)whenMethodName, (String)"whenMethodName");
            CheckAccessUiVisitor checkVisitor = new CheckAccessUiVisitor(context);
            node.accept((UastVisitor)checkVisitor);
            UCallExpression uCallExpression = checkVisitor.getUiAccessNode();
            if (uCallExpression == null) break block1;
            UCallExpression uCallExpression2 = uCallExpression;
            boolean bl = false;
            boolean bl2 = false;
            UCallExpression accessNode = uCallExpression2;
            boolean bl3 = false;
            Location mainLocation = context.getLocation((UElement)node);
            if (Intrinsics.areEqual((Object)accessNode, (Object)node) ^ true) {
                Location.withSecondary$default((Location)mainLocation, (Location)context.getLocation((UElement)accessNode), (String)SECONDARY_ERROR_MESSAGE, (boolean)false, (int)4, null);
            }
            Context.report$default((Context)((Context)context), (Issue)LifecycleWhenChecks.Companion.getISSUE(), (Location)mainLocation, (String)LifecycleWhenChecksKt.errorMessage(whenMethodName), null, (int)8, null);
        }
    }

    public static final /* synthetic */ boolean access$isLifecycleWhenExtension(PsiMethod $this$access_u24isLifecycleWhenExtension, JavaContext context) {
        return LifecycleWhenChecksKt.isLifecycleWhenExtension($this$access_u24isLifecycleWhenExtension, context);
    }

    public static final /* synthetic */ boolean access$isSuspend(PsiMethod $this$access_u24isSuspend) {
        return LifecycleWhenChecksKt.isSuspend($this$access_u24isSuspend);
    }

    public static final /* synthetic */ boolean access$isSuspendLambda(ULambdaExpression $this$access_u24isSuspendLambda) {
        return LifecycleWhenChecksKt.isSuspendLambda($this$access_u24isSuspendLambda);
    }

    public static final /* synthetic */ boolean access$isLifecycleIsAtLeastMethod(PsiMethod $this$access_u24isLifecycleIsAtLeastMethod, JavaContext context) {
        return LifecycleWhenChecksKt.isLifecycleIsAtLeastMethod($this$access_u24isLifecycleIsAtLeastMethod, context);
    }
}

