/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.MainCoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0003J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/lifecycle/DispatchQueue;", "", "()V", "finished", "", "isDraining", "paused", "queue", "Ljava/util/Queue;", "Ljava/lang/Runnable;", "canRun", "drainQueue", "", "enqueue", "runnable", "finish", "pause", "resume", "runOrEnqueue", "lifecycle-runtime-ktx_release"})
public final class DispatchQueue {
    private boolean paused = true;
    private boolean finished;
    private boolean isDraining;
    private final Queue<Runnable> queue = new ArrayDeque();

    @MainThread
    public final void pause() {
        this.paused = true;
    }

    @MainThread
    public final void resume() {
        if (!this.paused) {
            return;
        }
        boolean bl = !this.finished;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot resume a finished dispatcher";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.paused = false;
        this.drainQueue();
    }

    @MainThread
    public final void finish() {
        this.finished = true;
        this.drainQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void drainQueue() {
        if (this.isDraining) {
            return;
        }
        try {
            this.isDraining = true;
            while (true) {
                Collection collection = this.queue;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                if (!this.canRun()) {
                    break;
                }
                Runnable runnable = this.queue.poll();
                if (runnable == null) continue;
                runnable.run();
            }
        }
        finally {
            this.isDraining = false;
        }
    }

    @MainThread
    private final boolean canRun() {
        return this.finished || !this.paused;
    }

    @AnyThread
    @SuppressLint(value={"WrongThread"})
    public final void runOrEnqueue(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        MainCoroutineDispatcher mainCoroutineDispatcher = Dispatchers.getMain().getImmediate();
        boolean bl = false;
        boolean bl2 = false;
        MainCoroutineDispatcher $this$with = mainCoroutineDispatcher;
        boolean bl3 = false;
        if ($this$with.isDispatchNeeded((CoroutineContext)EmptyCoroutineContext.INSTANCE)) {
            $this$with.dispatch((CoroutineContext)EmptyCoroutineContext.INSTANCE, new Runnable(this, runnable){
                final /* synthetic */ DispatchQueue this$0;
                final /* synthetic */ Runnable $runnable$inlined;
                {
                    this.this$0 = dispatchQueue;
                    this.$runnable$inlined = runnable;
                }

                public final void run() {
                    DispatchQueue.access$enqueue(this.this$0, this.$runnable$inlined);
                }
            });
        } else {
            this.enqueue(runnable);
        }
    }

    @MainThread
    private final void enqueue(Runnable runnable) {
        boolean bl = this.queue.offer(runnable);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cannot enqueue any more runnables";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.drainQueue();
    }

    public static final /* synthetic */ void access$enqueue(DispatchQueue $this, Runnable runnable) {
        $this.enqueue(runnable);
    }
}

