/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.NonNullableMutableLiveDataDetector;
import androidx.lifecycle.lint.NonNullableMutableLiveDataDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightTypeParameter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.kotlin.KotlinUField;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001e\u0018\u00010\u0005H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010!J\f\u0010\"\u001a\u00020#*\u00020\u001aH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "methods", "", "", "getMethods", "()Ljava/util/List;", "typesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lkotlin/collections/HashMap;", "getTypesMap", "()Ljava/util/HashMap;", "checkNullability", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "message", "fixes", "Lcom/android/tools/lint/detector/api/LintFix;", "liveDataType", "node", "Lorg/jetbrains/uast/UCallExpression;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "getTypeArg", "classType", "Lcom/intellij/psi/PsiClassType;", "isGenericTypeDefinition", "", "Companion", "lifecycle-livedata-core-ktx-lint"})
public final class NonNullableMutableLiveDataDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, KtTypeReference> typesMap = new HashMap();
    @NotNull
    private final List<String> methods;
    @NotNull
    private static final Issue ISSUE;

    public NonNullableMutableLiveDataDetector() {
        Object[] objectArray = new String[]{"setValue", "postValue"};
        this.methods = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final HashMap<String, KtTypeReference> getTypesMap() {
        return this.typesMap;
    }

    @NotNull
    public final List<String> getMethods() {
        return this.methods;
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UClass.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ NonNullableMutableLiveDataDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitClass(@NotNull UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UDeclaration element : node.getUastDeclarations()) {
                    KtTypeReference ktTypeReference;
                    if (!(element instanceof KotlinUField) || this.getFieldTypeReference((KotlinUField)element) == null) continue;
                    NonNullableMutableLiveDataDetector nonNullableMutableLiveDataDetector = this.this$0;
                    KtTypeReference it = ktTypeReference;
                    boolean bl = false;
                    nonNullableMutableLiveDataDetector.getTypesMap().put(((KotlinUField)element).getName(), it);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final KtTypeReference getFieldTypeReference(KotlinUField element) {
                Object object;
                KtCallExpression expression;
                Object v5;
                KtElement ktElement;
                block20: {
                    KtTypeReference typeArgument;
                    KtTypeReference ktTypeReference;
                    KtTypeReference typeReference;
                    KtElement ktElement2;
                    Object v0;
                    block19: {
                        KtElement ktElement3 = element.getSourcePsi();
                        if (ktElement3 == null) {
                            v0 = null;
                        } else {
                            ktElement = ktElement3.getChildren();
                            if (ktElement == null) {
                                v0 = null;
                            } else {
                                void $this$firstOrNull$iv;
                                ktElement2 = ktElement;
                                boolean $i$f$firstOrNull = false;
                                for (void element$iv : $this$firstOrNull$iv) {
                                    void it = element$iv;
                                    boolean bl = false;
                                    if (!(it instanceof KtTypeReference)) continue;
                                    v0 = element$iv;
                                    break block19;
                                }
                                v0 = null;
                            }
                        }
                    }
                    Object var3_17 = v0;
                    KtTypeReference ktTypeReference2 = typeReference = var3_17 instanceof KtTypeReference ? (KtTypeReference)var3_17 : null;
                    if (ktTypeReference2 == null) {
                        ktTypeReference = null;
                    } else {
                        KtTypeElement ktTypeElement = ktTypeReference2.getTypeElement();
                        if (ktTypeElement == null) {
                            ktTypeReference = null;
                        } else {
                            List list = ktTypeElement.getTypeArgumentsAsTypes();
                            ktTypeReference = typeArgument = list == null ? null : (KtTypeReference)CollectionsKt.singleOrNull((List)list);
                        }
                    }
                    if (typeArgument != null) {
                        return typeArgument;
                    }
                    ktElement2 = element.getSourcePsi();
                    if (ktElement2 == null) {
                        v5 = null;
                    } else {
                        PsiElement[] psiElementArray = ktElement2.getChildren();
                        if (psiElementArray == null) {
                            v5 = null;
                        } else {
                            void $this$firstOrNull$iv;
                            PsiElement[] psiElementArray2 = psiElementArray;
                            boolean $i$f$firstOrNull = false;
                            for (void element$iv : $this$firstOrNull$iv) {
                                void it = element$iv;
                                boolean bl = false;
                                if (!(it instanceof KtCallExpression)) continue;
                                v5 = element$iv;
                                break block20;
                            }
                            v5 = null;
                        }
                    }
                }
                ktElement = v5;
                KtCallExpression ktCallExpression = expression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
                if (ktCallExpression == null) {
                    object = null;
                } else {
                    List list = ktCallExpression.getTypeArguments();
                    if (list == null) {
                        object = null;
                    } else {
                        KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
                        object = ktTypeProjection == null ? null : ktTypeProjection.getTypeReference();
                    }
                }
                return object;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                KtTypeReference liveDataType;
                Object object;
                PsiClassType receiverType;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!Lint.isKotlin((PsiElement)node.getSourcePsi()) || !CollectionsKt.contains((Iterable)this.this$0.getMethods(), (Object)node.getMethodName())) break block13;
                        JavaEvaluator javaEvaluator = this.$context.getEvaluator();
                        PsiMethod psiMethod = node.resolve();
                        Intrinsics.checkNotNull((Object)psiMethod);
                        if (javaEvaluator.isMemberInSubClassOf((PsiMember)psiMethod, "androidx.lifecycle.LiveData", false)) break block14;
                    }
                    return;
                }
                PsiType psiType = node.getReceiverType();
                PsiClassType psiClassType = receiverType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (receiverType != null && receiverType.hasParameters()) {
                    KtCallExpression constructorExpression;
                    UExpression assignment;
                    UExpression uExpression;
                    PsiVariable variable2;
                    UExpression uExpression2 = node.getReceiver();
                    KotlinUSimpleReferenceExpression kotlinUSimpleReferenceExpression = uExpression2 instanceof KotlinUSimpleReferenceExpression ? (KotlinUSimpleReferenceExpression)uExpression2 : null;
                    PsiElement receiver = kotlinUSimpleReferenceExpression == null ? null : kotlinUSimpleReferenceExpression.resolve();
                    PsiVariable psiVariable = variable2 = receiver instanceof PsiVariable ? (PsiVariable)receiver : null;
                    if (psiVariable == null) {
                        uExpression = null;
                    } else {
                        PsiVariable it = psiVariable;
                        boolean bl = false;
                        uExpression = UastLintUtils.Companion.findLastAssignment(it, (UElement)node);
                    }
                    UExpression uExpression3 = assignment = uExpression;
                    PsiElement psiElement = uExpression3 == null ? null : uExpression3.getSourcePsi();
                    KtCallExpression ktCallExpression = constructorExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
                    if (ktCallExpression == null) {
                        object = null;
                    } else {
                        List list = ktCallExpression.getTypeArguments();
                        if (list == null) {
                            object = null;
                        } else {
                            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
                            object = ktTypeProjection == null ? null : ktTypeProjection.getTypeReference();
                        }
                    }
                } else {
                    object = liveDataType = this.this$0.getTypeArg(receiverType);
                }
                if (liveDataType == null) {
                    KtTypeReference ktTypeReference = (KtTypeReference)((Map)this.this$0.getTypesMap()).get(this.getVariableName(node));
                    if (ktTypeReference == null) {
                        return;
                    }
                    liveDataType = ktTypeReference;
                }
                this.this$0.checkNullability(liveDataType, this.$context, node);
            }

            private final String getVariableName(UCallExpression node) {
                PsiElement variable2;
                Object v4;
                block5: {
                    Object v3;
                    Sequence $this$firstOrNull$iv;
                    boolean $i$f$firstOrNull;
                    block4: {
                        PsiElement dot2;
                        Object v1;
                        block3: {
                            PsiElement psiElement = node.getSourcePsi();
                            Sequence $this$firstOrNull$iv2 = SequencesKt.generateSequence((Object)(psiElement == null ? null : psiElement.getPrevSibling()), (Function1)createUastHandler.getVariableName.dot.1.INSTANCE);
                            boolean $i$f$firstOrNull2 = false;
                            for (E element$iv : $this$firstOrNull$iv2) {
                                PsiElement it = (PsiElement)element$iv;
                                boolean bl = false;
                                if (!(!(it instanceof PsiWhiteSpace))) continue;
                                v1 = element$iv;
                                break block3;
                            }
                            v1 = null;
                        }
                        PsiElement psiElement = dot2 = (PsiElement)v1;
                        Sequence $i$f$firstOrNull2 = SequencesKt.generateSequence((Object)(psiElement == null ? null : psiElement.getPrevSibling()), (Function1)createUastHandler.getVariableName.variable.1.INSTANCE);
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(!(it instanceof PsiWhiteSpace))) continue;
                            v3 = element$iv;
                            break block4;
                        }
                        v3 = null;
                    }
                    $this$firstOrNull$iv = SequencesKt.generateSequence(v3, (Function1)createUastHandler.getVariableName.variable.3.INSTANCE);
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                PsiElement psiElement = variable2 = (PsiElement)v4;
                return psiElement == null ? null : psiElement.getText();
            }
        };
    }

    @Nullable
    public final KtTypeReference getTypeArg(@Nullable PsiClassType classType) {
        UClass cls;
        if (classType == null) {
            return null;
        }
        PsiElement $this$getUastParentOfType$iv = (PsiElement)classType.resolve();
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = cls = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType$iv, UClass.class, (boolean)strict$iv);
        Object object = uClass == null ? null : uClass.getSuperClassType();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        }
        PsiClassType parentPsiType = (PsiClassType)object;
        if (parentPsiType.hasParameters()) {
            KtTypeElement superType;
            UTypeReferenceExpression parentTypeReference = (UTypeReferenceExpression)cls.getUastSuperTypes().get(0);
            PsiElement psiElement = parentTypeReference.getSourcePsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeElement ktTypeElement = superType = ((KtTypeReference)psiElement).getTypeElement();
            Intrinsics.checkNotNull((Object)ktTypeElement);
            return (KtTypeReference)ktTypeElement.getTypeArgumentsAsTypes().get(0);
        }
        return this.getTypeArg(parentPsiType);
    }

    public final void checkNullability(@NotNull KtTypeReference liveDataType, @NotNull JavaContext context, @NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)liveDataType, (String)"liveDataType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isGenericTypeDefinition(node)) {
            return;
        }
        if (!(liveDataType.getTypeElement() instanceof KtNullableType)) {
            UExpression argument;
            List fixes = new ArrayList();
            if (Intrinsics.areEqual((Object)context.getLocation((PsiElement)liveDataType).getFile(), (Object)context.file)) {
                fixes.add(this.fix().name("Change `LiveData` type to nullable").replace().with("?").range(context.getLocation((PsiElement)liveDataType)).end().build());
            }
            if (UastLiteralUtils.isNullLiteral((UElement)((UElement)(argument = (UExpression)node.getValueArguments().get(0))))) {
                this.checkNullability(context, (UElement)argument, "Cannot set non-nullable LiveData value to `null`", fixes);
            } else if (NonNullableMutableLiveDataDetectorKt.isNullable((UElement)argument)) {
                fixes.add(this.fix().name("Add non-null asserted (!!) call").replace().with("!!").range(context.getLocation((UElement)argument)).end().build());
                this.checkNullability(context, (UElement)argument, "Expected non-nullable value", fixes);
            }
        }
    }

    private final boolean isGenericTypeDefinition(UCallExpression $this$isGenericTypeDefinition) {
        PsiClassType.ClassResolveResult resolveGenerics;
        PsiImmediateClassType classType;
        Object object = CollectionsKt.singleOrNull((List)$this$isGenericTypeDefinition.getTypeArguments());
        PsiImmediateClassType psiImmediateClassType = classType = object instanceof PsiImmediateClassType ? (PsiImmediateClassType)object : null;
        PsiClassType.ClassResolveResult classResolveResult = resolveGenerics = psiImmediateClassType == null ? null : psiImmediateClassType.resolveGenerics();
        return (classResolveResult == null ? null : classResolveResult.getElement()) instanceof KtLightTypeParameter;
    }

    private final void checkNullability(JavaContext context, UElement element, String message, List<? extends LintFix> fixes) {
        if (fixes.isEmpty()) {
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation(element), (String)message, null, (int)8, null);
        } else {
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            if (lintFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            LintFix[] lintFixArray2 = lintFixArray;
            context.report(ISSUE, context.getLocation(element), message, this.fix().alternatives(Arrays.copyOf(lintFixArray2, lintFixArray2.length)));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(NonNullableMutableLiveDataDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"NullSafeMutableLiveData", (String)"LiveData value assignment nullability mismatch", (String)"This check ensures that LiveData values are not null when explicitly \\\n                declared as non-nullable.\n\n                Kotlin interoperability does not support enforcing explicit null-safety when using \\\n                generic Java type parameters. Since LiveData is a Java class its value can always \\\n                be null even when its type is explicitly declared as non-nullable. This can lead \\\n                to runtime exceptions from reading a null LiveData value that is assumed to be \\\n                non-nullable.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/lint/NonNullableMutableLiveDataDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-livedata-core-ktx-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

