/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Landroidx/lifecycle/Validator;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "printErrorMessage", "", "msg", "", "elem", "Ljavax/lang/model/element/Element;", "validateClass", "", "classElement", "validateMethod", "method", "Ljavax/lang/model/element/ExecutableElement;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "validateParam", "param", "Ljavax/lang/model/element/VariableElement;", "expectedType", "Ljava/lang/Class;", "errorMsg", "", "lifecycle-compiler"})
public final class Validator {
    @NotNull
    private final ProcessingEnvironment processingEnv;

    public final void printErrorMessage(@NotNull CharSequence msg, @NotNull Element elem) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elem);
    }

    public final boolean validateParam(@NotNull VariableElement param, @NotNull Class<?> expectedType, @NotNull String errorMsg) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        Intrinsics.checkParameterIsNotNull(expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
        if (!MoreTypes.isTypeOf(expectedType, (TypeMirror)param.asType())) {
            this.printErrorMessage(errorMsg, param);
            return false;
        }
        return true;
    }

    public final boolean validateMethod(@NotNull ExecutableElement method, @NotNull Lifecycle.Event event) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.printErrorMessage("method marked with OnLifecycleEvent annotation can not be private", method);
            return false;
        }
        List<? extends VariableElement> params = method.getParameters();
        if (params.size() > 2) {
            this.printErrorMessage("callback method cannot have more than 2 parameters", method);
            return false;
        }
        if (params.size() == 2 && event != Lifecycle.Event.ON_ANY) {
            this.printErrorMessage("only callback annotated with ON_ANY can have 2 parameters", method);
            return false;
        }
        if (params.size() == 2) {
            VariableElement variableElement = params.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"params[1]");
            if (!this.validateParam(variableElement, Lifecycle.Event.class, "2nd argument of a callback method must be Lifecycle.Event and represent the current event")) {
                return false;
            }
        }
        if (params.size() > 0) {
            VariableElement variableElement = params.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"params[0]");
            return this.validateParam(variableElement, LifecycleOwner.class, "1st argument of a callback method must be a LifecycleOwner which represents the source of the event");
        }
        return true;
    }

    public final boolean validateClass(@NotNull Element classElement) {
        Intrinsics.checkParameterIsNotNull((Object)classElement, (String)"classElement");
        if (!MoreElements.isType((Element)classElement)) {
            this.printErrorMessage("Parent of OnLifecycleEvent should be a class or interface", classElement);
            return false;
        }
        if (classElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.printErrorMessage("class containing OnLifecycleEvent methods can not be private", classElement);
            return false;
        }
        return true;
    }

    @NotNull
    public final ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    public Validator(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        this.processingEnv = processingEnv;
    }
}

