/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.path;

import android.graphics.Path;
import android.graphics.PathIterator;
import androidx.annotation.RequiresApi;
import androidx.graphics.path.ConicConverter;
import androidx.graphics.path.PathIterator;
import androidx.graphics.path.PathIteratorImpl;
import androidx.graphics.path.PathIteratorImplKt;
import androidx.graphics.path.PathSegment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/graphics/path/PathIteratorApi34Impl;", "Landroidx/graphics/path/PathIteratorImpl;", "path", "Landroid/graphics/Path;", "conicEvaluation", "Landroidx/graphics/path/PathIterator$ConicEvaluation;", "tolerance", "", "(Landroid/graphics/Path;Landroidx/graphics/path/PathIterator$ConicEvaluation;F)V", "conicConverter", "Landroidx/graphics/path/ConicConverter;", "platformIterator", "Landroid/graphics/PathIterator;", "calculateSize", "", "includeConvertedConics", "", "hasNext", "next", "Landroidx/graphics/path/PathSegment$Type;", "points", "", "offset", "peek", "graphics-path_release"})
@RequiresApi(value=34)
public final class PathIteratorApi34Impl
extends PathIteratorImpl {
    @NotNull
    private final PathIterator platformIterator;
    @NotNull
    private final ConicConverter conicConverter;

    public PathIteratorApi34Impl(@NotNull Path path, @NotNull PathIterator.ConicEvaluation conicEvaluation, float tolerance) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)conicEvaluation), (String)"conicEvaluation");
        super(path, conicEvaluation, tolerance);
        PathIterator pathIterator = path.getPathIterator();
        Intrinsics.checkNotNullExpressionValue((Object)pathIterator, (String)"path.pathIterator");
        this.platformIterator = pathIterator;
        this.conicConverter = new ConicConverter();
    }

    public /* synthetic */ PathIteratorApi34Impl(Path path, PathIterator.ConicEvaluation conicEvaluation, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            conicEvaluation = PathIterator.ConicEvaluation.AsQuadratics;
        }
        if ((n & 4) != 0) {
            f = 0.25f;
        }
        this(path, conicEvaluation, f);
    }

    @Override
    public int calculateSize(boolean includeConvertedConics) {
        boolean convertConics = includeConvertedConics && this.getConicEvaluation() == PathIterator.ConicEvaluation.AsQuadratics;
        int numVerbs = 0;
        PathIterator pathIterator = this.getPath().getPathIterator();
        Intrinsics.checkNotNullExpressionValue((Object)pathIterator, (String)"path.pathIterator");
        PathIterator tempIterator = pathIterator;
        float[] tempFloats = new float[8];
        while (tempIterator.hasNext()) {
            int type = tempIterator.next(tempFloats, 0);
            if (type == 3 && convertConics) {
                ConicConverter $this$calculateSize_u24lambda_u240 = this.conicConverter;
                boolean bl = false;
                ConicConverter.convert$default($this$calculateSize_u24lambda_u240, tempFloats, tempFloats[6], this.getTolerance(), 0, 8, null);
                numVerbs += $this$calculateSize_u24lambda_u240.getQuadraticCount();
                continue;
            }
            int n = numVerbs;
            numVerbs = n + 1;
        }
        return numVerbs;
    }

    @Override
    @NotNull
    public PathSegment.Type next(@NotNull float[] points, int offset) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        if (this.conicConverter.getCurrentQuadratic() < this.conicConverter.getQuadraticCount()) {
            this.conicConverter.nextQuadratic(points, offset);
            return PathSegment.Type.Quadratic;
        }
        PathSegment.Type typeValue = PathIteratorImplKt.access$platformToAndroidXSegmentType(this.platformIterator.next(points, offset));
        if (typeValue == PathSegment.Type.Conic && this.getConicEvaluation() == PathIterator.ConicEvaluation.AsQuadratics) {
            ConicConverter $this$next_u24lambda_u241 = this.conicConverter;
            boolean bl = false;
            $this$next_u24lambda_u241.convert(points, points[6 + offset], this.getTolerance(), offset);
            if ($this$next_u24lambda_u241.getQuadraticCount() > 0) {
                $this$next_u24lambda_u241.nextQuadratic(points, offset);
            }
            return PathSegment.Type.Quadratic;
        }
        return typeValue;
    }

    @Override
    public boolean hasNext() {
        return this.platformIterator.hasNext();
    }

    @Override
    @NotNull
    public PathSegment.Type peek() {
        return PathIteratorImplKt.access$platformToAndroidXSegmentType(this.platformIterator.peek());
    }
}

