/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.databinding.ObservableReference;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class WeakListener<T>
extends WeakReference<ViewDataBinding> {
    private final ObservableReference<T> mObservable;
    protected final int mLocalFieldId;
    private T mTarget;

    public WeakListener(ViewDataBinding binder, int localFieldId, ObservableReference<T> observable, ReferenceQueue<ViewDataBinding> referenceQueue) {
        super(binder, referenceQueue);
        this.mLocalFieldId = localFieldId;
        this.mObservable = observable;
    }

    public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
        this.mObservable.setLifecycleOwner(lifecycleOwner);
    }

    public void setTarget(T object) {
        this.unregister();
        this.mTarget = object;
        if (this.mTarget != null) {
            this.mObservable.addListener(this.mTarget);
        }
    }

    public boolean unregister() {
        boolean unregistered = false;
        if (this.mTarget != null) {
            this.mObservable.removeListener(this.mTarget);
            unregistered = true;
        }
        this.mTarget = null;
        return unregistered;
    }

    public T getTarget() {
        return this.mTarget;
    }

    @Nullable
    protected ViewDataBinding getBinder() {
        ViewDataBinding binder = (ViewDataBinding)this.get();
        if (binder == null) {
            this.unregister();
        }
        return binder;
    }
}

