/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.CallbackWrapper;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.LibTypes;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import android.databinding.tool.writer.CallbackWrapperWriter;
import android.databinding.tool.writer.ComponentWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataBinder {
    List<LayoutBinder> mLayoutBinders = new ArrayList<LayoutBinder>();
    private final String mComponentClass;
    private JavaFileWriter mFileWriter;
    Set<String> mClassesToBeStripped = new HashSet<String>();
    private final boolean mEnableV2;
    private final LibTypes mLibTypes;

    public DataBinder(ResourceBundle resourceBundle, boolean enableV2, LibTypes libTypes) {
        L.d((String)"reading resource bundle into data binder.enable V2: %s, layout cnt:%d", (Object[])new Object[]{enableV2, resourceBundle.getLayoutFileBundlesInSource().size()});
        this.mLibTypes = libTypes;
        this.mEnableV2 = enableV2;
        this.mComponentClass = this.mLibTypes.getBindingPackage() + ".DataBindingComponent";
        if (this.mEnableV2) {
            for (ResourceBundle.LayoutFileBundle bundle : resourceBundle.getLayoutFileBundlesInSource()) {
                try {
                    L.d((String)"adding layout binder %s", (Object[])new Object[]{bundle.getBindingClassName()});
                    this.mLayoutBinders.add(new LayoutBinder(bundle, true));
                    L.d((String)"added %s", (Object[])new Object[]{bundle.getBindingClassName()});
                }
                catch (ScopedException ex) {
                    L.d((String)"FAILED TO ADD layout binder %s", (Object[])new Object[]{bundle.getBindingClassName()});
                    Scope.defer((ScopedException)ex);
                }
            }
        } else {
            for (Map.Entry entry : resourceBundle.getLayoutBundles().entrySet()) {
                for (ResourceBundle.LayoutFileBundle bundle : (List)entry.getValue()) {
                    try {
                        this.mLayoutBinders.add(new LayoutBinder(bundle, false));
                    }
                    catch (ScopedException ex) {
                        Scope.defer((ScopedException)ex);
                    }
                }
            }
        }
        L.d((String)"done loading info files into data binding.", (Object[])new Object[0]);
    }

    public List<LayoutBinder> getLayoutBinders() {
        return this.mLayoutBinders;
    }

    public void sealModels() {
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            layoutBinder.sealModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writerBaseClasses(boolean isLibrary) {
        Preconditions.check((!this.mEnableV2 ? 1 : 0) != 0, (String)"Should not call write base classes in v2", (Object[])new Object[0]);
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            try {
                Scope.enter((ScopeProvider)layoutBinder);
                if (!isLibrary && !layoutBinder.hasVariations()) continue;
                String className = layoutBinder.getClassName();
                String canonicalName2 = layoutBinder.getPackage() + "." + className;
                if (this.mClassesToBeStripped.contains(canonicalName2)) continue;
                List<LayoutBinder> variations = DataBinder.getVariations(this.mLayoutBinders, canonicalName2);
                L.d((String)"writing data binder base %s", (Object[])new Object[]{canonicalName2});
                this.mFileWriter.writeToFile(canonicalName2, layoutBinder.writeViewBinderBaseClass(isLibrary, variations));
                this.mClassesToBeStripped.add(canonicalName2);
            }
            catch (ScopedException ex) {
                Scope.defer((ScopedException)ex);
            }
            finally {
                Scope.exit();
            }
        }
    }

    private static List<LayoutBinder> getVariations(List<LayoutBinder> mLayoutBinders, String canonicalName2) {
        ArrayList<LayoutBinder> variations = new ArrayList<LayoutBinder>();
        for (LayoutBinder layoutBinder : mLayoutBinders) {
            String className = layoutBinder.getClassName();
            String name = layoutBinder.getPackage() + "." + className;
            if (!name.equals(canonicalName2)) continue;
            variations.add(layoutBinder);
        }
        return variations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinders(int minSdk) {
        this.writeCallbackWrappers(minSdk);
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            try {
                Scope.enter((ScopeProvider)layoutBinder);
                String className = layoutBinder.getImplementationName();
                String canonicalName2 = layoutBinder.getPackage() + "." + className;
                L.d((String)"writing data binder %s", (Object[])new Object[]{canonicalName2});
                if (!this.mEnableV2) {
                    this.mClassesToBeStripped.add(canonicalName2);
                }
                this.mFileWriter.writeToFile(canonicalName2, layoutBinder.writeViewBinder(minSdk));
            }
            catch (ScopedException ex) {
                Scope.defer((ScopedException)ex);
            }
            catch (Throwable t) {
                L.e((Throwable)t, (String)"Unexpected error while processing layout file: %s.xml\n\nPlease file a bug on https://issuetracker.google.com/issues/new?component=192721&template=1096850 with a sample project that reproduces the problem.", (Object[])new Object[]{layoutBinder.getLayoutname()});
            }
            finally {
                Scope.exit();
            }
        }
    }

    private void writeCallbackWrappers(int minSdk) {
        HashMap<String, CallbackWrapper> uniqueWrappers = new HashMap<String, CallbackWrapper>();
        HashSet<String> classNames = new HashSet<String>();
        boolean callbackCounter = false;
        for (LayoutBinder binder : this.mLayoutBinders) {
            for (Map.Entry<String, CallbackWrapper> entry : binder.getModel().getCallbackWrappers().entrySet()) {
                CallbackWrapper existing = (CallbackWrapper)uniqueWrappers.get(entry.getKey());
                if (existing == null) {
                    CallbackWrapper wrapper = entry.getValue();
                    uniqueWrappers.put(entry.getKey(), wrapper);
                    String listenerName = this.makeUnique(classNames, wrapper.klass.getSimpleName());
                    String methodName = this.makeUnique(classNames, "_internalCallback" + StringUtils.capitalize((String)wrapper.method.getName()));
                    wrapper.prepare(listenerName, methodName);
                    continue;
                }
                entry.getValue().prepare(existing.getClassName(), existing.getListenerMethodName());
            }
        }
        for (CallbackWrapper wrapper : uniqueWrappers.values()) {
            String code = new CallbackWrapperWriter(wrapper).write();
            String className = wrapper.getClassName();
            String canonicalName2 = wrapper.getPackage() + "." + className;
            this.mFileWriter.writeToFile(canonicalName2, code);
            if (this.mEnableV2) continue;
            this.mClassesToBeStripped.add(canonicalName2);
        }
    }

    private String makeUnique(Set<String> existing, String wanted) {
        int cnt = 1;
        while (existing.contains(wanted)) {
            wanted = (String)wanted + cnt;
            ++cnt;
        }
        existing.add((String)wanted);
        return wanted;
    }

    public void writeComponent() {
        ComponentWriter componentWriter = new ComponentWriter(this.mLibTypes);
        this.mClassesToBeStripped.add(this.mComponentClass);
        this.mFileWriter.writeToFile(this.mComponentClass, componentWriter.createComponent());
    }

    public Set<String> getClassesToBeStripped() {
        return this.mClassesToBeStripped;
    }

    public void setFileWriter(JavaFileWriter fileWriter) {
        this.mFileWriter = fileWriter;
    }

    public JavaFileWriter getFileWriter() {
        return this.mFileWriter;
    }
}

