/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.BindableCompat;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationClass;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class AnnotationField
extends ModelField {
    final VariableElement mField;
    final DeclaredType mDeclaredClass;

    public AnnotationField(DeclaredType declaredClass, VariableElement field) {
        this.mDeclaredClass = declaredClass;
        this.mField = field;
    }

    public String toString() {
        return this.mField.toString();
    }

    @Override
    public String getName() {
        return this.mField.getSimpleName().toString();
    }

    @Override
    public boolean isPublic() {
        return this.mField.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isStatic() {
        return this.mField.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isFinal() {
        return this.mField.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public ModelClass getFieldType() {
        Types typeUtils = AnnotationAnalyzer.get().getTypeUtils();
        TypeMirror type = typeUtils.asMemberOf(this.mDeclaredClass, this.mField);
        return new AnnotationClass(type);
    }

    @Override
    public BindableCompat getBindableAnnotation() {
        return BindableCompat.extractFrom((Element)this.mField);
    }

    public int hashCode() {
        return this.mField.getSimpleName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationField) {
            AnnotationField that = (AnnotationField)obj;
            Types typeUtils = AnnotationAnalyzer.get().getTypeUtils();
            return typeUtils.isSameType(this.mDeclaredClass, that.mDeclaredClass) && typeUtils.isSameType(this.mField.asType(), that.mField.asType()) && this.mField.getSimpleName().equals(that.mField.getSimpleName());
        }
        return false;
    }
}

