/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.widget.AbsSpinner;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.adapters.ObservableListAdapter;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AbsSpinnerBindingAdapter {
    @BindingAdapter(value={"android:entries"})
    public static <T extends CharSequence> void setEntries(AbsSpinner view, T[] entries) {
        if (entries != null) {
            SpinnerAdapter oldAdapter = view.getAdapter();
            boolean changed = true;
            if (oldAdapter != null && oldAdapter.getCount() == entries.length) {
                changed = false;
                for (int i = 0; i < entries.length; ++i) {
                    if (entries[i].equals(oldAdapter.getItem(i))) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                ArrayAdapter adapter = new ArrayAdapter(view.getContext(), 17367048, (Object[])entries);
                adapter.setDropDownViewResource(0x1090009);
                view.setAdapter((SpinnerAdapter)adapter);
            }
        } else {
            view.setAdapter(null);
        }
    }

    @BindingAdapter(value={"android:entries"})
    public static <T> void setEntries(AbsSpinner view, List<T> entries) {
        if (entries != null) {
            SpinnerAdapter oldAdapter = view.getAdapter();
            if (oldAdapter instanceof ObservableListAdapter) {
                ((ObservableListAdapter)oldAdapter).setList(entries);
            } else {
                view.setAdapter(new ObservableListAdapter<T>(view.getContext(), entries, 17367048, 0x1090009, 0));
            }
        } else {
            view.setAdapter(null);
        }
    }
}

