/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets.analyzer;

import androidx.constraintlayout.solver.widgets.Barrier;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.Flow;
import androidx.constraintlayout.solver.widgets.Guideline;
import androidx.constraintlayout.solver.widgets.HelperWidget;
import androidx.constraintlayout.solver.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.solver.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.Iterator;

public class Grouping {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_GROUPING = false;

    public static boolean validInGroup(ConstraintWidget.DimensionBehaviour layoutHorizontal, ConstraintWidget.DimensionBehaviour layoutVertical, ConstraintWidget.DimensionBehaviour widgetHorizontal, ConstraintWidget.DimensionBehaviour widgetVertical) {
        boolean fixedVertical;
        boolean fixedHorizontal = widgetHorizontal == ConstraintWidget.DimensionBehaviour.FIXED || widgetHorizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetHorizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutHorizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean bl = fixedVertical = widgetVertical == ConstraintWidget.DimensionBehaviour.FIXED || widgetVertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetVertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutVertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        return fixedHorizontal || fixedVertical;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean simpleSolvingPass(ConstraintWidgetContainer layout, BasicMeasure.Measurer measurer) {
        ConstraintAnchor constraintAnchor;
        ConstraintAnchor constraintAnchor2;
        ConstraintAnchor constraintAnchor3;
        ConstraintAnchor top;
        ConstraintAnchor constraintAnchor4;
        ConstraintAnchor constraintAnchor5;
        Iterator left;
        ArrayList<WidgetGroup> allDependencyLists;
        ConstraintWidget child;
        int i;
        ArrayList<ConstraintWidget> children = layout.getChildren();
        int count = children.size();
        ArrayList<Guideline> verticalGuidelines = null;
        ArrayList<Guideline> horizontalGuidelines = null;
        ArrayList<Object> horizontalBarriers = null;
        ArrayList<Barrier> verticalBarriers = null;
        ArrayList<ConstraintWidget> isolatedHorizontalChildren = null;
        ArrayList<ConstraintWidget> isolatedVerticalChildren = null;
        for (i = 0; i < count; ++i) {
            child = children.get(i);
            if (!Grouping.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                return false;
            }
            if (!(child instanceof Flow)) continue;
            return false;
        }
        if (layout.mMetrics != null) {
            ++layout.mMetrics.grouping;
        }
        for (i = 0; i < count; ++i) {
            child = children.get(i);
            if (!Grouping.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                ConstraintWidgetContainer.measure(child, measurer, layout.mMeasure, BasicMeasure.Measure.SELF_DIMENSIONS);
            }
            if (child instanceof Guideline) {
                Guideline guideline = (Guideline)child;
                if (guideline.getOrientation() == 0) {
                    if (horizontalGuidelines == null) {
                        horizontalGuidelines = new ArrayList<Guideline>();
                    }
                    horizontalGuidelines.add(guideline);
                }
                if (guideline.getOrientation() == 1) {
                    if (verticalGuidelines == null) {
                        verticalGuidelines = new ArrayList<Guideline>();
                    }
                    verticalGuidelines.add(guideline);
                }
            }
            if (child instanceof HelperWidget) {
                if (child instanceof Barrier) {
                    Barrier barrier = (Barrier)child;
                    if (barrier.getOrientation() == 0) {
                        if (horizontalBarriers == null) {
                            horizontalBarriers = new ArrayList();
                        }
                        horizontalBarriers.add(barrier);
                    }
                    if (barrier.getOrientation() == 1) {
                        if (verticalBarriers == null) {
                            verticalBarriers = new ArrayList();
                        }
                        verticalBarriers.add(barrier);
                    }
                } else {
                    HelperWidget helper = (HelperWidget)child;
                    if (horizontalBarriers == null) {
                        horizontalBarriers = new ArrayList<Object>();
                    }
                    horizontalBarriers.add(helper);
                    if (verticalBarriers == null) {
                        verticalBarriers = new ArrayList<Barrier>();
                    }
                    verticalBarriers.add((Barrier)helper);
                }
            }
            if (child.mLeft.mTarget == null && child.mRight.mTarget == null && !(child instanceof Guideline) && !(child instanceof Barrier)) {
                if (isolatedHorizontalChildren == null) {
                    isolatedHorizontalChildren = new ArrayList<ConstraintWidget>();
                }
                isolatedHorizontalChildren.add(child);
            }
            if (child.mTop.mTarget != null || child.mBottom.mTarget != null || child.mBaseline.mTarget != null || child instanceof Guideline || child instanceof Barrier) continue;
            if (isolatedVerticalChildren == null) {
                isolatedVerticalChildren = new ArrayList<ConstraintWidget>();
            }
            isolatedVerticalChildren.add(child);
        }
        ArrayList<WidgetGroup> dependencyLists = allDependencyLists = new ArrayList<WidgetGroup>();
        if (verticalGuidelines != null) {
            for (Guideline guideline : verticalGuidelines) {
                Grouping.findDependents(guideline, 0, dependencyLists, null);
            }
        }
        if (horizontalBarriers != null) {
            for (HelperWidget helperWidget : horizontalBarriers) {
                WidgetGroup widgetGroup = Grouping.findDependents(helperWidget, 0, dependencyLists, null);
                helperWidget.addDependents(dependencyLists, 0, widgetGroup);
                widgetGroup.cleanup(dependencyLists);
            }
        }
        if (((ConstraintAnchor)((Object)(left = layout.getAnchor(ConstraintAnchor.Type.LEFT)))).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor6 : ((ConstraintAnchor)((Object)left)).getDependents()) {
                Grouping.findDependents(constraintAnchor6.mOwner, 0, dependencyLists, null);
            }
        }
        if ((constraintAnchor5 = layout.getAnchor(ConstraintAnchor.Type.RIGHT)).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor7 : constraintAnchor5.getDependents()) {
                Grouping.findDependents(constraintAnchor7.mOwner, 0, dependencyLists, null);
            }
        }
        if ((constraintAnchor4 = layout.getAnchor(ConstraintAnchor.Type.CENTER)).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor8 : constraintAnchor4.getDependents()) {
                Grouping.findDependents(constraintAnchor8.mOwner, 0, dependencyLists, null);
            }
        }
        if (isolatedHorizontalChildren != null) {
            for (ConstraintWidget constraintWidget : isolatedHorizontalChildren) {
                Grouping.findDependents(constraintWidget, 0, dependencyLists, null);
            }
        }
        dependencyLists = allDependencyLists;
        if (horizontalGuidelines != null) {
            for (Guideline guideline : horizontalGuidelines) {
                Grouping.findDependents(guideline, 1, dependencyLists, null);
            }
        }
        if (verticalBarriers != null) {
            for (HelperWidget helperWidget : verticalBarriers) {
                WidgetGroup widgetGroup = Grouping.findDependents(helperWidget, 1, dependencyLists, null);
                helperWidget.addDependents(dependencyLists, 1, widgetGroup);
                widgetGroup.cleanup(dependencyLists);
            }
        }
        if ((top = layout.getAnchor(ConstraintAnchor.Type.TOP)).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor9 : top.getDependents()) {
                Grouping.findDependents(constraintAnchor9.mOwner, 1, dependencyLists, null);
            }
        }
        if ((constraintAnchor3 = layout.getAnchor(ConstraintAnchor.Type.BASELINE)).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor10 : constraintAnchor3.getDependents()) {
                Grouping.findDependents(constraintAnchor10.mOwner, 1, dependencyLists, null);
            }
        }
        if ((constraintAnchor2 = layout.getAnchor(ConstraintAnchor.Type.BOTTOM)).getDependents() != null) {
            for (ConstraintAnchor constraintAnchor11 : constraintAnchor2.getDependents()) {
                Grouping.findDependents(constraintAnchor11.mOwner, 1, dependencyLists, null);
            }
        }
        if ((constraintAnchor = layout.getAnchor(ConstraintAnchor.Type.CENTER)).getDependents() != null) {
            for (ConstraintAnchor first : constraintAnchor.getDependents()) {
                Grouping.findDependents(first.mOwner, 1, dependencyLists, null);
            }
        }
        if (isolatedVerticalChildren != null) {
            for (ConstraintWidget widget : isolatedVerticalChildren) {
                Grouping.findDependents(widget, 1, dependencyLists, null);
            }
        }
        for (int i2 = 0; i2 < count; ++i2) {
            ConstraintWidget child2 = children.get(i2);
            if (!child2.oppositeDimensionsTied()) continue;
            WidgetGroup widgetGroup = Grouping.findGroup(allDependencyLists, child2.horizontalGroup);
            WidgetGroup widgetGroup2 = Grouping.findGroup(allDependencyLists, child2.verticalGroup);
            if (widgetGroup == null || widgetGroup2 == null) continue;
            widgetGroup.moveTo(0, widgetGroup2);
            widgetGroup2.setOrientation(2);
            allDependencyLists.remove(widgetGroup);
        }
        if (allDependencyLists.size() <= 1) {
            return false;
        }
        Object horizontalPick = null;
        Object verticalPick = null;
        if (layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            void var14_51;
            int n;
            boolean bl = false;
            Object var14_50 = null;
            for (WidgetGroup widgetGroup : allDependencyLists) {
                if (widgetGroup.getOrientation() == 1) continue;
                widgetGroup.setAuthoritative(false);
                int wrap = widgetGroup.measureWrap(layout.getSystem(), 0);
                if (wrap <= n) continue;
                WidgetGroup widgetGroup3 = widgetGroup;
                n = wrap;
            }
            if (var14_51 != null) {
                layout.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                layout.setWidth(n);
                var14_51.setAuthoritative(true);
                horizontalPick = var14_51;
            }
        }
        if (layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            void var14_55;
            int n;
            boolean bl = false;
            Object var14_54 = null;
            for (WidgetGroup widgetGroup : allDependencyLists) {
                if (widgetGroup.getOrientation() == 0) continue;
                widgetGroup.setAuthoritative(false);
                int wrap = widgetGroup.measureWrap(layout.getSystem(), 1);
                if (wrap <= n) continue;
                WidgetGroup widgetGroup4 = widgetGroup;
                n = wrap;
            }
            if (var14_55 != null) {
                layout.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                layout.setHeight(n);
                var14_55.setAuthoritative(true);
                verticalPick = var14_55;
            }
        }
        return horizontalPick != null || verticalPick != null;
    }

    private static WidgetGroup findGroup(ArrayList<WidgetGroup> horizontalDependencyLists, int groupId) {
        int count = horizontalDependencyLists.size();
        for (int i = 0; i < count; ++i) {
            WidgetGroup group = horizontalDependencyLists.get(i);
            if (groupId != group.id) continue;
            return group;
        }
        return null;
    }

    public static WidgetGroup findDependents(ConstraintWidget constraintWidget, int orientation, ArrayList<WidgetGroup> list, WidgetGroup group) {
        int groupId = -1;
        groupId = orientation == 0 ? constraintWidget.horizontalGroup : constraintWidget.verticalGroup;
        if (groupId != -1 && (group == null || groupId != group.id)) {
            for (int i = 0; i < list.size(); ++i) {
                WidgetGroup widgetGroup = list.get(i);
                if (widgetGroup.getId() != groupId) continue;
                if (group != null) {
                    group.moveTo(orientation, widgetGroup);
                    list.remove(group);
                }
                group = widgetGroup;
                break;
            }
        } else if (groupId != -1) {
            return group;
        }
        if (group == null) {
            HelperWidget helper;
            if (constraintWidget instanceof HelperWidget && (groupId = (helper = (HelperWidget)constraintWidget).findGroupInDependents(orientation)) != -1) {
                for (int i = 0; i < list.size(); ++i) {
                    WidgetGroup widgetGroup = list.get(i);
                    if (widgetGroup.getId() != groupId) continue;
                    group = widgetGroup;
                    break;
                }
            }
            if (group == null) {
                group = new WidgetGroup(orientation);
            }
            list.add(group);
        }
        if (group.add(constraintWidget)) {
            if (constraintWidget instanceof Guideline) {
                Guideline guideline = (Guideline)constraintWidget;
                guideline.getAnchor().findDependents(guideline.getOrientation() == 0 ? 1 : 0, list, group);
            }
            if (orientation == 0) {
                constraintWidget.horizontalGroup = group.getId();
                constraintWidget.mLeft.findDependents(orientation, list, group);
                constraintWidget.mRight.findDependents(orientation, list, group);
            } else {
                constraintWidget.verticalGroup = group.getId();
                constraintWidget.mTop.findDependents(orientation, list, group);
                constraintWidget.mBaseline.findDependents(orientation, list, group);
                constraintWidget.mBottom.findDependents(orientation, list, group);
            }
            constraintWidget.mCenter.findDependents(orientation, list, group);
        }
        return group;
    }
}

