/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver;

import androidx.constraintlayout.solver.ArrayRow;
import androidx.constraintlayout.solver.Cache;
import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.SolverVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class PriorityGoalRow
extends ArrayRow {
    ArrayList<GoalVariable> goals = new ArrayList();
    HashMap<Integer, GoalVariable> keyedGoals = new HashMap();
    static Cache sCache = null;
    private static final float epsilon = 1.0E-4f;
    static RowVariable sRowVariable = new RowVariable();
    private static final boolean DEBUG = false;
    Cache mCache;

    @Override
    public void clear() {
        int count = this.goals.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                GoalVariable v = this.goals.get(i);
                this.mCache.goalVariablePool.release(v);
            }
        }
        this.goals.clear();
        this.keyedGoals.clear();
        this.constantValue = 0.0f;
    }

    public PriorityGoalRow(Cache cache) {
        super(cache);
        this.mCache = cache;
    }

    @Override
    public SolverVariable getPivotCandidate(LinearSystem system, boolean[] avoid) {
        sCache = this.mCache;
        GoalVariable pivot = null;
        int count = this.goals.size();
        for (int i = 0; i < count; ++i) {
            GoalVariable v = this.goals.get(i);
            if (avoid[v.variableId]) continue;
            if (pivot == null) {
                if (!v.isNegative()) continue;
                pivot = v;
                continue;
            }
            if (!v.isSmallerThan(pivot)) continue;
            pivot = v;
        }
        if (pivot == null) {
            return null;
        }
        return this.mCache.mIndexedVariables[pivot.variableId];
    }

    @Override
    public void addError(SolverVariable error) {
        GoalVariable goalVariable = this.mCache.goalVariablePool.acquire();
        if (goalVariable == null) {
            goalVariable = new GoalVariable();
        } else {
            goalVariable.reset();
        }
        goalVariable.strengths[error.strength] = 1.0f;
        goalVariable.variableId = error.id;
        this.goals.add(goalVariable);
        this.keyedGoals.put(goalVariable.variableId, goalVariable);
        error.addToRow(this);
    }

    final GoalVariable create(GoalVariable key, SolverVariable error, float value) {
        GoalVariable goalVariable = new GoalVariable();
        for (int i = 0; i < 8; ++i) {
            float strength = key.strengths[i];
            if (strength == 0.0f) continue;
            float v = value * strength;
            if (Math.abs(v) < 1.0E-4f) {
                v = 0.0f;
            }
            goalVariable.strengths[i] = v;
        }
        goalVariable.variableId = error.id;
        return goalVariable;
    }

    @Override
    public void updateFromRow(ArrayRow definition, boolean removeFromDefinition) {
        GoalVariable goalVariable = this.keyedGoals.get(definition.variable.id);
        if (goalVariable == null) {
            return;
        }
        this.goals.remove(goalVariable);
        this.keyedGoals.remove(goalVariable.variableId);
        this.mCache.goalVariablePool.release(goalVariable);
        int current = definition.variables.getHead();
        int currentSize = definition.variables.getCurrentSize();
        int counter = 0;
        while (current != -1 && counter < currentSize) {
            GoalVariable added;
            current = definition.variables.getVariable(sRowVariable, current);
            RowVariable v = sRowVariable;
            GoalVariable existing = this.find(v.variableId);
            float value = v.value;
            SolverVariable solverVariable = this.mCache.mIndexedVariables[v.variableId];
            if (existing == null) {
                added = this.create(goalVariable, solverVariable, value);
                this.goals.add(added);
                this.keyedGoals.put(added.variableId, added);
                solverVariable.addToRow(this);
            } else {
                added = this.create(goalVariable, solverVariable, value);
                existing.add(added);
                if (existing.isNull()) {
                    this.goals.remove(existing);
                    this.keyedGoals.remove(existing.variableId);
                    this.mCache.goalVariablePool.release(existing);
                    solverVariable.removeFromRow(this);
                }
            }
            this.constantValue += definition.constantValue * value;
        }
    }

    final GoalVariable find(int id) {
        return this.keyedGoals.get(id);
    }

    @Override
    public String toString() {
        Collections.sort(this.goals);
        String result = "";
        result = result + " goal -> (" + this.constantValue + ") : ";
        for (GoalVariable v : this.goals) {
            result = result + v.toString(this.mCache) + " ";
        }
        return result;
    }

    static class RowVariable {
        float value;
        int variableId;

        RowVariable() {
        }
    }

    static class GoalVariable
    implements Comparable {
        float[] strengths = new float[8];
        int variableId;

        GoalVariable() {
        }

        public void reset() {
            Arrays.fill(this.strengths, 0.0f);
            this.variableId = -1;
        }

        public String toString() {
            return this.toString(sCache);
        }

        public String toString(Cache cache) {
            String result = "[ ";
            for (int i = 0; i < 8; ++i) {
                result = result + this.strengths[i] + " ";
            }
            result = result + "] " + cache.mIndexedVariables[this.variableId];
            return result;
        }

        public void add(GoalVariable added) {
            for (int i = 0; i < 8; ++i) {
                int n = i;
                this.strengths[n] = this.strengths[n] + added.strengths[i];
                float value = this.strengths[i];
                if (!(Math.abs(value) < 1.0E-4f)) continue;
                this.strengths[i] = 0.0f;
            }
        }

        public final boolean isNegative() {
            for (int i = 7; i >= 0; --i) {
                float value = this.strengths[i];
                if (value > 0.0f) {
                    return false;
                }
                if (!(this.strengths[i] < 0.0f)) continue;
                return true;
            }
            return false;
        }

        public final boolean isSmallerThan(GoalVariable variable) {
            for (int i = 7; i >= 0; --i) {
                float value = this.strengths[i];
                float comparedValue = variable.strengths[i];
                if (value == comparedValue) continue;
                return value < comparedValue;
            }
            return false;
        }

        public final boolean isNull() {
            for (int i = 0; i < 8; ++i) {
                if (this.strengths[i] == 0.0f) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object o) {
            GoalVariable v = (GoalVariable)o;
            return this.variableId - v.variableId;
        }
    }
}

