/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets.analyzer;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.Guideline;
import androidx.constraintlayout.solver.widgets.Helper;
import androidx.constraintlayout.solver.widgets.Optimizer;
import androidx.constraintlayout.solver.widgets.VirtualLayout;
import java.util.ArrayList;

public class BasicMeasure {
    private static final boolean DEBUG = false;
    private static final int MODE_SHIFT = 30;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int FIXED = -3;
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets = new ArrayList();
    private Measure mMeasure = new Measure();
    private ConstraintWidgetContainer constraintWidgetContainer;

    public void updateHierarchy(ConstraintWidgetContainer layout) {
        this.mVariableDimensionsWidgets.clear();
        int childCount = layout.mChildren.size();
        for (int i = 0; i < childCount; ++i) {
            ConstraintWidget widget = (ConstraintWidget)layout.mChildren.get(i);
            if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) continue;
            this.mVariableDimensionsWidgets.add(widget);
        }
        layout.invalidateGraph();
    }

    public BasicMeasure(ConstraintWidgetContainer constraintWidgetContainer) {
        this.constraintWidgetContainer = constraintWidgetContainer;
    }

    private void solveLinearSystem(String reason) {
        this.constraintWidgetContainer.layout();
    }

    private void measureChildren(ConstraintWidgetContainer layout) {
        int childCount = layout.mChildren.size();
        Measurer measurer = layout.getMeasurer();
        for (int i = 0; i < childCount; ++i) {
            boolean skip;
            ConstraintWidget child = (ConstraintWidget)layout.mChildren.get(i);
            if (child instanceof Guideline || child.horizontalRun.dimension.resolved && child.verticalRun.dimension.resolved) continue;
            ConstraintWidget.DimensionBehaviour widthBehavior = child.getDimensionBehaviour(0);
            ConstraintWidget.DimensionBehaviour heightBehavior = child.getDimensionBehaviour(1);
            boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultWidth != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultHeight != 1;
            if (skip) continue;
            this.measure(measurer, child, false);
        }
        measurer.didMeasures();
    }

    public void solverMeasure(ConstraintWidgetContainer layout, int optimizationLevel, int paddingX, int paddingY, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight) {
        boolean optimize;
        Measurer measurer = layout.getMeasurer();
        int childCount = layout.mChildren.size();
        int startingWidth = layout.getWidth();
        int startingHeight = layout.getHeight();
        boolean optimizeWrap = Optimizer.enabled(optimizationLevel, 128);
        boolean bl = optimize = optimizeWrap || Optimizer.enabled(optimizationLevel, 64);
        if (optimize) {
            for (int i = 0; i < childCount; ++i) {
                boolean ratio;
                ConstraintWidget child = (ConstraintWidget)layout.mChildren.get(i);
                boolean matchWidth = child.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean matchHeight = child.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean bl2 = ratio = matchWidth && matchHeight && child.getDimensionRatio() > 0.0f;
                if (child.isInHorizontalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (child.isInVerticalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (!(child instanceof VirtualLayout)) continue;
                optimize = false;
                break;
            }
        }
        if (optimize && LinearSystem.sMetrics != null) {
            ++LinearSystem.sMetrics.measures;
        }
        boolean allSolved = false;
        boolean bl3 = widthMode == 0x40000000 && heightMode == 0x40000000;
        int computations = 0;
        if (optimize &= bl3) {
            widthSize = Math.min(layout.getMaxWidth(), widthSize);
            heightSize = Math.min(layout.getMaxHeight(), heightSize);
            if (widthMode == 0x40000000 && layout.getWidth() != widthSize) {
                layout.setWidth(widthSize);
                layout.invalidateGraph();
            }
            if (heightMode == 0x40000000 && layout.getHeight() != heightSize) {
                layout.setHeight(heightSize);
                layout.invalidateGraph();
            }
            if (widthMode == 0x40000000 && heightMode == 0x40000000) {
                allSolved = layout.directMeasure(optimizeWrap);
                computations = 2;
            } else {
                allSolved = layout.directMeasureSetup(optimizeWrap);
                if (widthMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 0);
                    ++computations;
                }
                if (heightMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 1);
                    ++computations;
                }
            }
            if (allSolved) {
                layout.updateFromRuns(widthMode == 0x40000000, heightMode == 0x40000000);
            }
        } else {
            layout.horizontalRun.clear();
            layout.verticalRun.clear();
            for (ConstraintWidget child : layout.getChildren()) {
                child.horizontalRun.clear();
                child.verticalRun.clear();
            }
        }
        if (!allSolved || computations != 2) {
            if (childCount > 0) {
                this.measureChildren(layout);
            }
            int optimizations = layout.getOptimizationLevel();
            int sizeDependentWidgetsCount = this.mVariableDimensionsWidgets.size();
            if (childCount > 0) {
                this.solveLinearSystem("First pass");
            }
            if (sizeDependentWidgetsCount > 0) {
                boolean needSolverPass = false;
                boolean containerWrapWidth = layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                boolean containerWrapHeight = layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                int minWidth = Math.max(layout.getWidth(), this.constraintWidgetContainer.getMinWidth());
                int minHeight = Math.max(layout.getHeight(), this.constraintWidgetContainer.getMinHeight());
                for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                    ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                    if (!(widget instanceof VirtualLayout)) continue;
                    int preWidth = widget.getWidth();
                    int preHeight = widget.getHeight();
                    needSolverPass |= this.measure(measurer, widget, true);
                    int measuredWidth = widget.getWidth();
                    int measuredHeight = widget.getHeight();
                    if (measuredWidth != preWidth) {
                        widget.setWidth(measuredWidth);
                        if (containerWrapWidth && widget.getRight() > minWidth) {
                            int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                            minWidth = Math.max(minWidth, w);
                        }
                        needSolverPass = true;
                    }
                    if (measuredHeight != preHeight) {
                        widget.setHeight(measuredHeight);
                        if (containerWrapHeight && widget.getBottom() > minHeight) {
                            int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                            minHeight = Math.max(minHeight, h);
                        }
                        needSolverPass = true;
                    }
                    VirtualLayout virtualLayout = (VirtualLayout)widget;
                    needSolverPass |= virtualLayout.needSolverPass();
                }
                if (needSolverPass) {
                    layout.setWidth(startingWidth);
                    layout.setHeight(startingHeight);
                    this.solveLinearSystem("2nd pass");
                    needSolverPass = false;
                }
                int maxIterations = 2;
                for (int j = 0; j < maxIterations; ++j) {
                    for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                        ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                        if (widget instanceof Helper && !(widget instanceof VirtualLayout) || widget instanceof Guideline || widget.getVisibility() == 8 || widget.horizontalRun.dimension.resolved && widget.verticalRun.dimension.resolved || widget instanceof VirtualLayout) continue;
                        int preWidth = widget.getWidth();
                        int preHeight = widget.getHeight();
                        int preBaselineDistance = widget.getBaselineDistance();
                        needSolverPass |= this.measure(measurer, widget, true);
                        int measuredWidth = widget.getWidth();
                        int measuredHeight = widget.getHeight();
                        if (measuredWidth != preWidth) {
                            widget.setWidth(measuredWidth);
                            if (containerWrapWidth && widget.getRight() > minWidth) {
                                int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                                minWidth = Math.max(minWidth, w);
                            }
                            needSolverPass = true;
                        }
                        if (measuredHeight != preHeight) {
                            widget.setHeight(measuredHeight);
                            if (containerWrapHeight && widget.getBottom() > minHeight) {
                                int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                                minHeight = Math.max(minHeight, h);
                            }
                            needSolverPass = true;
                        }
                        if (!widget.hasBaseline() || preBaselineDistance == widget.getBaselineDistance()) continue;
                        needSolverPass = true;
                    }
                    if (!needSolverPass) continue;
                    layout.setWidth(startingWidth);
                    layout.setHeight(startingHeight);
                    this.solveLinearSystem("intermediate pass");
                    needSolverPass = false;
                }
                if (needSolverPass) {
                    layout.setWidth(startingWidth);
                    layout.setHeight(startingHeight);
                    this.solveLinearSystem("2nd pass");
                    needSolverPass = false;
                    if (layout.getWidth() < minWidth) {
                        layout.setWidth(minWidth);
                        needSolverPass = true;
                    }
                    if (layout.getHeight() < minHeight) {
                        layout.setHeight(minHeight);
                        needSolverPass = true;
                    }
                    if (needSolverPass) {
                        this.solveLinearSystem("3rd pass");
                    }
                }
            }
            layout.setOptimizationLevel(optimizations);
        }
    }

    private boolean measure(Measurer measurer, ConstraintWidget widget, boolean useDeprecated) {
        this.mMeasure.horizontalBehavior = widget.getHorizontalDimensionBehaviour();
        this.mMeasure.verticalBehavior = widget.getVerticalDimensionBehaviour();
        this.mMeasure.horizontalDimension = widget.getWidth();
        this.mMeasure.verticalDimension = widget.getHeight();
        this.mMeasure.measuredNeedsSolverPass = false;
        this.mMeasure.useDeprecated = useDeprecated;
        measurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.measuredWidth);
        widget.setHeight(this.mMeasure.measuredHeight);
        widget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        widget.setBaselineDistance(this.mMeasure.measuredBaseline);
        this.mMeasure.useDeprecated = false;
        return this.mMeasure.measuredNeedsSolverPass;
    }

    public static class Measure {
        public ConstraintWidget.DimensionBehaviour horizontalBehavior;
        public ConstraintWidget.DimensionBehaviour verticalBehavior;
        public int horizontalDimension;
        public int verticalDimension;
        public int measuredWidth;
        public int measuredHeight;
        public int measuredBaseline;
        public boolean measuredHasBaseline;
        public boolean measuredNeedsSolverPass;
        public boolean useDeprecated;
    }

    public static interface Measurer {
        public void measure(ConstraintWidget var1, Measure var2);

        public void didMeasures();
    }

    public static enum MeasureType {

    }
}

