/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets.analyzer;

import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.Helper;
import androidx.constraintlayout.solver.widgets.analyzer.BaselineDimensionDependency;
import androidx.constraintlayout.solver.widgets.analyzer.Dependency;
import androidx.constraintlayout.solver.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.solver.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.solver.widgets.analyzer.WidgetRun;

public class VerticalWidgetRun
extends WidgetRun {
    public DependencyNode baseline = new DependencyNode(this);
    DimensionDependency baselineDimension = null;

    public VerticalWidgetRun(ConstraintWidget widget) {
        super(widget);
        this.start.type = DependencyNode.Type.TOP;
        this.end.type = DependencyNode.Type.BOTTOM;
        this.baseline.type = DependencyNode.Type.BASELINE;
        this.orientation = 1;
    }

    public String toString() {
        return "VerticalRun " + this.widget.getDebugName();
    }

    @Override
    void clear() {
        this.runGroup = null;
        this.start.clear();
        this.end.clear();
        this.baseline.clear();
        this.dimension.clear();
        this.resolved = false;
    }

    @Override
    void reset() {
        this.resolved = false;
        this.start.resolved = false;
        this.end.resolved = false;
        this.baseline.resolved = false;
        this.dimension.resolved = false;
    }

    @Override
    boolean supportsWrapComputation() {
        if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return this.widget.mMatchConstraintDefaultHeight == 0;
        }
        return true;
    }

    @Override
    public void update(Dependency dependency) {
        int endPos;
        int startPos;
        switch (this.mRunType) {
            case START: {
                this.updateRunStart(dependency);
                break;
            }
            case END: {
                this.updateRunEnd(dependency);
                break;
            }
            case CENTER: {
                this.updateRunCenter(dependency, this.widget.mTop, this.widget.mBottom, 1);
                return;
            }
        }
        if (this.dimension.readyToSolve && !this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            switch (this.widget.mMatchConstraintDefaultHeight) {
                case 3: {
                    if (!this.widget.horizontalRun.dimension.resolved) break;
                    int size = 0;
                    int ratioSide = this.widget.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            size = (int)(0.5f + (float)this.widget.horizontalRun.dimension.value * this.widget.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            size = (int)(0.5f + (float)this.widget.horizontalRun.dimension.value / this.widget.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            size = (int)(0.5f + (float)this.widget.horizontalRun.dimension.value / this.widget.getDimensionRatio());
                        }
                    }
                    this.dimension.resolve(size);
                    break;
                }
                case 2: {
                    ConstraintWidget parent = this.widget.getParent();
                    if (parent == null || !parent.verticalRun.dimension.resolved) break;
                    float percent = this.widget.mMatchConstraintPercentHeight;
                    int targetDimensionValue = parent.verticalRun.dimension.value;
                    int size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.dimension.resolve(size);
                }
            }
        }
        if (!this.start.readyToSolve || !this.end.readyToSolve) {
            return;
        }
        if (this.start.resolved && this.end.resolved && this.dimension.resolved) {
            return;
        }
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.mMatchConstraintDefaultWidth == 0 && !this.widget.isInVerticalChain()) {
            DependencyNode startTarget = this.start.targets.get(0);
            DependencyNode endTarget = this.end.targets.get(0);
            startPos = startTarget.value + this.start.margin;
            endPos = endTarget.value + this.end.margin;
            int distance = endPos - startPos;
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            this.dimension.resolve(distance);
            return;
        }
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.matchConstraintsType == 1 && this.start.targets.size() > 0 && this.end.targets.size() > 0) {
            DependencyNode startTarget = this.start.targets.get(0);
            DependencyNode endTarget = this.end.targets.get(0);
            endPos = endTarget.value + this.end.margin;
            startPos = startTarget.value + this.start.margin;
            int availableSpace = endPos - startPos;
            if (availableSpace < this.dimension.wrapValue) {
                this.dimension.resolve(availableSpace);
            } else {
                this.dimension.resolve(this.dimension.wrapValue);
            }
        }
        if (!this.dimension.resolved) {
            return;
        }
        if (this.start.targets.size() > 0 && this.end.targets.size() > 0) {
            DependencyNode startTarget = this.start.targets.get(0);
            DependencyNode endTarget = this.end.targets.get(0);
            startPos = startTarget.value + this.start.margin;
            endPos = endTarget.value + this.end.margin;
            float bias = this.widget.getVerticalBiasPercent();
            if (startTarget == endTarget) {
                startPos = startTarget.value;
                endPos = endTarget.value;
                bias = 0.5f;
            }
            int distance = endPos - startPos - this.dimension.value;
            this.start.resolve((int)(0.5f + (float)startPos + (float)distance * bias));
            this.end.resolve(this.start.value + this.dimension.value);
        }
    }

    @Override
    void apply() {
        DependencyNode top;
        DependencyNode target;
        DependencyNode startTarget;
        ConstraintWidget parent;
        if (this.widget.measured) {
            this.dimension.resolve(this.widget.getHeight());
        }
        if (!this.dimension.resolved) {
            this.dimensionBehavior = this.widget.getVerticalDimensionBehaviour();
            if (this.widget.hasBaseline()) {
                this.baselineDimension = new BaselineDimensionDependency(this);
            }
            if (this.dimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.widget.getParent()) != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
                    int resolvedDimension = parent.getHeight() - this.widget.mTop.getMargin() - this.widget.mBottom.getMargin();
                    this.addTarget(this.start, parent.verticalRun.start, this.widget.mTop.getMargin());
                    this.addTarget(this.end, parent.verticalRun.end, -this.widget.mBottom.getMargin());
                    this.dimension.resolve(resolvedDimension);
                    return;
                }
                if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                    this.dimension.resolve(this.widget.getHeight());
                }
            }
        } else if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.widget.getParent()) != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
            this.addTarget(this.start, parent.verticalRun.start, this.widget.mTop.getMargin());
            this.addTarget(this.end, parent.verticalRun.end, -this.widget.mBottom.getMargin());
            return;
        }
        if (this.dimension.resolved && this.widget.measured) {
            if (this.widget.mListAnchors[2].mTarget != null && this.widget.mListAnchors[3].mTarget != null) {
                if (this.widget.isInVerticalChain()) {
                    this.start.margin = this.widget.mListAnchors[2].getMargin();
                    this.end.margin = -this.widget.mListAnchors[3].getMargin();
                } else {
                    DependencyNode endTarget;
                    startTarget = this.getTarget(this.widget.mListAnchors[2]);
                    if (startTarget != null) {
                        this.addTarget(this.start, startTarget, this.widget.mListAnchors[2].getMargin());
                    }
                    if ((endTarget = this.getTarget(this.widget.mListAnchors[3])) != null) {
                        this.addTarget(this.end, endTarget, -this.widget.mListAnchors[3].getMargin());
                    }
                    this.start.delegateToWidgetRun = true;
                    this.end.delegateToWidgetRun = true;
                }
                if (this.widget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, this.widget.getBaselineDistance());
                }
            } else if (this.widget.mListAnchors[2].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[2]);
                if (target != null) {
                    this.addTarget(this.start, target, this.widget.mListAnchors[2].getMargin());
                    this.addTarget(this.end, this.start, this.dimension.value);
                    if (this.widget.hasBaseline()) {
                        this.addTarget(this.baseline, this.start, this.widget.getBaselineDistance());
                    }
                }
            } else if (this.widget.mListAnchors[3].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[3]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.widget.mListAnchors[3].getMargin());
                    this.addTarget(this.start, this.end, -this.dimension.value);
                }
                if (this.widget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, this.widget.getBaselineDistance());
                }
            } else if (this.widget.mListAnchors[4].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[4]);
                if (target != null) {
                    this.addTarget(this.baseline, target, 0);
                    this.addTarget(this.start, this.baseline, -this.widget.getBaselineDistance());
                    this.addTarget(this.end, this.start, this.dimension.value);
                }
            } else if (!(this.widget instanceof Helper) && this.widget.getParent() != null && this.widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.CENTER).mTarget == null) {
                top = this.widget.getParent().verticalRun.start;
                this.addTarget(this.start, top, 0);
                this.addTarget(this.end, this.start, this.dimension.value);
                if (this.widget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, this.widget.getBaselineDistance());
                }
            }
        } else {
            if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                switch (this.widget.mMatchConstraintDefaultHeight) {
                    case 3: {
                        if (this.widget.isInVerticalChain() || this.widget.mMatchConstraintDefaultWidth == 3) break;
                        DimensionDependency targetDimension = this.widget.horizontalRun.dimension;
                        this.dimension.targets.add(targetDimension);
                        targetDimension.dependencies.add(this.dimension);
                        this.dimension.delegateToWidgetRun = true;
                        this.dimension.dependencies.add(this.start);
                        this.dimension.dependencies.add(this.end);
                        break;
                    }
                    case 2: {
                        parent = this.widget.getParent();
                        if (parent == null) break;
                        DimensionDependency targetDimension = parent.verticalRun.dimension;
                        this.dimension.targets.add(targetDimension);
                        targetDimension.dependencies.add(this.dimension);
                        this.dimension.delegateToWidgetRun = true;
                        this.dimension.dependencies.add(this.start);
                        this.dimension.dependencies.add(this.end);
                        break;
                    }
                }
            } else {
                this.dimension.addDependency(this);
            }
            if (this.widget.mListAnchors[2].mTarget != null && this.widget.mListAnchors[3].mTarget != null) {
                if (this.widget.isInVerticalChain()) {
                    this.start.margin = this.widget.mListAnchors[2].getMargin();
                    this.end.margin = -this.widget.mListAnchors[3].getMargin();
                } else {
                    startTarget = this.getTarget(this.widget.mListAnchors[2]);
                    DependencyNode endTarget = this.getTarget(this.widget.mListAnchors[3]);
                    startTarget.addDependency(this);
                    endTarget.addDependency(this);
                    this.mRunType = WidgetRun.RunType.CENTER;
                }
                if (this.widget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, 1, this.baselineDimension);
                }
            } else if (this.widget.mListAnchors[2].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[2]);
                if (target != null) {
                    this.addTarget(this.start, target, this.widget.mListAnchors[2].getMargin());
                    this.addTarget(this.end, this.start, 1, this.dimension);
                    if (this.widget.hasBaseline()) {
                        this.addTarget(this.baseline, this.start, 1, this.baselineDimension);
                    }
                    if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.getDimensionRatio() > 0.0f && this.widget.horizontalRun.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        this.widget.horizontalRun.dimension.dependencies.add(this.dimension);
                        this.dimension.targets.add(this.widget.horizontalRun.dimension);
                        this.dimension.updateDelegate = this;
                    }
                }
            } else if (this.widget.mListAnchors[3].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[3]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.widget.mListAnchors[3].getMargin());
                    this.addTarget(this.start, this.end, -1, this.dimension);
                    if (this.widget.hasBaseline()) {
                        this.addTarget(this.baseline, this.start, 1, this.baselineDimension);
                    }
                }
            } else if (this.widget.mListAnchors[4].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[4]);
                if (target != null) {
                    this.addTarget(this.baseline, target, 0);
                    this.addTarget(this.start, this.baseline, -1, this.baselineDimension);
                    this.addTarget(this.end, this.start, 1, this.dimension);
                }
            } else if (!(this.widget instanceof Helper) && this.widget.getParent() != null) {
                top = this.widget.getParent().verticalRun.start;
                this.addTarget(this.start, top, 0);
                this.addTarget(this.end, this.start, 1, this.dimension);
                if (this.widget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, 1, this.baselineDimension);
                }
                if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.getDimensionRatio() > 0.0f && this.widget.horizontalRun.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    this.widget.horizontalRun.dimension.dependencies.add(this.dimension);
                    this.dimension.targets.add(this.widget.horizontalRun.dimension);
                    this.dimension.updateDelegate = this;
                }
            }
            if (this.dimension.targets.size() == 0) {
                this.dimension.readyToSolve = true;
            }
        }
    }

    @Override
    public void applyToWidget() {
        this.widget.setDrawY(this.start.value);
    }
}

