/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.HelperWidget;
import java.util.ArrayList;

public class Flow
extends HelperWidget {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int mBarrierType = 0;

    public void setBarrierType(int barrierType) {
        this.mBarrierType = barrierType;
    }

    private void createChain(ConstraintWidget[] widgets, int start, int end) {
    }

    @Override
    public void addToSolver(LinearSystem system) {
        this.mListAnchors[0] = this.mLeft;
        this.mListAnchors[2] = this.mTop;
        this.mListAnchors[1] = this.mRight;
        this.mListAnchors[3] = this.mBottom;
        int parentWidth = this.mParent.getWidth();
        int totalWidth = 0;
        ConstraintAnchor start = this.mParent.mLeft;
        ConstraintAnchor top = this.mParent.mTop;
        ConstraintWidget previous = null;
        float allowedSpace = 0.8f;
        int maxWidth = (int)(allowedSpace * (float)parentWidth);
        int gap = 40;
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (totalWidth + widget.getWidth() > maxWidth) {
                start = this.mParent.mLeft;
                if (previous != null) {
                    previous.mRight.connect(this.mParent.mRight, 0);
                }
                top = previous.mBottom;
                totalWidth = 0;
                previous = null;
            }
            if (previous != null) {
                previous.mRight.connect(widget.mLeft, gap);
            } else {
                widget.setHorizontalChainStyle(2);
                widget.setHorizontalBiasPercent(0.0f);
            }
            widget.mTop.connect(top, 40);
            widget.mLeft.connect(start, 0);
            totalWidth += widget.getWidth();
            previous = widget;
            start = widget.mRight;
        }
        if (previous != null) {
            previous.mRight.connect(this.mParent.mRight, 0);
        }
    }

    class Linear {
        ArrayList<ConstraintWidget> mWidgets = new ArrayList();
        ConstraintWidget mOwner;

        Linear() {
        }

        public void apply() {
        }
    }
}

