/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import java.util.ArrayList;
import java.util.List;

public class Analyzer {
    private Analyzer() {
    }

    public static void determineDependencies(List<ConstraintWidget> widgets, List<List<ConstraintWidget>> widgetGroups) {
        for (ConstraintWidget widget : widgets) {
            if (widget.mConstrainedGroup != null) continue;
            Analyzer.determineDependencies(widget, widgetGroups);
        }
    }

    private static void determineDependencies(ConstraintWidget widget, List<List<ConstraintWidget>> widgetGroups) {
        ArrayList<ConstraintWidget> traverseList = new ArrayList<ConstraintWidget>();
        widgetGroups.add(traverseList);
        Analyzer.traverse(widget, traverseList, widgetGroups);
    }

    private static void traverse(ConstraintWidget widget, List<ConstraintWidget> upperList, List<List<ConstraintWidget>> widgetGroups) {
        if (widget == null) {
            return;
        }
        if (widget.mConstrainedGroup != null) {
            if (widget.mConstrainedGroup != upperList) {
                upperList.addAll(widget.mConstrainedGroup);
                widgetGroups.remove(widget.mConstrainedGroup);
                for (ConstraintWidget auxWidget : widget.mConstrainedGroup) {
                    auxWidget.mConstrainedGroup = upperList;
                }
            }
            return;
        }
        upperList.add(widget);
        widget.mConstrainedGroup = upperList;
        if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner != widget.getParent()) {
            Analyzer.traverse(widget.mLeft.mTarget.mOwner, upperList, widgetGroups);
        }
        if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner != widget.getParent()) {
            Analyzer.traverse(widget.mRight.mTarget.mOwner, upperList, widgetGroups);
        }
        if (widget.mBaseline.mTarget != null && widget.mBaseline.mTarget.mOwner != widget.getParent()) {
            Analyzer.traverse(widget.mBaseline.mTarget.mOwner, upperList, widgetGroups);
        }
        if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner != widget.getParent()) {
            Analyzer.traverse(widget.mBottom.mTarget.mOwner, upperList, widgetGroups);
        }
        if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner != widget.getParent()) {
            Analyzer.traverse(widget.mTop.mTarget.mOwner, upperList, widgetGroups);
        }
    }
}

