/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;

public class ChainRun
extends WidgetRun {
    ArrayList<WidgetRun> mWidgets = new ArrayList();
    private int mChainStyle;

    public ChainRun(ConstraintWidget widget, int orientation) {
        super(widget);
        this.orientation = orientation;
        this.build();
    }

    public String toString() {
        StringBuilder log = new StringBuilder("ChainRun ");
        log.append(this.orientation == 0 ? "horizontal : " : "vertical : ");
        for (WidgetRun run : this.mWidgets) {
            log.append("<");
            log.append(run);
            log.append("> ");
        }
        return log.toString();
    }

    @Override
    boolean supportsWrapComputation() {
        int count = this.mWidgets.size();
        for (int i = 0; i < count; ++i) {
            WidgetRun run = this.mWidgets.get(i);
            if (run.supportsWrapComputation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getWrapDimension() {
        int count = this.mWidgets.size();
        long wrapDimension = 0L;
        for (int i = 0; i < count; ++i) {
            WidgetRun run = this.mWidgets.get(i);
            wrapDimension += (long)run.start.mMargin;
            wrapDimension += run.getWrapDimension();
            wrapDimension += (long)run.end.mMargin;
        }
        return wrapDimension;
    }

    private void build() {
        boolean isInRtl;
        ConstraintWidget current = this.mWidget;
        ConstraintWidget previous = current.getPreviousChainMember(this.orientation);
        while (previous != null) {
            current = previous;
            previous = current.getPreviousChainMember(this.orientation);
        }
        this.mWidget = current;
        this.mWidgets.add(current.getRun(this.orientation));
        ConstraintWidget next = current.getNextChainMember(this.orientation);
        while (next != null) {
            current = next;
            this.mWidgets.add(current.getRun(this.orientation));
            next = current.getNextChainMember(this.orientation);
        }
        for (WidgetRun run : this.mWidgets) {
            if (this.orientation == 0) {
                run.mWidget.horizontalChainRun = this;
                continue;
            }
            if (this.orientation != 1) continue;
            run.mWidget.verticalChainRun = this;
        }
        boolean bl = isInRtl = this.orientation == 0 && ((ConstraintWidgetContainer)this.mWidget.getParent()).isRtl();
        if (isInRtl && this.mWidgets.size() > 1) {
            this.mWidget = this.mWidgets.get((int)(this.mWidgets.size() - 1)).mWidget;
        }
        this.mChainStyle = this.orientation == 0 ? this.mWidget.getHorizontalChainStyle() : this.mWidget.getVerticalChainStyle();
    }

    @Override
    void clear() {
        this.mRunGroup = null;
        for (WidgetRun run : this.mWidgets) {
            run.clear();
        }
    }

    @Override
    void reset() {
        this.start.resolved = false;
        this.end.resolved = false;
    }

    @Override
    public void update(Dependency dependency) {
        block72: {
            int gap;
            float bias;
            int position;
            int lastVisibleWidget;
            int firstVisibleWidget;
            int count;
            int numMatchConstraints;
            int size;
            int distance;
            boolean isInRtl;
            block73: {
                int dimension;
                int i;
                int numVisibleWidgets;
                block71: {
                    if (!this.start.resolved || !this.end.resolved) {
                        return;
                    }
                    ConstraintWidget parent = this.mWidget.getParent();
                    isInRtl = false;
                    if (parent instanceof ConstraintWidgetContainer) {
                        isInRtl = ((ConstraintWidgetContainer)parent).isRtl();
                    }
                    distance = this.end.value - this.start.value;
                    size = 0;
                    numMatchConstraints = 0;
                    float weights = 0.0f;
                    numVisibleWidgets = 0;
                    count = this.mWidgets.size();
                    firstVisibleWidget = -1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        WidgetRun run = this.mWidgets.get(i2);
                        if (run.mWidget.getVisibility() == 8) continue;
                        firstVisibleWidget = i2;
                        break;
                    }
                    lastVisibleWidget = -1;
                    for (int i3 = count - 1; i3 >= 0; --i3) {
                        WidgetRun run = this.mWidgets.get(i3);
                        if (run.mWidget.getVisibility() == 8) continue;
                        lastVisibleWidget = i3;
                        break;
                    }
                    for (int j = 0; j < 2; ++j) {
                        for (int i4 = 0; i4 < count; ++i4) {
                            boolean treatAsFixed;
                            WidgetRun run = this.mWidgets.get(i4);
                            if (run.mWidget.getVisibility() == 8) continue;
                            ++numVisibleWidgets;
                            if (i4 > 0 && i4 >= firstVisibleWidget) {
                                size += run.start.mMargin;
                            }
                            int dimension2 = run.mDimension.value;
                            boolean bl = treatAsFixed = run.mDimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                            if (treatAsFixed) {
                                if (this.orientation == 0 && !run.mWidget.mHorizontalRun.mDimension.resolved) {
                                    return;
                                }
                                if (this.orientation == 1 && !run.mWidget.mVerticalRun.mDimension.resolved) {
                                    return;
                                }
                            } else if (run.matchConstraintsType == 1 && j == 0) {
                                treatAsFixed = true;
                                dimension2 = run.mDimension.wrapValue;
                                ++numMatchConstraints;
                            } else if (run.mDimension.resolved) {
                                treatAsFixed = true;
                            }
                            if (!treatAsFixed) {
                                ++numMatchConstraints;
                                float weight = run.mWidget.mWeight[this.orientation];
                                if (weight >= 0.0f) {
                                    weights += weight;
                                }
                            } else {
                                size += dimension2;
                            }
                            if (i4 >= count - 1 || i4 >= lastVisibleWidget) continue;
                            size += -run.end.mMargin;
                        }
                        if (size < distance || numMatchConstraints == 0) break;
                        numVisibleWidgets = 0;
                        numMatchConstraints = 0;
                        size = 0;
                        weights = 0.0f;
                    }
                    position = this.start.value;
                    if (isInRtl) {
                        position = this.end.value;
                    }
                    if (size > distance) {
                        position = isInRtl ? (position += (int)(0.5f + (float)(size - distance) / 2.0f)) : (position -= (int)(0.5f + (float)(size - distance) / 2.0f));
                    }
                    int matchConstraintsDimension = 0;
                    if (numMatchConstraints > 0) {
                        matchConstraintsDimension = (int)(0.5f + (float)(distance - size) / (float)numMatchConstraints);
                        int appliedLimits = 0;
                        for (i = 0; i < count; ++i) {
                            int min;
                            int max;
                            WidgetRun run = this.mWidgets.get(i);
                            if (run.mWidget.getVisibility() == 8 || run.mDimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || run.mDimension.resolved) continue;
                            int dimension3 = matchConstraintsDimension;
                            if (weights > 0.0f) {
                                float weight = run.mWidget.mWeight[this.orientation];
                                dimension3 = (int)(0.5f + weight * (float)(distance - size) / weights);
                            }
                            int value = dimension3;
                            if (this.orientation == 0) {
                                max = run.mWidget.mMatchConstraintMaxWidth;
                                min = run.mWidget.mMatchConstraintMinWidth;
                            } else {
                                max = run.mWidget.mMatchConstraintMaxHeight;
                                min = run.mWidget.mMatchConstraintMinHeight;
                            }
                            if (run.matchConstraintsType == 1) {
                                value = Math.min(value, run.mDimension.wrapValue);
                            }
                            value = Math.max(min, value);
                            if (max > 0) {
                                value = Math.min(max, value);
                            }
                            if (value != dimension3) {
                                ++appliedLimits;
                                dimension3 = value;
                            }
                            run.mDimension.resolve(dimension3);
                        }
                        if (appliedLimits > 0) {
                            numMatchConstraints -= appliedLimits;
                            size = 0;
                            for (i = 0; i < count; ++i) {
                                WidgetRun run = this.mWidgets.get(i);
                                if (run.mWidget.getVisibility() == 8) continue;
                                if (i > 0 && i >= firstVisibleWidget) {
                                    size += run.start.mMargin;
                                }
                                size += run.mDimension.value;
                                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                                size += -run.end.mMargin;
                            }
                        }
                        if (this.mChainStyle == 2 && appliedLimits == 0) {
                            this.mChainStyle = 0;
                        }
                    }
                    if (size > distance) {
                        this.mChainStyle = 2;
                    }
                    if (numVisibleWidgets > 0 && numMatchConstraints == 0 && firstVisibleWidget == lastVisibleWidget) {
                        this.mChainStyle = 2;
                    }
                    if (this.mChainStyle != 1) break block71;
                    int gap2 = 0;
                    if (numVisibleWidgets > 1) {
                        gap2 = (distance - size) / (numVisibleWidgets - 1);
                    } else if (numVisibleWidgets == 1) {
                        gap2 = (distance - size) / 2;
                    }
                    if (numMatchConstraints > 0) {
                        gap2 = 0;
                    }
                    for (i = 0; i < count; ++i) {
                        int index = i;
                        if (isInRtl) {
                            index = count - (i + 1);
                        }
                        WidgetRun run = this.mWidgets.get(index);
                        if (run.mWidget.getVisibility() == 8) {
                            run.start.resolve(position);
                            run.end.resolve(position);
                            continue;
                        }
                        if (i > 0) {
                            position = isInRtl ? (position -= gap2) : (position += gap2);
                        }
                        if (i > 0 && i >= firstVisibleWidget) {
                            position = isInRtl ? (position -= run.start.mMargin) : (position += run.start.mMargin);
                        }
                        if (isInRtl) {
                            run.end.resolve(position);
                        } else {
                            run.start.resolve(position);
                        }
                        dimension = run.mDimension.value;
                        if (run.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                            dimension = run.mDimension.wrapValue;
                        }
                        position = isInRtl ? (position -= dimension) : (position += dimension);
                        if (isInRtl) {
                            run.start.resolve(position);
                        } else {
                            run.end.resolve(position);
                        }
                        run.mResolved = true;
                        if (i >= count - 1 || i >= lastVisibleWidget) continue;
                        if (isInRtl) {
                            position -= -run.end.mMargin;
                            continue;
                        }
                        position += -run.end.mMargin;
                    }
                    break block72;
                }
                if (this.mChainStyle != 0) break block73;
                int gap3 = (distance - size) / (numVisibleWidgets + 1);
                if (numMatchConstraints > 0) {
                    gap3 = 0;
                }
                for (i = 0; i < count; ++i) {
                    int index = i;
                    if (isInRtl) {
                        index = count - (i + 1);
                    }
                    WidgetRun run = this.mWidgets.get(index);
                    if (run.mWidget.getVisibility() == 8) {
                        run.start.resolve(position);
                        run.end.resolve(position);
                        continue;
                    }
                    position = isInRtl ? (position -= gap3) : (position += gap3);
                    if (i > 0 && i >= firstVisibleWidget) {
                        position = isInRtl ? (position -= run.start.mMargin) : (position += run.start.mMargin);
                    }
                    if (isInRtl) {
                        run.end.resolve(position);
                    } else {
                        run.start.resolve(position);
                    }
                    dimension = run.mDimension.value;
                    if (run.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                        dimension = Math.min(dimension, run.mDimension.wrapValue);
                    }
                    position = isInRtl ? (position -= dimension) : (position += dimension);
                    if (isInRtl) {
                        run.start.resolve(position);
                    } else {
                        run.end.resolve(position);
                    }
                    if (i >= count - 1 || i >= lastVisibleWidget) continue;
                    if (isInRtl) {
                        position -= -run.end.mMargin;
                        continue;
                    }
                    position += -run.end.mMargin;
                }
                break block72;
            }
            if (this.mChainStyle != 2) break block72;
            float f = bias = this.orientation == 0 ? this.mWidget.getHorizontalBiasPercent() : this.mWidget.getVerticalBiasPercent();
            if (isInRtl) {
                bias = 1.0f - bias;
            }
            if ((gap = (int)(0.5f + (float)(distance - size) * bias)) < 0 || numMatchConstraints > 0) {
                gap = 0;
            }
            position = isInRtl ? (position -= gap) : (position += gap);
            for (int i = 0; i < count; ++i) {
                int index = i;
                if (isInRtl) {
                    index = count - (i + 1);
                }
                WidgetRun run = this.mWidgets.get(index);
                if (run.mWidget.getVisibility() == 8) {
                    run.start.resolve(position);
                    run.end.resolve(position);
                    continue;
                }
                if (i > 0 && i >= firstVisibleWidget) {
                    position = isInRtl ? (position -= run.start.mMargin) : (position += run.start.mMargin);
                }
                if (isInRtl) {
                    run.end.resolve(position);
                } else {
                    run.start.resolve(position);
                }
                int dimension = run.mDimension.value;
                if (run.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                    dimension = run.mDimension.wrapValue;
                }
                position = isInRtl ? (position -= dimension) : (position += dimension);
                if (isInRtl) {
                    run.start.resolve(position);
                } else {
                    run.end.resolve(position);
                }
                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                if (isInRtl) {
                    position -= -run.end.mMargin;
                    continue;
                }
                position += -run.end.mMargin;
            }
        }
    }

    @Override
    public void applyToWidget() {
        for (int i = 0; i < this.mWidgets.size(); ++i) {
            WidgetRun run = this.mWidgets.get(i);
            run.applyToWidget();
        }
    }

    private ConstraintWidget getFirstVisibleWidget() {
        for (int i = 0; i < this.mWidgets.size(); ++i) {
            WidgetRun run = this.mWidgets.get(i);
            if (run.mWidget.getVisibility() == 8) continue;
            return run.mWidget;
        }
        return null;
    }

    private ConstraintWidget getLastVisibleWidget() {
        for (int i = this.mWidgets.size() - 1; i >= 0; --i) {
            WidgetRun run = this.mWidgets.get(i);
            if (run.mWidget.getVisibility() == 8) continue;
            return run.mWidget;
        }
        return null;
    }

    @Override
    void apply() {
        for (WidgetRun run : this.mWidgets) {
            run.apply();
        }
        int count = this.mWidgets.size();
        if (count < 1) {
            return;
        }
        ConstraintWidget firstWidget = this.mWidgets.get((int)0).mWidget;
        ConstraintWidget lastWidget = this.mWidgets.get((int)(count - 1)).mWidget;
        if (this.orientation == 0) {
            ConstraintAnchor startAnchor = firstWidget.mLeft;
            ConstraintAnchor endAnchor = lastWidget.mRight;
            DependencyNode startTarget = this.getTarget(startAnchor, 0);
            int startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.mLeft.getMargin();
            }
            if (startTarget != null) {
                this.addTarget(this.start, startTarget, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 0);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.mRight.getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.end, endTarget, -endMargin);
            }
        } else {
            ConstraintAnchor startAnchor = firstWidget.mTop;
            ConstraintAnchor endAnchor = lastWidget.mBottom;
            DependencyNode startTarget = this.getTarget(startAnchor, 1);
            int startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.mTop.getMargin();
            }
            if (startTarget != null) {
                this.addTarget(this.start, startTarget, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 1);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.mBottom.getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.end, endTarget, -endMargin);
            }
        }
        this.start.updateDelegate = this;
        this.end.updateDelegate = this;
    }
}

