/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.VirtualLayout;

public class Placeholder
extends VirtualLayout {
    @Override
    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
        int width = 0;
        int height = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        width += paddingLeft + paddingRight;
        height += paddingTop + paddingBottom;
        if (this.mWidgetsCount > 0) {
            width += this.mWidgets[0].getWidth();
            height += this.mWidgets[0].getHeight();
        }
        width = Math.max(this.getMinWidth(), width);
        height = Math.max(this.getMinHeight(), height);
        int measuredWidth = 0;
        int measuredHeight = 0;
        if (widthMode == 0x40000000) {
            measuredWidth = widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            measuredWidth = Math.min(width, widthSize);
        } else if (widthMode == 0) {
            measuredWidth = width;
        }
        if (heightMode == 0x40000000) {
            measuredHeight = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            measuredHeight = Math.min(height, heightSize);
        } else if (heightMode == 0) {
            measuredHeight = height;
        }
        this.setMeasure(measuredWidth, measuredHeight);
        this.setWidth(measuredWidth);
        this.setHeight(measuredHeight);
        this.needsCallbackFromSolver(this.mWidgetsCount > 0);
    }

    @Override
    public void addToSolver(LinearSystem system, boolean optimize) {
        super.addToSolver(system, optimize);
        if (this.mWidgetsCount > 0) {
            ConstraintWidget widget = this.mWidgets[0];
            widget.resetAllConstraints();
            widget.connect(ConstraintAnchor.Type.LEFT, this, ConstraintAnchor.Type.LEFT);
            widget.connect(ConstraintAnchor.Type.RIGHT, this, ConstraintAnchor.Type.RIGHT);
            widget.connect(ConstraintAnchor.Type.TOP, this, ConstraintAnchor.Type.TOP);
            widget.connect(ConstraintAnchor.Type.BOTTOM, this, ConstraintAnchor.Type.BOTTOM);
        }
    }
}

