/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;

public class HorizontalWidgetRun
extends WidgetRun {
    private static int[] sTempDimensions = new int[2];

    public HorizontalWidgetRun(ConstraintWidget widget) {
        super(widget);
        this.start.mType = DependencyNode.Type.LEFT;
        this.end.mType = DependencyNode.Type.RIGHT;
        this.orientation = 0;
    }

    public String toString() {
        return "HorizontalRun " + this.mWidget.getDebugName();
    }

    @Override
    void clear() {
        this.mRunGroup = null;
        this.start.clear();
        this.end.clear();
        this.mDimension.clear();
        this.mResolved = false;
    }

    @Override
    void reset() {
        this.mResolved = false;
        this.start.clear();
        this.start.resolved = false;
        this.end.clear();
        this.end.resolved = false;
        this.mDimension.resolved = false;
    }

    @Override
    boolean supportsWrapComputation() {
        if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return this.mWidget.mMatchConstraintDefaultWidth == 0;
        }
        return true;
    }

    @Override
    void apply() {
        DependencyNode left;
        DependencyNode target;
        DependencyNode startTarget;
        ConstraintWidget parent;
        if (this.mWidget.measured) {
            this.mDimension.resolve(this.mWidget.getWidth());
        }
        if (!this.mDimension.resolved) {
            this.mDimensionBehavior = this.mWidget.getHorizontalDimensionBehaviour();
            if (this.mDimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.mWidget.getParent()) != null && (parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
                    int resolvedDimension = parent.getWidth() - this.mWidget.mLeft.getMargin() - this.mWidget.mRight.getMargin();
                    this.addTarget(this.start, parent.mHorizontalRun.start, this.mWidget.mLeft.getMargin());
                    this.addTarget(this.end, parent.mHorizontalRun.end, -this.mWidget.mRight.getMargin());
                    this.mDimension.resolve(resolvedDimension);
                    return;
                }
                if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                    this.mDimension.resolve(this.mWidget.getWidth());
                }
            }
        } else if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.mWidget.getParent()) != null && (parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
            this.addTarget(this.start, parent.mHorizontalRun.start, this.mWidget.mLeft.getMargin());
            this.addTarget(this.end, parent.mHorizontalRun.end, -this.mWidget.mRight.getMargin());
            return;
        }
        if (this.mDimension.resolved && this.mWidget.measured) {
            if (this.mWidget.mListAnchors[0].mTarget != null && this.mWidget.mListAnchors[1].mTarget != null) {
                if (this.mWidget.isInHorizontalChain()) {
                    this.start.mMargin = this.mWidget.mListAnchors[0].getMargin();
                    this.end.mMargin = -this.mWidget.mListAnchors[1].getMargin();
                } else {
                    DependencyNode endTarget;
                    startTarget = this.getTarget(this.mWidget.mListAnchors[0]);
                    if (startTarget != null) {
                        this.addTarget(this.start, startTarget, this.mWidget.mListAnchors[0].getMargin());
                    }
                    if ((endTarget = this.getTarget(this.mWidget.mListAnchors[1])) != null) {
                        this.addTarget(this.end, endTarget, -this.mWidget.mListAnchors[1].getMargin());
                    }
                    this.start.delegateToWidgetRun = true;
                    this.end.delegateToWidgetRun = true;
                }
            } else if (this.mWidget.mListAnchors[0].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[0]);
                if (target != null) {
                    this.addTarget(this.start, target, this.mWidget.mListAnchors[0].getMargin());
                    this.addTarget(this.end, this.start, this.mDimension.value);
                }
            } else if (this.mWidget.mListAnchors[1].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[1]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.mWidget.mListAnchors[1].getMargin());
                    this.addTarget(this.start, this.end, -this.mDimension.value);
                }
            } else if (!(this.mWidget instanceof Helper) && this.mWidget.getParent() != null && this.mWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.CENTER).mTarget == null) {
                left = this.mWidget.getParent().mHorizontalRun.start;
                this.addTarget(this.start, left, this.mWidget.getX());
                this.addTarget(this.end, this.start, this.mDimension.value);
            }
        } else {
            if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                switch (this.mWidget.mMatchConstraintDefaultWidth) {
                    case 3: {
                        if (this.mWidget.mMatchConstraintDefaultHeight == 3) {
                            this.start.updateDelegate = this;
                            this.end.updateDelegate = this;
                            this.mWidget.mVerticalRun.start.updateDelegate = this;
                            this.mWidget.mVerticalRun.end.updateDelegate = this;
                            this.mDimension.updateDelegate = this;
                            if (this.mWidget.isInVerticalChain()) {
                                this.mDimension.mTargets.add(this.mWidget.mVerticalRun.mDimension);
                                this.mWidget.mVerticalRun.mDimension.mDependencies.add(this.mDimension);
                                this.mWidget.mVerticalRun.mDimension.updateDelegate = this;
                                this.mDimension.mTargets.add(this.mWidget.mVerticalRun.start);
                                this.mDimension.mTargets.add(this.mWidget.mVerticalRun.end);
                                this.mWidget.mVerticalRun.start.mDependencies.add(this.mDimension);
                                this.mWidget.mVerticalRun.end.mDependencies.add(this.mDimension);
                                break;
                            }
                            if (this.mWidget.isInHorizontalChain()) {
                                this.mWidget.mVerticalRun.mDimension.mTargets.add(this.mDimension);
                                this.mDimension.mDependencies.add(this.mWidget.mVerticalRun.mDimension);
                                break;
                            }
                            this.mWidget.mVerticalRun.mDimension.mTargets.add(this.mDimension);
                            break;
                        }
                        DimensionDependency targetDimension = this.mWidget.mVerticalRun.mDimension;
                        this.mDimension.mTargets.add(targetDimension);
                        targetDimension.mDependencies.add(this.mDimension);
                        this.mWidget.mVerticalRun.start.mDependencies.add(this.mDimension);
                        this.mWidget.mVerticalRun.end.mDependencies.add(this.mDimension);
                        this.mDimension.delegateToWidgetRun = true;
                        this.mDimension.mDependencies.add(this.start);
                        this.mDimension.mDependencies.add(this.end);
                        this.start.mTargets.add(this.mDimension);
                        this.end.mTargets.add(this.mDimension);
                        break;
                    }
                    case 2: {
                        parent = this.mWidget.getParent();
                        if (parent == null) break;
                        DimensionDependency targetDimension = parent.mVerticalRun.mDimension;
                        this.mDimension.mTargets.add(targetDimension);
                        targetDimension.mDependencies.add(this.mDimension);
                        this.mDimension.delegateToWidgetRun = true;
                        this.mDimension.mDependencies.add(this.start);
                        this.mDimension.mDependencies.add(this.end);
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
            if (this.mWidget.mListAnchors[0].mTarget != null && this.mWidget.mListAnchors[1].mTarget != null) {
                if (this.mWidget.isInHorizontalChain()) {
                    this.start.mMargin = this.mWidget.mListAnchors[0].getMargin();
                    this.end.mMargin = -this.mWidget.mListAnchors[1].getMargin();
                } else {
                    startTarget = this.getTarget(this.mWidget.mListAnchors[0]);
                    DependencyNode endTarget = this.getTarget(this.mWidget.mListAnchors[1]);
                    if (startTarget != null) {
                        startTarget.addDependency(this);
                    }
                    if (endTarget != null) {
                        endTarget.addDependency(this);
                    }
                    this.mRunType = WidgetRun.RunType.CENTER;
                }
            } else if (this.mWidget.mListAnchors[0].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[0]);
                if (target != null) {
                    this.addTarget(this.start, target, this.mWidget.mListAnchors[0].getMargin());
                    this.addTarget(this.end, this.start, 1, this.mDimension);
                }
            } else if (this.mWidget.mListAnchors[1].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[1]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.mWidget.mListAnchors[1].getMargin());
                    this.addTarget(this.start, this.end, -1, this.mDimension);
                }
            } else if (!(this.mWidget instanceof Helper) && this.mWidget.getParent() != null) {
                left = this.mWidget.getParent().mHorizontalRun.start;
                this.addTarget(this.start, left, this.mWidget.getX());
                this.addTarget(this.end, this.start, 1, this.mDimension);
            }
        }
    }

    private void computeInsetRatio(int[] dimensions, int x1, int x2, int y1, int y2, float ratio, int side) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        switch (side) {
            case -1: {
                int candidateX1 = (int)(0.5f + (float)dy * ratio);
                int candidateY1 = dy;
                int candidateX2 = dx;
                int candidateY2 = (int)(0.5f + (float)dx / ratio);
                if (candidateX1 <= dx && candidateY1 <= dy) {
                    dimensions[0] = candidateX1;
                    dimensions[1] = candidateY1;
                    break;
                }
                if (candidateX2 > dx || candidateY2 > dy) break;
                dimensions[0] = candidateX2;
                dimensions[1] = candidateY2;
                break;
            }
            case 0: {
                int horizontalSide;
                dimensions[0] = horizontalSide = (int)(0.5f + (float)dy * ratio);
                dimensions[1] = dy;
                break;
            }
            case 1: {
                int verticalSide = (int)(0.5f + (float)dx * ratio);
                dimensions[0] = dx;
                dimensions[1] = verticalSide;
                break;
            }
        }
    }

    @Override
    public void update(Dependency dependency) {
        int endPos;
        int startPos;
        DependencyNode endTarget;
        DependencyNode startTarget;
        switch (this.mRunType) {
            case START: {
                this.updateRunStart(dependency);
                break;
            }
            case END: {
                this.updateRunEnd(dependency);
                break;
            }
            case CENTER: {
                this.updateRunCenter(dependency, this.mWidget.mLeft, this.mWidget.mRight, 0);
                return;
            }
        }
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            block5 : switch (this.mWidget.mMatchConstraintDefaultWidth) {
                case 3: {
                    if (this.mWidget.mMatchConstraintDefaultHeight == 0 || this.mWidget.mMatchConstraintDefaultHeight == 3) {
                        float ratio;
                        DependencyNode secondStart = this.mWidget.mVerticalRun.start;
                        DependencyNode secondEnd = this.mWidget.mVerticalRun.end;
                        boolean s1 = this.mWidget.mLeft.mTarget != null;
                        boolean s2 = this.mWidget.mTop.mTarget != null;
                        boolean e1 = this.mWidget.mRight.mTarget != null;
                        boolean e2 = this.mWidget.mBottom.mTarget != null;
                        int definedSide = this.mWidget.getDimensionRatioSide();
                        if (s1 && s2 && e1 && e2) {
                            int y2;
                            int y1;
                            int x2;
                            int x1;
                            ratio = this.mWidget.getDimensionRatio();
                            if (secondStart.resolved && secondEnd.resolved) {
                                if (!this.start.readyToSolve || !this.end.readyToSolve) {
                                    return;
                                }
                                int x12 = this.start.mTargets.get((int)0).value + this.start.mMargin;
                                int x22 = this.end.mTargets.get((int)0).value - this.end.mMargin;
                                int y12 = secondStart.value + secondStart.mMargin;
                                int y22 = secondEnd.value - secondEnd.mMargin;
                                this.computeInsetRatio(sTempDimensions, x12, x22, y12, y22, ratio, definedSide);
                                this.mDimension.resolve(sTempDimensions[0]);
                                this.mWidget.mVerticalRun.mDimension.resolve(sTempDimensions[1]);
                                return;
                            }
                            if (this.start.resolved && this.end.resolved) {
                                if (!secondStart.readyToSolve || !secondEnd.readyToSolve) {
                                    return;
                                }
                                x1 = this.start.value + this.start.mMargin;
                                x2 = this.end.value - this.end.mMargin;
                                y1 = secondStart.mTargets.get((int)0).value + secondStart.mMargin;
                                y2 = secondEnd.mTargets.get((int)0).value - secondEnd.mMargin;
                                this.computeInsetRatio(sTempDimensions, x1, x2, y1, y2, ratio, definedSide);
                                this.mDimension.resolve(sTempDimensions[0]);
                                this.mWidget.mVerticalRun.mDimension.resolve(sTempDimensions[1]);
                            }
                            if (!(this.start.readyToSolve && this.end.readyToSolve && secondStart.readyToSolve && secondEnd.readyToSolve)) {
                                return;
                            }
                            x1 = this.start.mTargets.get((int)0).value + this.start.mMargin;
                            x2 = this.end.mTargets.get((int)0).value - this.end.mMargin;
                            y1 = secondStart.mTargets.get((int)0).value + secondStart.mMargin;
                            y2 = secondEnd.mTargets.get((int)0).value - secondEnd.mMargin;
                            this.computeInsetRatio(sTempDimensions, x1, x2, y1, y2, ratio, definedSide);
                            this.mDimension.resolve(sTempDimensions[0]);
                            this.mWidget.mVerticalRun.mDimension.resolve(sTempDimensions[1]);
                            break;
                        }
                        if (s1 && e1) {
                            if (!this.start.readyToSolve || !this.end.readyToSolve) {
                                return;
                            }
                            ratio = this.mWidget.getDimensionRatio();
                            int x1 = this.start.mTargets.get((int)0).value + this.start.mMargin;
                            int x2 = this.end.mTargets.get((int)0).value - this.end.mMargin;
                            switch (definedSide) {
                                case -1: 
                                case 0: {
                                    int dx = x2 - x1;
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    int dy = (int)(0.5f + (float)ldx * ratio);
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    if (dy != ldy) {
                                        ldx = (int)(0.5f + (float)ldy / ratio);
                                    }
                                    this.mDimension.resolve(ldx);
                                    this.mWidget.mVerticalRun.mDimension.resolve(ldy);
                                    break block5;
                                }
                                case 1: {
                                    int dx = x2 - x1;
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    int dy = (int)(0.5f + (float)ldx / ratio);
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    if (dy != ldy) {
                                        ldx = (int)(0.5f + (float)ldy * ratio);
                                    }
                                    this.mDimension.resolve(ldx);
                                    this.mWidget.mVerticalRun.mDimension.resolve(ldy);
                                    break block5;
                                }
                            }
                            break;
                        }
                        if (!s2 || !e2) break;
                        if (!secondStart.readyToSolve || !secondEnd.readyToSolve) {
                            return;
                        }
                        ratio = this.mWidget.getDimensionRatio();
                        int y1 = secondStart.mTargets.get((int)0).value + secondStart.mMargin;
                        int y2 = secondEnd.mTargets.get((int)0).value - secondEnd.mMargin;
                        switch (definedSide) {
                            case -1: 
                            case 1: {
                                int dy = y2 - y1;
                                int ldy = this.getLimitedDimension(dy, 1);
                                int dx = (int)(0.5f + (float)ldy / ratio);
                                int ldx = this.getLimitedDimension(dx, 0);
                                if (dx != ldx) {
                                    ldy = (int)(0.5f + (float)ldx * ratio);
                                }
                                this.mDimension.resolve(ldx);
                                this.mWidget.mVerticalRun.mDimension.resolve(ldy);
                                break block5;
                            }
                            case 0: {
                                int dy = y2 - y1;
                                int ldy = this.getLimitedDimension(dy, 1);
                                int dx = (int)(0.5f + (float)ldy * ratio);
                                int ldx = this.getLimitedDimension(dx, 0);
                                if (dx != ldx) {
                                    ldy = (int)(0.5f + (float)ldx / ratio);
                                }
                                this.mDimension.resolve(ldx);
                                this.mWidget.mVerticalRun.mDimension.resolve(ldy);
                                break block5;
                            }
                        }
                        break;
                    }
                    int size = 0;
                    int ratioSide = this.mWidget.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            size = (int)(0.5f + (float)this.mWidget.mVerticalRun.mDimension.value / this.mWidget.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            size = (int)(0.5f + (float)this.mWidget.mVerticalRun.mDimension.value * this.mWidget.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            size = (int)(0.5f + (float)this.mWidget.mVerticalRun.mDimension.value * this.mWidget.getDimensionRatio());
                            break;
                        }
                    }
                    this.mDimension.resolve(size);
                    break;
                }
                case 2: {
                    ConstraintWidget parent = this.mWidget.getParent();
                    if (parent == null || !parent.mHorizontalRun.mDimension.resolved) break;
                    float percent = this.mWidget.mMatchConstraintPercentWidth;
                    int targetDimensionValue = parent.mHorizontalRun.mDimension.value;
                    int size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.mDimension.resolve(size);
                    break;
                }
            }
        }
        if (!this.start.readyToSolve || !this.end.readyToSolve) {
            return;
        }
        if (this.start.resolved && this.end.resolved && this.mDimension.resolved) {
            return;
        }
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.mMatchConstraintDefaultWidth == 0 && !this.mWidget.isInHorizontalChain()) {
            startTarget = this.start.mTargets.get(0);
            endTarget = this.end.mTargets.get(0);
            startPos = startTarget.value + this.start.mMargin;
            endPos = endTarget.value + this.end.mMargin;
            int distance = endPos - startPos;
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            this.mDimension.resolve(distance);
            return;
        }
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.matchConstraintsType == 1 && this.start.mTargets.size() > 0 && this.end.mTargets.size() > 0) {
            startTarget = this.start.mTargets.get(0);
            endTarget = this.end.mTargets.get(0);
            startPos = startTarget.value + this.start.mMargin;
            endPos = endTarget.value + this.end.mMargin;
            int availableSpace = endPos - startPos;
            int value = Math.min(availableSpace, this.mDimension.wrapValue);
            int max = this.mWidget.mMatchConstraintMaxWidth;
            int min = this.mWidget.mMatchConstraintMinWidth;
            value = Math.max(min, value);
            if (max > 0) {
                value = Math.min(max, value);
            }
            this.mDimension.resolve(value);
        }
        if (!this.mDimension.resolved) {
            return;
        }
        startTarget = this.start.mTargets.get(0);
        endTarget = this.end.mTargets.get(0);
        startPos = startTarget.value + this.start.mMargin;
        endPos = endTarget.value + this.end.mMargin;
        float bias = this.mWidget.getHorizontalBiasPercent();
        if (startTarget == endTarget) {
            startPos = startTarget.value;
            endPos = endTarget.value;
            bias = 0.5f;
        }
        int distance = endPos - startPos - this.mDimension.value;
        this.start.resolve((int)(0.5f + (float)startPos + (float)distance * bias));
        this.end.resolve(this.start.value + this.mDimension.value);
    }

    @Override
    public void applyToWidget() {
        if (this.start.resolved) {
            this.mWidget.setX(this.start.value);
        }
    }
}

