/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.util.Arrays;

public class MonotonicCurveFit
extends CurveFit {
    private static final String TAG = "MonotonicCurveFit";
    private double[] mT;
    private double[][] mY;
    private double[][] mTangent;
    private boolean mExtrapolate = true;
    double[] mSlopeTemp;

    public MonotonicCurveFit(double[] time, double[][] y) {
        int n = time.length;
        int dim = y[0].length;
        this.mSlopeTemp = new double[dim];
        double[][] slope = new double[n - 1][dim];
        double[][] tangent = new double[n][dim];
        for (int j = 0; j < dim; ++j) {
            for (int i = 0; i < n - 1; ++i) {
                double dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * 0.5;
            }
            tangent[n - 1][j] = slope[n - 2][j];
        }
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < dim; ++j) {
                if (slope[i][j] == 0.0) {
                    tangent[i][j] = 0.0;
                    tangent[i + 1][j] = 0.0;
                    continue;
                }
                double a = tangent[i][j] / slope[i][j];
                double b = tangent[i + 1][j] / slope[i][j];
                double h = Math.hypot(a, b);
                if (!(h > 9.0)) continue;
                double t = 3.0 / h;
                tangent[i][j] = t * a * slope[i][j];
                tangent[i + 1][j] = t * b * slope[i][j];
            }
        }
        this.mT = time;
        this.mY = y;
        this.mTangent = tangent;
    }

    @Override
    public void getPos(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j];
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j];
                }
                return;
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j]);
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j]);
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[n - 1][j];
                }
                return;
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = (float)MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                return this.mY[0][j] + (t - this.mT[0]) * this.getSlope(this.mT[0], j);
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.getSlope(this.mT[n - 1], j);
            }
        } else {
            if (t <= this.mT[0]) {
                return this.mY[0][j];
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j];
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.diff(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        int n = this.mT.length;
        if (t < this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.diff(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0;
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }

    private static double interpolate(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        double x3 = x2 * x;
        return -2.0 * x3 * y2 + 3.0 * x2 * y2 + 2.0 * x3 * y1 - 3.0 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - 2.0 * h * t1 * x2 + h * t1 * x;
    }

    private static double diff(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        return -6.0 * x2 * y2 + 6.0 * x * y2 + 6.0 * x2 * y1 - 6.0 * x * y1 + 3.0 * h * t2 * x2 + 3.0 * h * t1 * x2 - 2.0 * h * t2 * x - 4.0 * h * t1 * x + h * t1;
    }

    public static MonotonicCurveFit buildWave(String configString) {
        String tmp;
        String str = configString;
        double[] values = new double[str.length() / 2];
        int start = configString.indexOf(40) + 1;
        int off1 = configString.indexOf(44, start);
        int count = 0;
        while (off1 != -1) {
            tmp = configString.substring(start, off1).trim();
            values[count++] = Double.parseDouble(tmp);
            start = off1 + 1;
            off1 = configString.indexOf(44, start);
        }
        off1 = configString.indexOf(41, start);
        tmp = configString.substring(start, off1).trim();
        values[count++] = Double.parseDouble(tmp);
        return MonotonicCurveFit.buildWave(Arrays.copyOf(values, count));
    }

    private static MonotonicCurveFit buildWave(double[] values) {
        int length = values.length * 3 - 2;
        int len = values.length - 1;
        double gap = 1.0 / (double)len;
        double[][] points = new double[length][1];
        double[] time = new double[length];
        for (int i = 0; i < values.length; ++i) {
            double v;
            points[i + len][0] = v = values[i];
            time[i + len] = (double)i * gap;
            if (i <= 0) continue;
            points[i + len * 2][0] = v + 1.0;
            time[i + len * 2] = (double)i * gap + 1.0;
            points[i - 1][0] = v - 1.0 - gap;
            time[i - 1] = (double)i * gap + -1.0 - gap;
        }
        return new MonotonicCurveFit(time, points);
    }
}

