/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import java.util.Arrays;

public class KeyFrameArray {

    static class FloatArray {
        int[] mKeys = new int[101];
        float[][] mValues = new float[101][];
        int mCount;
        private static final int EMPTY = 999;

        FloatArray() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.mKeys, 999);
            Arrays.fill((Object[])this.mValues, null);
            this.mCount = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.mKeys, this.mCount)));
            System.out.print("K: [");
            for (int i = 0; i < this.mCount; ++i) {
                System.out.print((i == 0 ? "" : ", ") + Arrays.toString(this.valueAt(i)));
            }
            System.out.println("]");
        }

        public int size() {
            return this.mCount;
        }

        public float[] valueAt(int i) {
            return this.mValues[this.mKeys[i]];
        }

        public int keyAt(int i) {
            return this.mKeys[i];
        }

        public void append(int position, float[] value) {
            if (this.mValues[position] != null) {
                this.remove(position);
            }
            this.mValues[position] = value;
            this.mKeys[this.mCount++] = position;
            Arrays.sort(this.mKeys);
        }

        public void remove(int position) {
            this.mValues[position] = null;
            int j = 0;
            for (int i = 0; i < this.mCount; ++i) {
                if (position == this.mKeys[i]) {
                    this.mKeys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.mKeys[i] = this.mKeys[j];
                }
                ++j;
            }
            --this.mCount;
        }
    }

    public static class CustomVar {
        int[] mKeys = new int[101];
        CustomVariable[] mValues = new CustomVariable[101];
        int mCount;
        private static final int EMPTY = 999;

        public CustomVar() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.mKeys, 999);
            Arrays.fill(this.mValues, null);
            this.mCount = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.mKeys, this.mCount)));
            System.out.print("K: [");
            for (int i = 0; i < this.mCount; ++i) {
                System.out.print((i == 0 ? "" : ", ") + this.valueAt(i));
            }
            System.out.println("]");
        }

        public int size() {
            return this.mCount;
        }

        public CustomVariable valueAt(int i) {
            return this.mValues[this.mKeys[i]];
        }

        public int keyAt(int i) {
            return this.mKeys[i];
        }

        public void append(int position, CustomVariable value) {
            if (this.mValues[position] != null) {
                this.remove(position);
            }
            this.mValues[position] = value;
            this.mKeys[this.mCount++] = position;
            Arrays.sort(this.mKeys);
        }

        public void remove(int position) {
            this.mValues[position] = null;
            int j = 0;
            for (int i = 0; i < this.mCount; ++i) {
                if (position == this.mKeys[i]) {
                    this.mKeys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.mKeys[i] = this.mKeys[j];
                }
                ++j;
            }
            --this.mCount;
        }
    }

    public static class CustomArray {
        int[] mKeys = new int[101];
        CustomAttribute[] mValues = new CustomAttribute[101];
        int mCount;
        private static final int EMPTY = 999;

        public CustomArray() {
            this.clear();
        }

        public void clear() {
            Arrays.fill(this.mKeys, 999);
            Arrays.fill(this.mValues, null);
            this.mCount = 0;
        }

        public void dump() {
            System.out.println("V: " + Arrays.toString(Arrays.copyOf(this.mKeys, this.mCount)));
            System.out.print("K: [");
            for (int i = 0; i < this.mCount; ++i) {
                System.out.print((i == 0 ? "" : ", ") + this.valueAt(i));
            }
            System.out.println("]");
        }

        public int size() {
            return this.mCount;
        }

        public CustomAttribute valueAt(int i) {
            return this.mValues[this.mKeys[i]];
        }

        public int keyAt(int i) {
            return this.mKeys[i];
        }

        public void append(int position, CustomAttribute value) {
            if (this.mValues[position] != null) {
                this.remove(position);
            }
            this.mValues[position] = value;
            this.mKeys[this.mCount++] = position;
            Arrays.sort(this.mKeys);
        }

        public void remove(int position) {
            this.mValues[position] = null;
            int j = 0;
            for (int i = 0; i < this.mCount; ++i) {
                if (position == this.mKeys[i]) {
                    this.mKeys[i] = 999;
                    ++j;
                }
                if (i != j) {
                    this.mKeys[i] = this.mKeys[j];
                }
                ++j;
            }
            --this.mCount;
        }
    }
}

