/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.util.Arrays;

public class ArcCurveFit
extends CurveFit {
    public static final int ARC_START_VERTICAL = 1;
    public static final int ARC_START_HORIZONTAL = 2;
    public static final int ARC_START_FLIP = 3;
    public static final int ARC_BELOW = 4;
    public static final int ARC_ABOVE = 5;
    public static final int ARC_START_LINEAR = 0;
    private static final int START_VERTICAL = 1;
    private static final int START_HORIZONTAL = 2;
    private static final int START_LINEAR = 3;
    private static final int DOWN_ARC = 4;
    private static final int UP_ARC = 5;
    private final double[] mTime;
    Arc[] mArcs;
    private boolean mExtrapolate = true;

    @Override
    public void getPos(double t, double[] v) {
        if (this.mExtrapolate) {
            if (t < this.mArcs[0].mTime1) {
                double t0 = this.mArcs[0].mTime1;
                double dt = t - this.mArcs[0].mTime1;
                int p = 0;
                if (this.mArcs[p].mLinear) {
                    v[0] = this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                    v[1] = this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                } else {
                    this.mArcs[p].setPoint(t0);
                    v[0] = this.mArcs[p].getX() + dt * this.mArcs[p].getDX();
                    v[1] = this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
                }
                return;
            }
            if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
                double t0 = this.mArcs[this.mArcs.length - 1].mTime2;
                double dt = t - t0;
                int p = this.mArcs.length - 1;
                if (this.mArcs[p].mLinear) {
                    v[0] = this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                    v[1] = this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                } else {
                    this.mArcs[p].setPoint(t);
                    v[0] = this.mArcs[p].getX() + dt * this.mArcs[p].getDX();
                    v[1] = this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
                }
                return;
            }
        } else {
            if (t < this.mArcs[0].mTime1) {
                t = this.mArcs[0].mTime1;
            }
            if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
                t = this.mArcs[this.mArcs.length - 1].mTime2;
            }
        }
        for (int i = 0; i < this.mArcs.length; ++i) {
            if (!(t <= this.mArcs[i].mTime2)) continue;
            if (this.mArcs[i].mLinear) {
                v[0] = this.mArcs[i].getLinearX(t);
                v[1] = this.mArcs[i].getLinearY(t);
                return;
            }
            this.mArcs[i].setPoint(t);
            v[0] = this.mArcs[i].getX();
            v[1] = this.mArcs[i].getY();
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        if (this.mExtrapolate) {
            if (t < this.mArcs[0].mTime1) {
                double t0 = this.mArcs[0].mTime1;
                double dt = t - this.mArcs[0].mTime1;
                int p = 0;
                if (this.mArcs[p].mLinear) {
                    v[0] = (float)(this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0));
                    v[1] = (float)(this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0));
                } else {
                    this.mArcs[p].setPoint(t0);
                    v[0] = (float)(this.mArcs[p].getX() + dt * this.mArcs[p].getDX());
                    v[1] = (float)(this.mArcs[p].getY() + dt * this.mArcs[p].getDY());
                }
                return;
            }
            if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
                double t0 = this.mArcs[this.mArcs.length - 1].mTime2;
                double dt = t - t0;
                int p = this.mArcs.length - 1;
                if (this.mArcs[p].mLinear) {
                    v[0] = (float)(this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0));
                    v[1] = (float)(this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0));
                } else {
                    this.mArcs[p].setPoint(t);
                    v[0] = (float)this.mArcs[p].getX();
                    v[1] = (float)this.mArcs[p].getY();
                }
                return;
            }
        } else if (t < this.mArcs[0].mTime1) {
            t = this.mArcs[0].mTime1;
        } else if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
            t = this.mArcs[this.mArcs.length - 1].mTime2;
        }
        for (int i = 0; i < this.mArcs.length; ++i) {
            if (!(t <= this.mArcs[i].mTime2)) continue;
            if (this.mArcs[i].mLinear) {
                v[0] = (float)this.mArcs[i].getLinearX(t);
                v[1] = (float)this.mArcs[i].getLinearY(t);
                return;
            }
            this.mArcs[i].setPoint(t);
            v[0] = (float)this.mArcs[i].getX();
            v[1] = (float)this.mArcs[i].getY();
            return;
        }
    }

    @Override
    public void getSlope(double t, double[] v) {
        if (t < this.mArcs[0].mTime1) {
            t = this.mArcs[0].mTime1;
        } else if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
            t = this.mArcs[this.mArcs.length - 1].mTime2;
        }
        for (int i = 0; i < this.mArcs.length; ++i) {
            if (!(t <= this.mArcs[i].mTime2)) continue;
            if (this.mArcs[i].mLinear) {
                v[0] = this.mArcs[i].getLinearDX(t);
                v[1] = this.mArcs[i].getLinearDY(t);
                return;
            }
            this.mArcs[i].setPoint(t);
            v[0] = this.mArcs[i].getDX();
            v[1] = this.mArcs[i].getDY();
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        if (this.mExtrapolate) {
            if (t < this.mArcs[0].mTime1) {
                double t0 = this.mArcs[0].mTime1;
                double dt = t - this.mArcs[0].mTime1;
                int p = 0;
                if (this.mArcs[p].mLinear) {
                    if (j == 0) {
                        return this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                    }
                    return this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                }
                this.mArcs[p].setPoint(t0);
                if (j == 0) {
                    return this.mArcs[p].getX() + dt * this.mArcs[p].getDX();
                }
                return this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
            }
            if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
                double t0 = this.mArcs[this.mArcs.length - 1].mTime2;
                double dt = t - t0;
                int p = this.mArcs.length - 1;
                if (j == 0) {
                    return this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                }
                return this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
            }
        } else if (t < this.mArcs[0].mTime1) {
            t = this.mArcs[0].mTime1;
        } else if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
            t = this.mArcs[this.mArcs.length - 1].mTime2;
        }
        for (int i = 0; i < this.mArcs.length; ++i) {
            if (!(t <= this.mArcs[i].mTime2)) continue;
            if (this.mArcs[i].mLinear) {
                if (j == 0) {
                    return this.mArcs[i].getLinearX(t);
                }
                return this.mArcs[i].getLinearY(t);
            }
            this.mArcs[i].setPoint(t);
            if (j == 0) {
                return this.mArcs[i].getX();
            }
            return this.mArcs[i].getY();
        }
        return Double.NaN;
    }

    @Override
    public double getSlope(double t, int j) {
        if (t < this.mArcs[0].mTime1) {
            t = this.mArcs[0].mTime1;
        }
        if (t > this.mArcs[this.mArcs.length - 1].mTime2) {
            t = this.mArcs[this.mArcs.length - 1].mTime2;
        }
        for (int i = 0; i < this.mArcs.length; ++i) {
            if (!(t <= this.mArcs[i].mTime2)) continue;
            if (this.mArcs[i].mLinear) {
                if (j == 0) {
                    return this.mArcs[i].getLinearDX(t);
                }
                return this.mArcs[i].getLinearDY(t);
            }
            this.mArcs[i].setPoint(t);
            if (j == 0) {
                return this.mArcs[i].getDX();
            }
            return this.mArcs[i].getDY();
        }
        return Double.NaN;
    }

    @Override
    public double[] getTimePoints() {
        return this.mTime;
    }

    public ArcCurveFit(int[] arcModes, double[] time, double[][] y) {
        this.mTime = time;
        this.mArcs = new Arc[time.length - 1];
        int mode = 1;
        int last = 1;
        for (int i = 0; i < this.mArcs.length; ++i) {
            switch (arcModes[i]) {
                case 1: {
                    mode = 1;
                    last = 1;
                    break;
                }
                case 2: {
                    mode = 2;
                    last = 2;
                    break;
                }
                case 3: {
                    last = mode = last == 1 ? 2 : 1;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 5: {
                    mode = 5;
                    break;
                }
                case 4: {
                    mode = 4;
                }
            }
            this.mArcs[i] = new Arc(mode, time[i], time[i + 1], y[i][0], y[i][1], y[i + 1][0], y[i + 1][1]);
        }
    }

    private static class Arc {
        private static final String TAG = "Arc";
        private static double[] sOurPercent = new double[91];
        double[] mLut;
        double mArcDistance;
        double mTime1;
        double mTime2;
        double mX1;
        double mX2;
        double mY1;
        double mY2;
        double mOneOverDeltaTime;
        double mEllipseA;
        double mEllipseB;
        double mEllipseCenterX;
        double mEllipseCenterY;
        double mArcVelocity;
        double mTmpSinAngle;
        double mTmpCosAngle;
        boolean mVertical;
        boolean mLinear = false;
        private static final double EPSILON = 0.001;

        Arc(int mode, double t1, double t2, double x1, double y1, double x2, double y2) {
            double dx = x2 - x1;
            double dy = y2 - y1;
            switch (mode) {
                case 1: {
                    this.mVertical = true;
                    break;
                }
                case 5: {
                    this.mVertical = dy < 0.0;
                    break;
                }
                case 4: {
                    this.mVertical = dy > 0.0;
                    break;
                }
                default: {
                    this.mVertical = false;
                }
            }
            this.mTime1 = t1;
            this.mTime2 = t2;
            this.mOneOverDeltaTime = 1.0 / (this.mTime2 - this.mTime1);
            if (3 == mode) {
                this.mLinear = true;
            }
            if (this.mLinear || Math.abs(dx) < 0.001 || Math.abs(dy) < 0.001) {
                this.mLinear = true;
                this.mX1 = x1;
                this.mX2 = x2;
                this.mY1 = y1;
                this.mY2 = y2;
                this.mArcDistance = Math.hypot(dy, dx);
                this.mArcVelocity = this.mArcDistance * this.mOneOverDeltaTime;
                this.mEllipseCenterX = dx / (this.mTime2 - this.mTime1);
                this.mEllipseCenterY = dy / (this.mTime2 - this.mTime1);
                return;
            }
            this.mLut = new double[101];
            this.mEllipseA = dx * (double)(this.mVertical ? -1 : 1);
            this.mEllipseB = dy * (double)(this.mVertical ? 1 : -1);
            this.mEllipseCenterX = this.mVertical ? x2 : x1;
            this.mEllipseCenterY = this.mVertical ? y1 : y2;
            this.buildTable(x1, y1, x2, y2);
            this.mArcVelocity = this.mArcDistance * this.mOneOverDeltaTime;
        }

        void setPoint(double time) {
            double percent = (this.mVertical ? this.mTime2 - time : time - this.mTime1) * this.mOneOverDeltaTime;
            double angle = 1.5707963267948966 * this.lookup(percent);
            this.mTmpSinAngle = Math.sin(angle);
            this.mTmpCosAngle = Math.cos(angle);
        }

        double getX() {
            return this.mEllipseCenterX + this.mEllipseA * this.mTmpSinAngle;
        }

        double getY() {
            return this.mEllipseCenterY + this.mEllipseB * this.mTmpCosAngle;
        }

        double getDX() {
            double vx = this.mEllipseA * this.mTmpCosAngle;
            double vy = -this.mEllipseB * this.mTmpSinAngle;
            double norm = this.mArcVelocity / Math.hypot(vx, vy);
            return this.mVertical ? -vx * norm : vx * norm;
        }

        double getDY() {
            double vx = this.mEllipseA * this.mTmpCosAngle;
            double vy = -this.mEllipseB * this.mTmpSinAngle;
            double norm = this.mArcVelocity / Math.hypot(vx, vy);
            return this.mVertical ? -vy * norm : vy * norm;
        }

        public double getLinearX(double t) {
            t = (t - this.mTime1) * this.mOneOverDeltaTime;
            return this.mX1 + t * (this.mX2 - this.mX1);
        }

        public double getLinearY(double t) {
            t = (t - this.mTime1) * this.mOneOverDeltaTime;
            return this.mY1 + t * (this.mY2 - this.mY1);
        }

        public double getLinearDX(double t) {
            return this.mEllipseCenterX;
        }

        public double getLinearDY(double t) {
            return this.mEllipseCenterY;
        }

        double lookup(double v) {
            if (v <= 0.0) {
                return 0.0;
            }
            if (v >= 1.0) {
                return 1.0;
            }
            double pos = v * (double)(this.mLut.length - 1);
            int iv = (int)pos;
            double off = pos - (double)((int)pos);
            return this.mLut[iv] + off * (this.mLut[iv + 1] - this.mLut[iv]);
        }

        private void buildTable(double x1, double y1, double x2, double y2) {
            int i;
            double a = x2 - x1;
            double b = y1 - y2;
            double lx = 0.0;
            double ly = 0.0;
            double dist = 0.0;
            for (i = 0; i < sOurPercent.length; ++i) {
                double angle = Math.toRadians(90.0 * (double)i / (double)(sOurPercent.length - 1));
                double s = Math.sin(angle);
                double c = Math.cos(angle);
                double px = a * s;
                double py = b * c;
                if (i > 0) {
                    Arc.sOurPercent[i] = dist += Math.hypot(px - lx, py - ly);
                }
                lx = px;
                ly = py;
            }
            this.mArcDistance = dist;
            i = 0;
            while (i < sOurPercent.length) {
                int n = i++;
                sOurPercent[n] = sOurPercent[n] / dist;
            }
            for (i = 0; i < this.mLut.length; ++i) {
                double ans;
                double pos = (double)i / (double)(this.mLut.length - 1);
                int index = Arrays.binarySearch(sOurPercent, pos);
                if (index >= 0) {
                    this.mLut[i] = (double)index / (double)(sOurPercent.length - 1);
                    continue;
                }
                if (index == -1) {
                    this.mLut[i] = 0.0;
                    continue;
                }
                int p1 = -index - 2;
                int p2 = -index - 1;
                this.mLut[i] = ans = ((double)p1 + (pos - sOurPercent[p1]) / (sOurPercent[p2] - sOurPercent[p1])) / (double)(sOurPercent.length - 1);
            }
        }
    }
}

